/*
 * Decompiled with CFR 0.152.
 */
package com.izettle.metrics.influxdb.tags;

import com.izettle.metrics.influxdb.tags.Transformer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PositionBasedTransformer
implements Transformer {
    private static final String SEPARATOR = "\\.";
    private final Map<String, Category> mappings;

    public PositionBasedTransformer(Map<String, Category> mappings) {
        this.mappings = mappings;
    }

    @Override
    public Map<String, String> getTags(String metricsName) {
        String[] parts = metricsName.split(SEPARATOR);
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Map.Entry<String, Category> entry : this.mappings.entrySet()) {
            Pattern pattern = entry.getValue().getMapping();
            int position = entry.getValue().position;
            if (parts.length <= position || !pattern.matcher(metricsName).matches()) continue;
            tags.put(entry.getKey(), parts[position]);
        }
        return tags;
    }

    public static class Category {
        private final int position;
        private final Pattern mapping;

        public Category(int position, String mapping) {
            if (position < 0) {
                throw new IllegalArgumentException("position should be gte 0");
            }
            this.position = position;
            this.mapping = Pattern.compile(mapping);
        }

        public int getPosition() {
            return this.position;
        }

        Pattern getMapping() {
            return this.mapping;
        }
    }
}

