/*
 * Decompiled with CFR 0.152.
 */
package com.izettle.metrics.influxdb.utils;

import com.izettle.metrics.influxdb.data.InfluxDbPoint;
import com.izettle.metrics.influxdb.data.InfluxDbWriteObject;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class InfluxDbWriteObjectSerializer {
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Pattern SPACE = Pattern.compile(" ");
    private static final Pattern EQUAL = Pattern.compile("=");
    private static final Pattern DOUBLE_QUOTE = Pattern.compile("\"");
    private static final Pattern FIELD = Pattern.compile("\\.");
    private final String measurementPrefix;

    public InfluxDbWriteObjectSerializer(String measurementPrefix) {
        this.measurementPrefix = measurementPrefix;
    }

    public String getLineProtocolString(InfluxDbWriteObject influxDbWriteObject) {
        StringBuilder stringBuilder = new StringBuilder();
        for (InfluxDbPoint point : influxDbWriteObject.getPoints()) {
            this.pointLineProtocol(point, influxDbWriteObject.getPrecision(), stringBuilder);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String getGroupedLineProtocolString(InfluxDbWriteObject influxDbWriteObject, String realMeasurement) {
        HashSet<Long> times = new HashSet<Long>();
        for (InfluxDbPoint point : influxDbWriteObject.getPoints()) {
            times.add(point.getTime());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Long time : times) {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            Map<String, String> tags = null;
            for (InfluxDbPoint point : influxDbWriteObject.getPoints()) {
                if (!point.getTime().equals(time)) continue;
                this.mergeFields(fields, point.getFields(), point.getMeasurement());
                tags = point.getTags();
            }
            this.lineProtocol(tags, fields, realMeasurement, time, influxDbWriteObject.getPrecision(), stringBuilder);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private void mergeFields(Map<String, Object> dest, Map<String, Object> src, String measurement) {
        String[] words = FIELD.split(measurement, 2);
        String tail = words.length == 2 ? words[1] : measurement;
        for (Map.Entry<String, Object> field : src.entrySet()) {
            if (src.entrySet().size() == 1 && field.getKey().equals("value")) {
                dest.put(tail, field.getValue());
                continue;
            }
            dest.put(tail + "." + field.getKey(), field.getValue());
        }
    }

    private void pointLineProtocol(InfluxDbPoint point, TimeUnit precision, StringBuilder stringBuilder) {
        this.lineProtocol(point.getTags(), point.getFields(), point.getMeasurement(), point.getTime(), precision, stringBuilder);
    }

    private void lineProtocol(Map<String, String> tags, Map<String, Object> fields, String measurement, Long time, TimeUnit precision, StringBuilder stringBuilder) {
        stringBuilder.append(this.escapeMeasurement(this.measurementPrefix + measurement));
        this.concatenatedTags(tags, stringBuilder);
        this.concatenateFields(fields, stringBuilder);
        this.formattedTime(time, precision, stringBuilder);
    }

    private void concatenatedTags(Map<String, String> tags, StringBuilder stringBuilder) {
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            stringBuilder.append(",");
            stringBuilder.append(this.escapeKey(tag.getKey())).append("=").append(this.escapeKey(tag.getValue()));
        }
        stringBuilder.append(" ");
    }

    private void concatenateFields(Map<String, Object> fields, StringBuilder stringBuilder) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(340);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(1);
        boolean firstField = true;
        for (Map.Entry<String, Object> field : fields.entrySet()) {
            Double doubleValue;
            Float floatValue;
            Object value = field.getValue();
            if (!(value instanceof Double) ? value instanceof Float && ((floatValue = (Float)value).isNaN() || floatValue.isInfinite()) : (doubleValue = (Double)value).isNaN() || doubleValue.isInfinite()) continue;
            if (!firstField) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.escapeKey(field.getKey())).append("=");
            firstField = false;
            if (value instanceof String) {
                String stringValue = (String)value;
                stringBuilder.append("\"").append(this.escapeField(stringValue)).append("\"");
                continue;
            }
            if (value instanceof Number) {
                stringBuilder.append(numberFormat.format(value));
                continue;
            }
            if (value instanceof Boolean) {
                stringBuilder.append(value);
                continue;
            }
            stringBuilder.append("\"").append(this.escapeField(value.toString())).append("\"");
        }
    }

    private void formattedTime(Long time, TimeUnit precision, StringBuilder stringBuilder) {
        if (null == time) {
            time = System.currentTimeMillis();
        }
        stringBuilder.append(" ").append(precision.convert(time, TimeUnit.MILLISECONDS));
    }

    private String escapeKey(String key) {
        String toBeEscaped = SPACE.matcher(key).replaceAll("\\\\ ");
        toBeEscaped = COMMA.matcher(toBeEscaped).replaceAll("\\\\,");
        return EQUAL.matcher(toBeEscaped).replaceAll("\\\\=");
    }

    private String escapeMeasurement(String key) {
        String toBeEscaped = SPACE.matcher(key).replaceAll("\\\\ ");
        return COMMA.matcher(toBeEscaped).replaceAll("\\\\,");
    }

    private String escapeField(String field) {
        return DOUBLE_QUOTE.matcher(field).replaceAll("\\\"");
    }
}

