/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.logger.Log;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.misc.IOUtils;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JdbcPooledConnectionSource
extends JdbcConnectionSource
implements ConnectionSource {
    private static Logger logger = LoggerFactory.getLogger(JdbcPooledConnectionSource.class);
    private static final int DEFAULT_MAX_CONNECTIONS_FREE = 5;
    private static final int DEFAULT_MAX_CONNECTION_AGE_MILLIS = 3600000;
    private static final int CHECK_CONNECTIONS_EVERY_MILLIS = 30000;
    private int maxConnectionsFree = 5;
    private long maxConnectionAgeMillis = 3600000L;
    private List<ConnectionMetaData> connFreeList = new ArrayList<ConnectionMetaData>();
    protected final Map<DatabaseConnection, ConnectionMetaData> connectionMap = new HashMap<DatabaseConnection, ConnectionMetaData>();
    private final Object lock = new Object();
    private ConnectionTester tester = null;
    private String pingStatment;
    private int openCount = 0;
    private int releaseCount = 0;
    private int closeCount = 0;
    private int maxEverUsed = 0;
    private int testLoopCount = 0;
    private long checkConnectionsEveryMillis = 30000L;
    private boolean testBeforeGetFromPool = false;
    private volatile boolean isOpen = true;

    public JdbcPooledConnectionSource() {
    }

    public JdbcPooledConnectionSource(String url) throws SQLException {
        this(url, null, null, null);
    }

    public JdbcPooledConnectionSource(String url, DatabaseType databaseType) throws SQLException {
        this(url, null, null, databaseType);
    }

    public JdbcPooledConnectionSource(String url, String username, String password) throws SQLException {
        this(url, username, password, null);
    }

    public JdbcPooledConnectionSource(String url, String username, String password, DatabaseType databaseType) throws SQLException {
        super(url, username, password, databaseType);
    }

    @Override
    public void initialize() throws SQLException {
        super.initialize();
        this.pingStatment = this.databaseType.getPingStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.initialized) {
            throw new IOException(((Object)((Object)this)).getClass().getSimpleName() + " was not initialized properly");
        }
        logger.debug("closing");
        Object object = this.lock;
        synchronized (object) {
            for (ConnectionMetaData connMetaData : this.connFreeList) {
                this.closeConnectionQuietly(connMetaData);
            }
            this.connFreeList.clear();
            this.connFreeList = null;
            this.connectionMap.clear();
            this.isOpen = false;
        }
    }

    @Override
    public DatabaseConnection getReadOnlyConnection(String tableName) throws SQLException {
        return this.getReadWriteConnection(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseConnection getReadWriteConnection(String tableName) throws SQLException {
        this.checkInitializedSqlException();
        DatabaseConnection conn = this.getSavedConnection();
        if (conn != null) {
            return conn;
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.connFreeList.size() > 0) {
                ConnectionMetaData connMetaData = this.getFreeConnection();
                if (connMetaData == null) continue;
                if (this.testBeforeGetFromPool && !this.testConnection(connMetaData)) {
                    this.closeConnectionQuietly(connMetaData);
                    continue;
                }
                logger.debug("reusing connection {}", (Object)connMetaData);
                return connMetaData.connection;
            }
            DatabaseConnection connection = this.makeConnection(logger);
            ++this.openCount;
            this.connectionMap.put(connection, new ConnectionMetaData(connection, this.maxConnectionAgeMillis));
            int maxInUse = this.connectionMap.size();
            if (maxInUse > this.maxEverUsed) {
                this.maxEverUsed = maxInUse;
            }
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(DatabaseConnection connection) throws SQLException {
        this.checkInitializedSqlException();
        if (this.isSavedConnection(connection)) {
            return;
        }
        boolean isClosed = connection.isClosed();
        if (!isClosed && !connection.isAutoCommit()) {
            connection.rollback(null);
            connection.setAutoCommit(true);
        }
        Object object = this.lock;
        synchronized (object) {
            ++this.releaseCount;
            if (isClosed) {
                ConnectionMetaData meta = this.connectionMap.remove(connection);
                if (meta == null) {
                    logger.debug("dropping already closed unknown connection {}", (Object)connection);
                } else {
                    logger.debug("dropping already closed connection {}", (Object)meta);
                }
                return;
            }
            if (this.connFreeList == null) {
                this.closeConnection(connection);
                return;
            }
            ConnectionMetaData meta = this.connectionMap.get(connection);
            if (meta == null) {
                logger.error("should have found connection {} in the map", (Object)connection);
                this.closeConnection(connection);
            } else {
                meta.noteUsed();
                this.connFreeList.add(meta);
                logger.debug("cache released connection {}", (Object)meta);
                if (this.connFreeList.size() > this.maxConnectionsFree) {
                    meta = this.connFreeList.remove(0);
                    logger.debug("cache too full, closing connection {}", (Object)meta);
                    this.closeConnection(meta.connection);
                }
                if (this.checkConnectionsEveryMillis > 0L && this.tester == null) {
                    this.tester = new ConnectionTester();
                    this.tester.setName(((Object)((Object)this)).getClass().getSimpleName() + " connection tester");
                    this.tester.setDaemon(true);
                    this.tester.start();
                }
            }
        }
    }

    @Override
    public boolean saveSpecialConnection(DatabaseConnection connection) throws SQLException {
        this.checkInitializedIllegalStateException();
        boolean saved = this.saveSpecial(connection);
        if (logger.isLevelEnabled(Log.Level.DEBUG)) {
            ConnectionMetaData meta = this.connectionMap.get(connection);
            logger.debug("saved special connection {}", (Object)meta);
        }
        return saved;
    }

    @Override
    public void clearSpecialConnection(DatabaseConnection connection) {
        this.checkInitializedIllegalStateException();
        boolean cleared = this.clearSpecial(connection, logger);
        if (logger.isLevelEnabled(Log.Level.DEBUG)) {
            ConnectionMetaData meta = this.connectionMap.get(connection);
            if (cleared) {
                logger.debug("cleared special connection {}", (Object)meta);
            } else {
                logger.debug("special connection {} not saved", (Object)meta);
            }
        }
    }

    @Override
    public boolean isOpen(String tableName) {
        return this.isOpen;
    }

    @Override
    public boolean isSingleConnection(String tableName) {
        return false;
    }

    public void setMaxConnectionsFree(int maxConnectionsFree) {
        this.maxConnectionsFree = maxConnectionsFree;
    }

    public void setMaxConnectionAgeMillis(long maxConnectionAgeMillis) {
        this.maxConnectionAgeMillis = maxConnectionAgeMillis;
    }

    public int getOpenCount() {
        return this.openCount;
    }

    public int getReleaseCount() {
        return this.releaseCount;
    }

    public int getCloseCount() {
        return this.closeCount;
    }

    public int getMaxConnectionsEverUsed() {
        return this.maxEverUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentConnectionsFree() {
        Object object = this.lock;
        synchronized (object) {
            return this.connFreeList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentConnectionsManaged() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionMap.size();
        }
    }

    public void setCheckConnectionsEveryMillis(long checkConnectionsEveryMillis) {
        this.checkConnectionsEveryMillis = checkConnectionsEveryMillis;
    }

    public void setTestBeforeGet(boolean testBeforeGetFromPool) {
        this.testBeforeGetFromPool = testBeforeGetFromPool;
    }

    public int getTestLoopCount() {
        return this.testLoopCount;
    }

    protected void closeConnection(DatabaseConnection connection) throws SQLException {
        ConnectionMetaData meta = this.connectionMap.remove(connection);
        IOUtils.closeThrowSqlException((Closeable)connection, (String)"SQL connection");
        logger.debug("closed connection {}", (Object)meta);
        ++this.closeCount;
    }

    protected void closeConnectionQuietly(ConnectionMetaData connMetaData) {
        try {
            this.closeConnection(connMetaData.connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected boolean testConnection(ConnectionMetaData connMetaData) {
        try {
            long result = connMetaData.connection.queryForLong(this.pingStatment);
            logger.trace("tested connection {}, got {}", (Object)connMetaData, (Object)result);
            return true;
        }
        catch (Exception e) {
            logger.debug((Throwable)e, "testing connection {} threw exception: {}", (Object)connMetaData, (Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionMetaData getFreeConnection() {
        Object object = this.lock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            while (this.connFreeList.size() > 0) {
                ConnectionMetaData connMetaData = this.connFreeList.remove(0);
                if (connMetaData.isExpired(now)) {
                    this.closeConnectionQuietly(connMetaData);
                    continue;
                }
                connMetaData.noteUsed();
                return connMetaData;
            }
        }
        return null;
    }

    private void checkInitializedSqlException() throws SQLException {
        if (!this.initialized) {
            throw new SQLException(((Object)((Object)this)).getClass().getSimpleName() + " was not initialized properly");
        }
    }

    private void checkInitializedIllegalStateException() {
        if (!this.initialized) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " was not initialized properly");
        }
    }

    private class ConnectionTester
    extends Thread {
        private Set<ConnectionMetaData> testedSet = new HashSet<ConnectionMetaData>();

        private ConnectionTester() {
        }

        @Override
        public void run() {
            while (JdbcPooledConnectionSource.this.checkConnectionsEveryMillis > 0L) {
                try {
                    Thread.sleep(JdbcPooledConnectionSource.this.checkConnectionsEveryMillis);
                    if (this.testConnections()) continue;
                    return;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean testConnections() {
            this.testedSet.clear();
            long now = System.currentTimeMillis();
            ConnectionMetaData connMetaData = null;
            boolean closeLast = false;
            while (true) {
                JdbcPooledConnectionSource.this.testLoopCount++;
                Object object = JdbcPooledConnectionSource.this.lock;
                synchronized (object) {
                    if (closeLast) {
                        if (connMetaData != null) {
                            JdbcPooledConnectionSource.this.closeConnectionQuietly(connMetaData);
                            connMetaData = null;
                        }
                        closeLast = false;
                    }
                    if (JdbcPooledConnectionSource.this.connFreeList == null) {
                        return false;
                    }
                    if (connMetaData != null) {
                        JdbcPooledConnectionSource.this.connFreeList.add(connMetaData);
                    }
                    if (JdbcPooledConnectionSource.this.connFreeList.isEmpty()) {
                        return true;
                    }
                    connMetaData = (ConnectionMetaData)JdbcPooledConnectionSource.this.connFreeList.get(0);
                    if (this.testedSet.contains(connMetaData)) {
                        return true;
                    }
                    connMetaData = (ConnectionMetaData)JdbcPooledConnectionSource.this.connFreeList.remove(0);
                    if (connMetaData.isExpired(now)) {
                        JdbcPooledConnectionSource.this.closeConnectionQuietly(connMetaData);
                        connMetaData = null;
                        continue;
                    }
                }
                if (JdbcPooledConnectionSource.this.testConnection(connMetaData)) {
                    this.testedSet.add(connMetaData);
                    continue;
                }
                closeLast = true;
            }
        }
    }

    protected static class ConnectionMetaData {
        public final DatabaseConnection connection;
        private final long expiresMillis;
        private long lastUsed;

        public ConnectionMetaData(DatabaseConnection connection, long maxConnectionAgeMillis) {
            this.connection = connection;
            long now = System.currentTimeMillis();
            this.expiresMillis = maxConnectionAgeMillis > Long.MAX_VALUE - now ? Long.MAX_VALUE : now + maxConnectionAgeMillis;
            this.lastUsed = now;
        }

        public boolean isExpired(long now) {
            return this.expiresMillis <= now;
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public void noteUsed() {
            this.lastUsed = System.currentTimeMillis();
        }

        public String toString() {
            return "#" + this.hashCode();
        }
    }
}

