/*
 * Decompiled with CFR 0.152.
 */
package com.j2mvc.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieUtil {
    public static void setCookie(HttpServletResponse response, String cookieName, String value, Integer maxAge, String path, String pattern) {
        if (response != null) {
            response.addCookie(CookieUtil.addCookie(cookieName, value, maxAge, path, pattern));
        }
    }

    public static Cookie addCookie(String name, String value, Integer maxAge, String path, String pattern) {
        try {
            Cookie cookie = new Cookie(name, value);
            if (maxAge != null) {
                cookie.setMaxAge(maxAge.intValue());
            }
            cookie.setPath(path != null && !path.equals("") ? path : "/");
            if (pattern != null && !pattern.equals("")) {
                cookie.setDomain(pattern);
            }
            return cookie;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void reMoveCookie(HttpServletRequest request, HttpServletResponse response, String name, String path, String pattern) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!cookie.getName().equals(name)) continue;
                cookie = new Cookie(name, null);
                if (pattern != null && !pattern.equals("")) {
                    cookie.setDomain(pattern);
                }
                cookie.setPath(path != null && !path.equals("") ? path : "/");
                cookie.setMaxAge(0);
                cookie.setValue(null);
                response.addCookie(cookie);
            }
        }
    }

    public static Cookie getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static String getCookieValue(HttpServletRequest request, String cookieName) {
        Cookie cookie = CookieUtil.getCookie(request, cookieName);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }
}

