/*
 * Decompiled with CFR 0.152.
 */
package com.j2mvc.util;

import com.j2mvc.util.StringUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTimeUtil {
    public static final String TODAY = "\u4eca\u5929";
    public static final String YESTERDAY = "\u6628\u5929";
    public static final String TOMORROW = "\u660e\u5929";
    public static final String BEFORE_YESTERDAY = "\u524d\u5929";
    public static final String AFTER_TOMORROW = "\u540e\u5929";
    public static final String SUNDAY = "\u5468\u65e5";
    public static final String MONDAY = "\u5468\u4e00";
    public static final String TUESDAY = "\u5468\u4e8c";
    public static final String WEDNESDAY = "\u5468\u4e09";
    public static final String THURSDAY = "\u5468\u56db";
    public static final String FRIDAY = "\u5468\u4e94";
    public static final String SATURDAY = "\u5468\u516d";
    public static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    public static DateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String getDateDetail(String date) {
        Calendar today = Calendar.getInstance();
        Calendar target = Calendar.getInstance();
        try {
            today.setTime(new Date());
            today.set(10, 0);
            today.set(12, 0);
            today.set(13, 0);
            target.setTime(dateTimeFormat.parse(date));
            target.set(10, 0);
            target.set(12, 0);
            target.set(13, 0);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        long intervalMilli = target.getTimeInMillis() - today.getTimeInMillis();
        int xcts = (int)(intervalMilli / 86400000L);
        return DateTimeUtil.showDateDetail(xcts, target);
    }

    public static String getWeekDay(Date date) {
        Calendar target = Calendar.getInstance();
        target.setTime(date);
        target.set(10, 0);
        target.set(12, 0);
        target.set(13, 0);
        return DateTimeUtil.getWeekDay(target);
    }

    public static int getDayOfWeek(String source) {
        Date date = null;
        try {
            date = dateFormat.parse(source);
            Calendar target = Calendar.getInstance();
            target.setTime(date);
            target.set(10, 0);
            target.set(12, 0);
            target.set(13, 0);
            return target.get(7);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static String showDateDetail(int xcts, Calendar target) {
        switch (xcts) {
            case 0: {
                return TODAY;
            }
            case 1: {
                return TOMORROW;
            }
            case 2: {
                return AFTER_TOMORROW;
            }
            case -1: {
                return YESTERDAY;
            }
            case -2: {
                return BEFORE_YESTERDAY;
            }
        }
        return DateTimeUtil.getWeekDay(target);
    }

    private static String getWeekDay(Calendar target) {
        int dayForWeek = 0;
        dayForWeek = target.get(7);
        switch (dayForWeek) {
            case 1: {
                return SUNDAY;
            }
            case 2: {
                return MONDAY;
            }
            case 3: {
                return TUESDAY;
            }
            case 4: {
                return WEDNESDAY;
            }
            case 5: {
                return THURSDAY;
            }
            case 6: {
                return FRIDAY;
            }
            case 7: {
                return SATURDAY;
            }
        }
        return null;
    }

    public static String getDateTimeCountStr(Date startDate, Date endDate) {
        long l = DateTimeUtil.getDateTimeCount(startDate, endDate);
        int day = (int)(l / 86400000L);
        return day + "\u5929";
    }

    public static long getDateTimeCount(Date startDate, Date endDate) {
        Calendar fromCalendar = Calendar.getInstance();
        fromCalendar.setTime(startDate);
        fromCalendar.set(11, 0);
        fromCalendar.set(12, 0);
        fromCalendar.set(13, 0);
        fromCalendar.set(14, 0);
        Calendar toCalendar = Calendar.getInstance();
        toCalendar.setTime(endDate);
        toCalendar.set(11, 0);
        toCalendar.set(12, 0);
        toCalendar.set(13, 0);
        toCalendar.set(14, 0);
        return toCalendar.getTime().getTime() - fromCalendar.getTime().getTime();
    }

    public static boolean compareDate(String a, String b) {
        if (StringUtils.isEmpty(a) || StringUtils.isEmpty(b)) {
            return false;
        }
        try {
            Date ad = dateFormat.parse(a);
            Date bd = dateFormat.parse(b);
            return ad.getTime() > bd.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isSame(String a, String b) {
        if (StringUtils.isEmpty(a) || StringUtils.isEmpty(b)) {
            return false;
        }
        try {
            Date ad = dateFormat.parse(a);
            Date bd = dateFormat.parse(b);
            return ad.getTime() == bd.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int calMonthDays(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day);
        int maxDay = calendar.getActualMaximum(5);
        return maxDay;
    }

    public static String parseDateStr(String str) {
        if (StringUtils.isEmpty(str)) {
            return "";
        }
        Calendar nc = Calendar.getInstance();
        nc.setTime(new Date());
        Calendar tc = Calendar.getInstance();
        try {
            tc.setTime(dateFormat.parse(str));
            if (tc.get(1) == nc.get(1)) {
                long nowTime = nc.getTime().getTime();
                long targetTime = tc.getTime().getTime();
                long oneDayTime = 86400000L;
                if (targetTime > nowTime) {
                    long l = targetTime - nowTime;
                    float o = (float)l / (float)oneDayTime;
                    if (o < 1.0f) {
                        return TODAY;
                    }
                    if (o > 1.0f && o < 2.0f) {
                        return TOMORROW;
                    }
                    if (o > 2.0f && o < 3.0f) {
                        return AFTER_TOMORROW;
                    }
                    return tc.get(2) + 1 + "\u6708" + tc.get(5) + "\u65e5";
                }
                long l = nowTime - targetTime;
                float o = (float)l / (float)oneDayTime;
                if (o < 1.0f) {
                    return TODAY;
                }
                if (o > 1.0f && o < 2.0f) {
                    return YESTERDAY;
                }
                if (o > 2.0f && o < 3.0f) {
                    return BEFORE_YESTERDAY;
                }
                return tc.get(2) + 1 + "\u6708" + tc.get(5) + "\u65e5";
            }
            return tc.get(1) + "\u5e74" + (tc.get(2) + 1) + "\u6708" + tc.get(5) + "\u65e5";
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }
}

