/*
 * Decompiled with CFR 0.152.
 */
package com.j2mvc.util;

import com.j2mvc.util.Pagination;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class HtmlPagination {
    private Document document;
    List<Node> nodes;
    Pagination pagination;
    Integer total;

    public HtmlPagination(String html, int pageSize, int p) {
        this.document = Jsoup.parse((String)(html != null ? html : ""));
        this.parse();
        this.pagination = new Pagination(this.total, pageSize, p);
    }

    public HtmlPagination(String html, int pageSize, int p, String pageName) {
        this.document = Jsoup.parse((String)(html != null ? html : ""));
        this.parse();
        this.pagination = new Pagination(this.total, pageSize, p, pageName);
    }

    private void parse() {
        Elements elems = this.document.getElementsByTag("body");
        Element body = elems.first();
        this.nodes = body.childNodes();
        this.total = this.nodes.size();
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public String html() {
        int startIndex = this.pagination.getStartIndex() > this.total ? this.total : this.pagination.getStartIndex();
        int endIndex = this.pagination.getEndIndex() > this.total ? this.total : this.pagination.getEndIndex();
        List<Node> list = this.nodes.subList(startIndex, endIndex);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            result.append(list.get(i).outerHtml());
        }
        return result.toString();
    }
}

