/*
 * Decompiled with CFR 0.152.
 */
package com.j2mvc.util;

public class OSType {
    public static void main(String[] args) {
        System.out.println((Object)OSinfo.getOSname());
    }

    public static class OSinfo {
        private static final String OS = System.getProperty("os.name").toLowerCase();
        private static final OSinfo _instance = new OSinfo();
        private EPlatform platform;

        private OSinfo() {
        }

        public static boolean isLinux() {
            return OS.indexOf("linux") >= 0;
        }

        public static boolean isMacOS() {
            return OS.indexOf("mac") >= 0 && OS.indexOf("os") > 0 && OS.indexOf("x") < 0;
        }

        public static boolean isMacOSX() {
            return OS.indexOf("mac") >= 0 && OS.indexOf("os") > 0 && OS.indexOf("x") > 0;
        }

        public static boolean isWindows() {
            return OS.indexOf("windows") >= 0;
        }

        public static boolean isOS2() {
            return OS.indexOf("os/2") >= 0;
        }

        public static boolean isSolaris() {
            return OS.indexOf("solaris") >= 0;
        }

        public static boolean isSunOS() {
            return OS.indexOf("sunos") >= 0;
        }

        public static boolean isMPEiX() {
            return OS.indexOf("mpe/ix") >= 0;
        }

        public static boolean isHPUX() {
            return OS.indexOf("hp-ux") >= 0;
        }

        public static boolean isAix() {
            return OS.indexOf("aix") >= 0;
        }

        public static boolean isOS390() {
            return OS.indexOf("os/390") >= 0;
        }

        public static boolean isFreeBSD() {
            return OS.indexOf("freebsd") >= 0;
        }

        public static boolean isIrix() {
            return OS.indexOf("irix") >= 0;
        }

        public static boolean isDigitalUnix() {
            return OS.indexOf("digital") >= 0 && OS.indexOf("unix") > 0;
        }

        public static boolean isNetWare() {
            return OS.indexOf("netware") >= 0;
        }

        public static boolean isOSF1() {
            return OS.indexOf("osf1") >= 0;
        }

        public static boolean isOpenVMS() {
            return OS.indexOf("openvms") >= 0;
        }

        public static EPlatform getOSname() {
            OSinfo._instance.platform = OSinfo.isAix() ? EPlatform.AIX : (OSinfo.isDigitalUnix() ? EPlatform.Digital_Unix : (OSinfo.isFreeBSD() ? EPlatform.FreeBSD : (OSinfo.isHPUX() ? EPlatform.HP_UX : (OSinfo.isIrix() ? EPlatform.Irix : (OSinfo.isLinux() ? EPlatform.Linux : (OSinfo.isMacOS() ? EPlatform.Mac_OS : (OSinfo.isMacOSX() ? EPlatform.Mac_OS_X : (OSinfo.isMPEiX() ? EPlatform.MPEiX : (OSinfo.isNetWare() ? EPlatform.NetWare_411 : (OSinfo.isOpenVMS() ? EPlatform.OpenVMS : (OSinfo.isOS2() ? EPlatform.OS2 : (OSinfo.isOS390() ? EPlatform.OS390 : (OSinfo.isOSF1() ? EPlatform.OSF1 : (OSinfo.isSolaris() ? EPlatform.Solaris : (OSinfo.isSunOS() ? EPlatform.SunOS : (OSinfo.isWindows() ? EPlatform.Windows : EPlatform.Others))))))))))))))));
            return OSinfo._instance.platform;
        }
    }

    static enum EPlatform {
        Any("any"),
        Linux("Linux"),
        Mac_OS("Mac OS"),
        Mac_OS_X("Mac OS X"),
        Windows("Windows"),
        OS2("OS/2"),
        Solaris("Solaris"),
        SunOS("SunOS"),
        MPEiX("MPE/iX"),
        HP_UX("HP-UX"),
        AIX("AIX"),
        OS390("OS/390"),
        FreeBSD("FreeBSD"),
        Irix("Irix"),
        Digital_Unix("Digital Unix"),
        NetWare_411("NetWare"),
        OSF1("OSF1"),
        OpenVMS("OpenVMS"),
        Others("Others");

        private String description;

        private EPlatform(String desc) {
            this.description = desc;
        }

        public String toString() {
            return this.description;
        }
    }
}

