/*
 * Decompiled with CFR 0.152.
 */
package com.j2mvc.util;

public class Pagination {
    public static final int DEFAULT_MAXNUM = 11;
    private String pageName = "page";
    private Integer total;
    private Integer pageSize;
    private Integer page;
    private Integer pageTotal;
    private Integer startIndex;
    private Integer endIndex;
    private String html;

    public Pagination(Integer total, Integer pageSize, Integer page) {
        this.total = total != null ? total : 0;
        this.pageSize = pageSize != null ? pageSize : 0;
        this.page = page != null ? page : 0;
        this.cal();
    }

    public Pagination(Integer total, Integer pageSize, Integer page, String pageName) {
        this.total = total != null ? total : 0;
        this.pageSize = pageSize != null ? pageSize : 0;
        this.page = page != null ? page : 0;
        this.pageName = pageName != null ? pageName : this.pageName;
        this.cal();
    }

    private void cal() {
        this.pageTotal = ((float)this.total.intValue() + 0.0f) / ((float)this.pageSize.intValue() + 0.0f) > (float)(this.total / this.pageSize) ? this.total / this.pageSize + 1 : this.total / this.pageSize;
        this.startIndex = this.page > 1 ? this.page * this.pageSize - this.pageSize : 0;
        this.endIndex = this.startIndex + this.pageSize;
        this.endIndex = this.endIndex > this.total ? this.total : this.endIndex;
    }

    public String getHtml() {
        this.html = this.getHtml("", 11, false);
        return this.html;
    }

    public String getHtml(boolean showForce) {
        this.html = this.getHtml("", 11, showForce);
        return this.html;
    }

    public String getHtml(int maxNum) {
        return this.getHtml("", maxNum, false);
    }

    public String getHtml(int maxNum, boolean showForce) {
        return this.getHtml("", maxNum, showForce);
    }

    public String getHtml(String url) {
        return this.getHtml("", 11, false);
    }

    public String getHtml(String url, boolean showForce) {
        return this.getHtml("", 11, showForce);
    }

    public String getHtml(String url, int maxNum) {
        return this.getHtml(url, maxNum, false);
    }

    public String getHtml(String url, int maxNum, boolean showForce) {
        if (this.pageTotal < 2 && !showForce) {
            return "";
        }
        url = url != null ? url : "";
        url = url.indexOf("?") != -1 && !url.endsWith("?") ? url + "&" : url + "?";
        String html = "<div class='page'><div><ul>";
        html = html + "<li class='text'>\u5171" + this.total + "\u6761," + this.page + "/" + this.pageTotal + "\u9875.</li>";
        int startpage = 1;
        int endpage = maxNum = maxNum % 2 == 0 ? maxNum + 1 : maxNum;
        int showNum = maxNum;
        int halfNum = (maxNum - 1) / 2;
        startpage = this.page - halfNum > 1 ? this.page - halfNum : 1;
        endpage = this.page + halfNum < this.pageTotal ? this.page + halfNum : this.pageTotal;
        startpage = startpage > this.pageTotal - showNum && this.pageTotal > showNum ? this.pageTotal - showNum : startpage;
        endpage = endpage < showNum && endpage < this.pageTotal ? showNum : endpage;
        int n = endpage = endpage > this.pageTotal ? this.pageTotal : endpage;
        if (this.page > 1) {
            html = html + "<li class='p'><a href='" + url + this.pageName + "=1'>\u9996\u9875</a></li><li class='p'><a href='" + url + this.pageName + "=" + (this.page - 1) + "'>\u4e0a\u4e00\u9875</a></li>";
        }
        if (startpage > 1) {
            html = html + "<li class='p'><a href='" + url + this.pageName + "=1'>1</a></li>...";
        }
        if (this.pageTotal > 1) {
            for (int i = startpage; i <= endpage; ++i) {
                html = html + "<li " + (i == this.page ? "class='current'" : "") + "><a " + (i == this.page ? "" : "href='" + url + this.pageName + "=" + i + "'") + ">" + i + "</a></li>";
            }
        }
        if (endpage > 1 && endpage < this.pageTotal) {
            html = html + "...<li class='p'><a href='" + url + this.pageName + "=" + this.pageTotal + "'>" + this.pageTotal + "</a></li>";
        }
        if (this.page < this.pageTotal) {
            html = html + "<li class='p'><a href='" + url + this.pageName + "=" + (this.page + 1) + "'>\u4e0b\u4e00\u9875</a></li><li class='p'><a href='" + url + this.pageName + "=" + this.pageTotal + "'>\u5c3e\u9875</a></li>";
        }
        html = html + "</ul></div></div>";
        return html;
    }

    public String getHtmlOnlyPage(String url, int maxNum) {
        if (this.pageTotal < 2) {
            return "";
        }
        url = url != null ? url : "";
        url = url.indexOf("?") != -1 && !url.endsWith("?") ? url + "&" : url + "?";
        String html = "<div class='page'><div><ul>";
        html = html + "<li class='text'>" + this.page + "/" + this.pageTotal + ".</li>";
        int startpage = 1;
        int endpage = maxNum = maxNum % 2 == 0 ? maxNum + 1 : maxNum;
        int showNum = maxNum;
        int halfNum = (maxNum - 1) / 2;
        startpage = this.page - halfNum > 1 ? this.page - halfNum : 1;
        endpage = this.page + halfNum < this.pageTotal ? this.page + halfNum : this.pageTotal;
        startpage = startpage > this.pageTotal - showNum && this.pageTotal > showNum ? this.pageTotal - showNum : startpage;
        endpage = endpage < showNum && endpage < this.pageTotal ? showNum : endpage;
        int n = endpage = endpage > this.pageTotal ? this.pageTotal : endpage;
        if (startpage > 1) {
            html = html + "<li class='p'><a href='" + url + this.pageName + "=1'>1</a></li>...";
        }
        if (this.pageTotal > 1) {
            for (int i = startpage; i <= endpage; ++i) {
                html = html + "<li " + (i == this.page ? "class='current'" : "") + "><a " + (i == this.page ? "" : "href='" + url + this.pageName + "=" + i + "'") + ">" + i + "</a></li>";
            }
        }
        if (endpage > 1 && endpage < this.pageTotal) {
            html = html + "...<li class='p'><a href='" + url + this.pageName + "=" + this.pageTotal + "'>" + this.pageTotal + "</a></li>";
        }
        html = html + "</ul></div></div>";
        return html;
    }

    public String getBootstrapHtml(String url, int maxNum, boolean showForce) {
        if (this.pageTotal < 2 && !showForce) {
            return "";
        }
        url = url != null ? url : "";
        url = url.indexOf("?") != -1 && !url.endsWith("?") ? url + "&" : url + "?";
        String html = "<nav aria-label=\"Page navigation\"><ul class=\"pagination\">";
        int startpage = 1;
        int endpage = maxNum = maxNum % 2 == 0 ? maxNum + 1 : maxNum;
        int showNum = maxNum;
        int halfNum = (maxNum - 1) / 2;
        startpage = this.page - halfNum > 1 ? this.page - halfNum : 1;
        endpage = this.page + halfNum < this.pageTotal ? this.page + halfNum : this.pageTotal;
        startpage = startpage > this.pageTotal - showNum && this.pageTotal > showNum ? this.pageTotal - showNum : startpage;
        endpage = endpage < showNum && endpage < this.pageTotal ? showNum : endpage;
        int n = endpage = endpage > this.pageTotal ? this.pageTotal : endpage;
        if (this.page > 1) {
            html = html + "<li><a href='" + url + this.pageName + "=" + (this.page - 1) + "' aria-label=\"Previous\"><span aria-hidden=\"true\">&laquo;</span></a></li>";
        }
        if (startpage > 1) {
            html = html + "<li><a href='" + url + this.pageName + "=1'>1</a></li>";
        }
        if (this.pageTotal > 1) {
            for (int i = startpage; i <= endpage; ++i) {
                html = html + "<li " + (i == this.page ? "class='active'" : "") + "><a " + (i == this.page ? "" : "href='" + url + this.pageName + "=" + i + "'") + ">" + i + "</a></li>";
            }
        }
        if (this.page < this.pageTotal) {
            html = html + "<li class='p'><a href='" + url + this.pageName + "=" + (this.page + 1) + "' aria-label=\"Next\"><span aria-hidden=\"true\">&raquo;</span></a></li>";
        }
        html = html + "</ul></nav>";
        return html;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPageTotal() {
        return this.pageTotal;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageTotal(Integer pageTotal) {
        this.pageTotal = pageTotal;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public void setEndIndex(Integer endIndex) {
        this.endIndex = endIndex;
    }

    public static void main(String ... args) {
        int page = 1;
        int perno = 1;
        int total = 60;
        Pagination pu = new Pagination(total, perno, page);
        String url = "?";
        Pagination.$(pu.getHtml(url, 10));
    }

    public static void $(String s) {
        System.out.println(s);
    }
}

