/*
 * Decompiled with CFR 0.152.
 */
package com.j2mvc.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyingUtil {
    public static String[] stringToPinyin(String src) {
        return PinyingUtil.stringToPinyin(src, false, null);
    }

    public static String[] stringToPinyin(String src, String separator) {
        return PinyingUtil.stringToPinyin(src, true, separator);
    }

    public static String[] stringToPinyin(String src, boolean isPolyphone, String separator) {
        if ("".equals(src) || null == src) {
            return null;
        }
        char[] srcChar = src.toCharArray();
        int srcCount = srcChar.length;
        String[] srcStr = new String[srcCount];
        for (int i = 0; i < srcCount; ++i) {
            srcStr[i] = PinyingUtil.charToPinyin(srcChar[i], isPolyphone, separator);
        }
        return srcStr;
    }

    public static String charToPinyin(char src, boolean isPolyphone, String separator) {
        StringBuffer tempPinying;
        block6: {
            HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
            defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            tempPinying = new StringBuffer();
            if (src > '\u0080') {
                try {
                    String[] strs = PinyinHelper.toHanyuPinyinStringArray((char)src, (HanyuPinyinOutputFormat)defaultFormat);
                    if (isPolyphone && null != separator) {
                        for (int i = 0; i < strs.length; ++i) {
                            tempPinying.append(strs[i]);
                            if (strs.length == i + 1) continue;
                            tempPinying.append(separator);
                        }
                        break block6;
                    }
                    tempPinying.append(strs[0]);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
            } else {
                tempPinying.append(src);
            }
        }
        return tempPinying.toString();
    }

    public static String hanziToPinyin(String hanzi) {
        return PinyingUtil.hanziToPinyin(hanzi, " ");
    }

    public static String hanziToPinyin(String hanzi, String separator) {
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        String pinyingStr = "";
        try {
            pinyingStr = PinyinHelper.toHanyuPinyinString((String)hanzi, (HanyuPinyinOutputFormat)defaultFormat, (String)separator);
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return pinyingStr;
    }

    public static String stringArrayToString(String[] str, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length; ++i) {
            sb.append(str[i]);
            if (str.length == i + 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String stringArrayToString(String[] str) {
        return PinyingUtil.stringArrayToString(str, "");
    }

    public static String charArrayToString(char[] ch, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ch.length; ++i) {
            sb.append(ch[i]);
            if (ch.length == i + 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String charArrayToString(char[] ch) {
        return PinyingUtil.charArrayToString(ch, " ");
    }

    public static char[] getHeadByChar(char src, boolean isCapital) {
        if (src <= '\u0080') {
            return new char[]{src};
        }
        String[] pinyingStr = PinyinHelper.toHanyuPinyinStringArray((char)src);
        int polyphoneSize = pinyingStr.length;
        char[] headChars = new char[polyphoneSize];
        int i = 0;
        for (String s : pinyingStr) {
            char headChar = s.charAt(0);
            headChars[i] = isCapital ? Character.toUpperCase(headChar) : headChar;
            ++i;
        }
        return headChars;
    }

    public static char[] getHeadByChar(char src) {
        return PinyingUtil.getHeadByChar(src, true);
    }

    public static String[] getHeadByString(String src) {
        return PinyingUtil.getHeadByString(src, true);
    }

    public static String[] getHeadByString(String src, boolean isCapital) {
        return PinyingUtil.getHeadByString(src, isCapital, null);
    }

    public static String[] getHeadByString(String src, boolean isCapital, String separator) {
        char[] chars = src.toCharArray();
        String[] headString = new String[chars.length];
        int i = 0;
        for (char ch : chars) {
            char[] chs = PinyingUtil.getHeadByChar(ch, isCapital);
            StringBuffer sb = new StringBuffer();
            if (null != separator) {
                int j = 1;
                for (char ch1 : chs) {
                    sb.append(ch1);
                    if (j != chs.length) {
                        sb.append(separator);
                    }
                    ++j;
                }
            } else {
                sb.append(chs[0]);
            }
            headString[i] = sb.toString();
            ++i;
        }
        return headString;
    }

    public static void main(String[] args) {
        System.out.println(PinyingUtil.hanziToPinyin("\u662f\u5426\u5927\u5199", ""));
    }
}

