/*
 * Decompiled with CFR 0.152.
 */
package com.j2mvc.util;

import com.j2mvc.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class PropertiesConfiguration {
    private static Logger logger = Logger.getLogger(PropertiesConfiguration.class.getCanonicalName());
    private Properties props = new Properties();
    private String configPath = "";

    public PropertiesConfiguration(String configPath) {
        String jarPath;
        File jarFile;
        String source;
        URL url;
        this.configPath = configPath.startsWith("/") ? configPath : "/" + configPath;
        InputStream is = null;
        File file = new File(this.configPath);
        if (!file.exists() && (url = this.getClass().getProtectionDomain().getCodeSource().getLocation()) != null && !(file = new File(source = (jarFile = new File(jarPath = url.getPath())).getParent() + "/.." + this.configPath)).exists()) {
            source = jarFile.getParent() + "/conf" + this.configPath;
            file = new File(source);
        }
        if (file.exists()) {
            logger.info("\u8bfb\u53d6properties\u914d\u7f6e\u6587\u4ef6\uff1a" + this.configPath);
            try {
                is = new FileInputStream(this.configPath);
            }
            catch (FileNotFoundException e) {
                logger.warning("\u8bfb\u53d6properties\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff1a" + e);
            }
        }
        if (is == null) {
            is = this.getClass().getResourceAsStream(this.configPath);
        }
        if (is == null) {
            logger.warning("\u8bfb\u53d6properties\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff1a\u8f93\u5165\u6d41\u4e3a\u7a7a\u3002");
            return;
        }
        try {
            this.props.load(is);
        }
        catch (FileNotFoundException e) {
            logger.warning("\u8bfb\u53d6properties\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff1a" + e);
        }
        catch (Exception e) {
            logger.warning("\u8bfb\u53d6properties\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff1a" + e);
        }
    }

    public PropertiesConfiguration(File file) {
        try {
            this.configPath = file.getAbsolutePath();
            FileInputStream in = new FileInputStream(file);
            this.props.load(in);
        }
        catch (FileNotFoundException e) {
            logger.warning("\u8bfb\u53d6WEB\u914d\u7f6e\u65b9\u6cd5\u4fe1\u606f\u9519\u8bef" + e);
        }
        catch (IOException e) {
            logger.warning("\u8bfb\u53d6WEB\u914d\u7f6e\u65b9\u6cd5\u4fe1\u606f\u9519\u8bef" + e);
        }
    }

    public String get(String key) {
        if (this.props.containsKey(key)) {
            String value = this.props.getProperty(key);
            return StringUtils.getUtf8(value);
        }
        return "";
    }

    public Map<String, String> map() {
        Set<Map.Entry<Object, Object>> set = this.props.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
        HashMap<String, String> map = new HashMap<String, String>();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            map.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return map;
    }

    public void clear() {
        this.props.clear();
    }

    public void set(String key, String value) {
        this.props.setProperty(key, value);
    }

    public void save(String description) {
        try {
            String filepath = this.getClass().getResource(this.configPath).getPath();
            PrintStream out = new PrintStream(filepath);
            this.props.store(out, new String(description.getBytes("utf-8"), "iso-8859-1"));
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            logger.warning("\u4fdd\u5b58WEB\u914d\u7f6e\u65b9\u6cd5\u4fe1\u606f\u9519\u8bef" + e);
        }
        catch (IOException e) {
            logger.warning("\u4fdd\u5b58WEB\u914d\u7f6e\u65b9\u6cd5\u4fe1\u606f\u9519\u8bef" + e);
        }
    }

    public void save() {
        try {
            String filepath = this.getClass().getResource(this.configPath).getPath();
            PrintStream out = new PrintStream(filepath);
            this.props.store(out, new String("".getBytes("utf-8"), "iso-8859-1"));
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            logger.warning("\u4fdd\u5b58WEB\u914d\u7f6e\u65b9\u6cd5\u4fe1\u606f\u9519\u8bef" + e);
        }
        catch (IOException e) {
            logger.warning("\u4fdd\u5b58WEB\u914d\u7f6e\u65b9\u6cd5\u4fe1\u606f\u9519\u8bef" + e);
        }
    }

    public void saveAsFile(String fileName, String description) {
        try {
            PrintStream out = new PrintStream(fileName);
            this.props.store(out, new String(description.getBytes("utf-8"), "iso-8859-1"));
            out.close();
        }
        catch (FileNotFoundException e) {
            logger.warning("\u4fdd\u5b58WEB\u914d\u7f6e\u65b9\u6cd5\u4fe1\u606f\u9519\u8bef" + e);
        }
        catch (IOException e) {
            logger.warning("\u4fdd\u5b58WEB\u914d\u7f6e\u65b9\u6cd5\u4fe1\u606f\u9519\u8bef" + e);
        }
    }
}

