/*
 * Decompiled with CFR 0.152.
 */
package com.j2mvc.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class StringUtils {
    public static String dateToString(String s, SimpleDateFormat format) {
        s = s != null ? s.trim() : "";
        try {
            return format.format(format.parse(s));
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getUtf8(String value) {
        if (value == null) {
            return "";
        }
        try {
            if (Charset.forName("ISO-8859-1").newEncoder().canEncode(value)) {
                value = new String(value.getBytes("ISO-8859-1"), "UTF-8");
            }
            if (Charset.forName("GBK").newEncoder().canEncode(value)) {
                value = new String(value.getBytes("GBK"), "UTF-8");
            }
            if (Charset.forName("GB2312").newEncoder().canEncode(value)) {
                value = new String(value.getBytes("GB2312"), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return value;
    }

    public static String deleRepeat(String source, String regex) {
        return source.replaceAll("[" + regex + "]+", regex);
    }

    public static String subHtml(String html, int length) {
        Document document = Jsoup.parse((String)html);
        String text = document.text();
        String dest = text.replaceAll("\\s*|\t|\r|\n", "");
        if (dest.length() > length) {
            return dest.substring(0, length);
        }
        return dest;
    }

    public static String removeHtmlTag(String html) {
        Document document = Jsoup.parse((String)html);
        String text = document.text();
        String dest = text.replaceAll("\\s*|\t|\r|\n", "");
        return dest;
    }

    public static boolean isEmpty(String source) {
        if (source == null) {
            return true;
        }
        return source.trim().equals("");
    }
}

