/*
 * Decompiled with CFR 0.152.
 */
package com.j2mvc.util;

import com.j2mvc.util.MD5;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import org.apache.log4j.Logger;

public class Utils {
    static final Logger log = Logger.getLogger(Utils.class);
    public static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String createId() {
        return Utils.getRandomUUID(null).toString();
    }

    public static boolean isValidUUID(String uuid) {
        if (uuid == null) {
            return false;
        }
        String regex = "^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$";
        return uuid.matches(regex);
    }

    public static UUID getRandomUUID(String str) {
        if (str == null) {
            return UUID.randomUUID();
        }
        return UUID.nameUUIDFromBytes(str.getBytes());
    }

    public static int getWeekOfDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return w;
    }

    public static String getWeekName(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        String name = null;
        switch (w) {
            case 0: {
                name = "\u5468\u65e5";
                break;
            }
            case 1: {
                name = "\u5468\u4e00";
                break;
            }
            case 2: {
                name = "\u5468\u4e8c";
                break;
            }
            case 3: {
                name = "\u5468\u4e09";
                break;
            }
            case 4: {
                name = "\u5468\u56db";
                break;
            }
            case 5: {
                name = "\u5468\u4e94";
                break;
            }
            case 6: {
                name = "\u5468\u516d";
                break;
            }
        }
        return name;
    }

    public static String createToken(String username, String domain, String password) {
        String sessionid = MD5.md5(username + domain + System.currentTimeMillis() + new Random().nextInt(10000));
        if (password.length() > 32) {
            log.error((Object)"\u5bc6\u7801\u4e0d\u80fd\u8d85\u8fc732\u4f4d");
            return "";
        }
        return Utils.encode(sessionid, password);
    }

    public static String createSessionid(String username, String domain, String password) {
        String sessionid = MD5.md5(username + domain + System.currentTimeMillis() + new Random().nextInt(10000));
        if (password.length() > 32) {
            log.error((Object)"\u5bc6\u7801\u4e0d\u80fd\u8d85\u8fc732\u4f4d");
            return "";
        }
        return Utils.encode(sessionid, password);
    }

    public static String getPassword(String sessionid) {
        return Utils.decode(sessionid);
    }

    private static String encode(String large, String small) {
        long lLength = large.length();
        long sLength = small.length();
        long diff = lLength - sLength;
        int step = (int)(diff / sLength) + 1;
        StringBuffer buffer = new StringBuffer();
        int lEnd = 0;
        int lStart = 0;
        int i = 0;
        while ((long)i < sLength) {
            lStart = lEnd;
            buffer.append(small.substring(i, i + 1));
            buffer.append(large.substring(lStart, lEnd += step));
            ++i;
        }
        buffer.append(large.substring(lEnd));
        return buffer.toString();
    }

    private static String decode(String source) {
        int length = source.length();
        if (length > 64) {
            log.error((Object)"\u5b57\u7b26\u4e0d\u80fd\u8d85\u8fc764\u4f4d");
            return "";
        }
        int sLength = length - 32;
        int diff = 32 - sLength;
        int step = diff / sLength + 2;
        int end = sLength * step;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < end; i += step) {
            buffer.append(source.substring(i, i + 1));
        }
        return buffer.toString();
    }

    public static String now() {
        return format.format(new Date());
    }

    public static String format(float size) {
        String unit = "B";
        if (size > 1000.0f) {
            size = size > 1000.0f ? size / 1024.0f : size;
            unit = "KB";
        }
        if (size > 1000.0f) {
            size = size > 1000.0f ? size / 1024.0f : size;
            unit = "MB";
        }
        if (size > 1000.0f) {
            size = size > 1000.0f ? size / 1024.0f : size;
            unit = "GB";
        }
        if (size > 1000.0f) {
            size = size > 1000.0f ? size / 1024.0f : size;
            unit = "TB";
        }
        return String.format("%.2f", Float.valueOf(size)) + unit;
    }

    public static String formatTime(float time) {
        int sStep = 1000;
        int mStep = sStep * 60;
        int hStep = mStep * 60;
        int dStep = hStep * 24;
        if (time < (float)sStep) {
            return (int)time + "\u6beb\u79d2";
        }
        if (time < (float)mStep) {
            return (int)(time / (float)sStep) + "\u79d2";
        }
        if (time < (float)hStep) {
            float m = time / (float)mStep;
            float s = (time - (float)((int)m * mStep)) / 1000.0f;
            return (int)m + "\u5206" + (int)s + "\u79d2";
        }
        if (time < (float)dStep) {
            float h = time / (float)hStep;
            float m = (time - (float)((int)h * hStep)) / (float)mStep;
            float s = (time - (float)((int)h * hStep) - (float)((int)m * mStep)) / (float)sStep;
            return (int)h + "\u65f6" + (int)m + "\u5206" + (int)s + "\u79d2";
        }
        float d = time / (float)dStep;
        float h = (time - (float)((int)d * dStep)) / (float)hStep;
        float m = (time - (float)((int)d * dStep) - (float)((int)h * hStep)) / (float)mStep;
        float s = (time - (float)((int)d * dStep) - (float)((int)h * hStep) - (float)((int)m * mStep)) / (float)sStep;
        return (int)d + "\u5929" + (int)h + "\u65f6" + (int)m + "\u5206" + (int)s + "\u79d2";
    }

    public static String htmlspecialchars(String str) {
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("\"", "&quot;");
        return str;
    }

    public static String formatDate(String source, String format) {
        try {
            Calendar c = Calendar.getInstance();
            c.setTime(DATE_TIME_FORMAT.parse(source));
            Calendar todayCal = Calendar.getInstance();
            todayCal.get(1);
            if (todayCal.get(1) == c.get(1) && todayCal.get(2) == c.get(2) && todayCal.get(5) == c.get(5)) {
                if (todayCal.get(11) == c.get(11) && todayCal.get(12) == c.get(12)) {
                    return todayCal.get(13) - c.get(13) + "\u79d2\u524d";
                }
                if (todayCal.get(11) == c.get(11)) {
                    return todayCal.get(12) - c.get(12) + "\u5206\u949f\u524d";
                }
                return todayCal.get(11) - c.get(11) + "\u5c0f\u65f6\u524d";
            }
            SimpleDateFormat dateformat = DATE_TIME_FORMAT;
            if (format != null && !format.trim().equals("")) {
                dateformat = new SimpleDateFormat(format);
            }
            return dateformat.format(DATE_TIME_FORMAT.parse(source));
        }
        catch (ParseException e) {
            System.err.println(Utils.class.getSimpleName() + ":formatDate:\u683c\u5f0f\u5316\u65f6\u95f4\u9519\u8bef\uff0csource=" + source + ";\u4fe1\u606f:" + e.getMessage());
            return "";
        }
    }

    public static String formatDate(String source, String format, boolean force) {
        try {
            Calendar c = Calendar.getInstance();
            c.setTime(DATE_TIME_FORMAT.parse(source));
            Calendar todayCal = Calendar.getInstance();
            todayCal.get(1);
            if (!force && todayCal.get(1) == c.get(1) && todayCal.get(2) == c.get(2) && todayCal.get(5) == c.get(5)) {
                if (todayCal.get(11) == c.get(11) && todayCal.get(12) == c.get(12)) {
                    return todayCal.get(13) - c.get(13) + "\u79d2\u524d";
                }
                if (todayCal.get(11) == c.get(11)) {
                    return todayCal.get(12) - c.get(12) + "\u5206\u949f\u524d";
                }
                return todayCal.get(11) - c.get(11) + "\u5c0f\u65f6\u524d";
            }
            SimpleDateFormat dateformat = DATE_TIME_FORMAT;
            if (format != null && !format.trim().equals("")) {
                dateformat = new SimpleDateFormat(format);
            }
            return dateformat.format(DATE_TIME_FORMAT.parse(source));
        }
        catch (ParseException e) {
            System.err.println(Utils.class.getSimpleName() + ":formatDate:\u683c\u5f0f\u5316\u65f6\u95f4\u9519\u8bef\uff0csource=" + source + ";\u4fe1\u606f:" + e.getMessage());
            return "";
        }
    }

    public static String getRandom() {
        return Utils.getRandom(14);
    }

    public static String getRandom(int num) {
        String[] chars = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        Random random = new Random();
        StringBuffer randomCode = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            String strRand = chars[random.nextInt(16)];
            randomCode.append(strRand);
        }
        return randomCode.toString();
    }

    public static byte[] objectToBytes(Object obj) {
        if (obj == null) {
            return null;
        }
        byte[] bytes = null;
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(bo);
            oo.writeObject(obj);
            bytes = bo.toByteArray();
            bo.close();
            oo.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public static String byteToString(byte[] bytes) {
        String result = null;
        if (bytes == null) {
            return null;
        }
        if (bytes.length <= 0) {
            log.warn((Object)(" bytes length is " + bytes.length));
            return null;
        }
        try {
            result = new String(bytes, "UTF-8");
        }
        catch (IOException e) {
            log.warn((Object)("IOException bytes length is " + bytes.length));
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] stringToBytes(String string) {
        if (string == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(byteOut);
        try {
            dos.writeUTF(string);
            dos.close();
            byteOut.close();
        }
        catch (IOException e) {
            return new byte[0];
        }
        return byteOut.toByteArray();
    }

    public static Object bytesToObject(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        Object obj = null;
        try {
            ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
            ObjectInputStream oi = new ObjectInputStream(bi);
            obj = oi.readObject();
            bi.close();
            oi.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static String readInputStream(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((len = is.read(b)) != -1) {
            baos.write(b, 0, len);
        }
        baos.flush();
        baos.close();
        String result = new String(baos.toByteArray());
        return result;
    }

    public static String readInputStream(InputStream is, String end) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        boolean isEnd = false;
        while (!isEnd && (len = is.read(b)) != -1) {
            String line = new String(b);
            isEnd = line.lastIndexOf(end) != -1;
            baos.write(b, 0, len);
        }
        baos.flush();
        baos.close();
        String result = new String(baos.toByteArray());
        return result != null && result.lastIndexOf(end) != -1 ? result.substring(0, result.lastIndexOf(end)) : result;
    }

    public static void writeBytes(String arg, OutputStream out) throws IOException {
        out.write(arg.getBytes());
    }

    public static void main(String ... args) {
        String arg = "agdSDDwwr";
        String reg = "[a-zA-Z0-9.]+";
        System.out.println(arg.matches(reg));
    }
}

