/*
 * Decompiled with CFR 0.152.
 */
package com.j2mvc.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validations {
    public static boolean empty(String s) {
        String string = s = s != null ? s.trim() : "";
        return s.equals("");
    }

    public static boolean notHasSpecial(String s) {
        s = s != null ? s.trim() : "";
        String[] words = new String[]{"~", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "_", "+", "|", "\\", "?", ">", "<", "*", "\u2018", ",", ",", "\u201c", "~", "\u201d", "\""};
        for (int i = 0; i < words.length; ++i) {
            if (s.indexOf(words[i]) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String s) {
        String string = s = s != null ? s.trim() : "";
        return s.matches("\\d+");
    }

    public static boolean isDoubleOrInt(String s) {
        String re;
        return (s = s != null ? s.trim() : "").matches(re = "\\d+[.]?[\\d+]?");
    }

    public static boolean isDouble(String s) {
        String re;
        return (s = s != null ? s.trim() : "").matches(re = "\\d+.\\d+");
    }

    public static boolean isNegativeDouble(String s) {
        String re;
        return (s = s != null ? s.trim() : "").matches(re = "([-])?\\d+[.]?\\d+");
    }

    public static boolean isNegativeDoubleOrInt(String s) {
        String re;
        return (s = s != null ? s.trim() : "").matches(re = "([-])?\\d+.\\d+");
    }

    public static boolean isUrl(String s) {
        String string = s = s != null ? s.trim() : "";
        if (s.indexOf("http://", 0) == 0 || s.indexOf("https://", 0) == 0) {
            s = s.replace("http://", "");
            return (s = s.replace("https://", "")) != "";
        }
        return false;
    }

    public static boolean isDomain(String s) {
        String string = s = s != null ? s.trim() : "";
        return s.indexOf(".") != -1 && s.indexOf(".") < s.length() - 1;
    }

    public static boolean isEmail(String s) {
        String re;
        return (s = s != null ? s.trim() : "").matches(re = "\\w+([-+.']\\w+)*@\\w+([-.]\\w+)*.\\w+([-.]\\w+)*");
    }

    public static boolean isMobilephoneOrPhone(String mobilephone) {
        boolean flag = true;
        String reg1 = "(^\\d{3,4}-?\\d{7,8})$|(1[0-9]{10})";
        String reg2 = "(^([(]\\d{3,4}[)])?\\d{7,8})$|(1[0-9]{10})";
        if (mobilephone == null || "".equals(mobilephone)) {
            return false;
        }
        try {
            Pattern p = Pattern.compile(reg1);
            Matcher m = p.matcher(mobilephone);
            flag = m.matches();
            if (!flag) {
                p = Pattern.compile(reg2);
                m = p.matcher(mobilephone);
                flag = m.matches();
            }
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public static boolean isMobilephone(String mobilephone) {
        boolean flag = false;
        if (mobilephone == null || "".equals(mobilephone)) {
            return false;
        }
        try {
            Pattern p = Pattern.compile("^[1][34578][0-9]{9}$");
            Matcher m = p.matcher(mobilephone);
            flag = m.matches();
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public static boolean isIDCard(String idCard) {
        boolean flag = false;
        if (idCard == null || "".equals(idCard)) {
            return false;
        }
        try {
            Pattern p = Pattern.compile("^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{4}$");
            Matcher m = p.matcher(idCard);
            flag = m.matches();
            if (!flag) {
                p = Pattern.compile("^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$");
                m = p.matcher(idCard);
                flag = m.matches();
            }
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }
}

