/*
 * Decompiled with CFR 0.152.
 */
package com.j2mvc.util.json;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.j2mvc.util.json.JSONField;
import com.j2mvc.util.json.JSONObjectStr;
import com.j2mvc.util.json.JSONUtils;
import com.j2mvc.util.json.NotJSONField;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class JSONFactory {
    SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    Logger logger = Logger.getLogger(this.getClass().getSimpleName());

    public JSONObject toSimpleJsonObject(String jsonName, Object object) {
        if (jsonName != null && !jsonName.trim().equals("") && object != null) {
            JSONObject json = new JSONObject();
            this.put(json, jsonName, "", object);
            return json;
        }
        return null;
    }

    public JSONObject toJsonObject(Object ... objects) {
        JSONObject json = new JSONObject();
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (object == null) continue;
            Class<?> clazz = object.getClass();
            JSONObjectStr jsonObjectStr = clazz.getAnnotation(JSONObjectStr.class);
            try {
                String jsonName;
                String string = jsonName = jsonObjectStr != null ? jsonObjectStr.value() : "";
                if (jsonName != null && !jsonName.equals("")) {
                    json.put(jsonName, this.toJsonObject(object));
                    continue;
                }
                this.build(json, object);
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return json;
    }

    public JSONArray toSimpleJsonArray(Object ... object) {
        return this.toJsonArray(object);
    }

    public Object toJsonObject(Object object, boolean hasOuter) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        JSONObjectStr jsonObjectStr = clazz.getAnnotation(JSONObjectStr.class);
        try {
            if (hasOuter && jsonObjectStr != null && !jsonObjectStr.value().equals("")) {
                JSONObject json = new JSONObject();
                json.put(jsonObjectStr.value(), this.toJsonObject(object));
                return json;
            }
            return this.toJsonObject(object);
        }
        catch (JSONException e) {
            return null;
        }
    }

    private void put(JSONObject json, String jsonName, String name, Object object) {
        try {
            Object jsonObject;
            JSONArray array;
            Object value = null;
            if (name != null && !name.trim().equals("")) {
                try {
                    PropertyDescriptor pd = new PropertyDescriptor(name, object.getClass());
                    Method method = pd.getReadMethod();
                    if (method != null) {
                        value = method.invoke(object, new Object[0]);
                        value = value != null ? value : "";
                    }
                }
                catch (IntrospectionException method) {
                }
                catch (IllegalAccessException method) {
                }
                catch (InvocationTargetException method) {}
            } else {
                Object object2 = value = object != null ? object : "";
            }
            if (value == null || value.equals("")) {
                return;
            }
            if (value instanceof Object[]) {
                array = this.toJsonArray((Object[])value);
                if (array != null) {
                    json.put(jsonName, (Object)array);
                }
            } else if (value instanceof Collection) {
                array = this.toJsonArray((Collection)value);
                if (array != null) {
                    json.put(jsonName, (Object)array);
                }
            } else if (value instanceof Map) {
                jsonObject = this.toJsonMap((Map)value);
                if (jsonObject != null) {
                    json.put(jsonName, jsonObject);
                }
            } else if (value instanceof Date) {
                json.put(jsonName, (Object)this.formater.format(value));
            } else if (value instanceof Integer || value instanceof Long || value instanceof Boolean || value instanceof Double || value instanceof Number || value instanceof String || value instanceof Double || value instanceof Float || value instanceof Short) {
                json.put(jsonName, value);
            } else {
                jsonObject = this.toJsonObject(value);
                if (jsonObject != null) {
                    json.put(jsonName, this.toJsonObject(value));
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public Object toJsonObject(Object object) {
        if (object == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        if (object instanceof Object[] || object instanceof Collection) {
            return this.toJsonArray(object);
        }
        if (object instanceof Map) {
            this.buildMap(json, (Map)object);
        } else {
            this.build(json, object);
        }
        return json;
    }

    public JSONArray toJsonArray(Object object) {
        ArrayList<Object> jsons;
        block5: {
            block4: {
                jsons = new ArrayList<Object>();
                if (!(object instanceof Collection)) break block4;
                for (Object value : (Collection)object) {
                    if (value instanceof Integer || value instanceof Long || value instanceof Boolean || value instanceof Double || value instanceof Number || value instanceof String || value instanceof Double || value instanceof Float || value instanceof Short) {
                        jsons.add(value);
                        continue;
                    }
                    jsons.add(this.toJsonObject(value));
                }
                break block5;
            }
            if (!(object instanceof Object[])) break block5;
            Object[] objects = (Object[])object;
            for (int i = 0; i < objects.length; ++i) {
                Object value = objects[i];
                if (value instanceof Integer || value instanceof Long || value instanceof Boolean || value instanceof Double || value instanceof Number || value instanceof String || value instanceof Double || value instanceof Float || value instanceof Short) {
                    jsons.add(value);
                    continue;
                }
                jsons.add(this.toJsonObject(value));
            }
        }
        return jsons != null ? new JSONArray(jsons) : null;
    }

    private void build(JSONObject json, Object object) {
        List<Field> fields = JSONUtils.getFields(null, object.getClass());
        for (Field field : fields) {
            NotJSONField notJSONField = field.getAnnotation(NotJSONField.class);
            if (notJSONField != null) continue;
            JSONField jsonField = field.getAnnotation(JSONField.class);
            String jsonName = jsonField != null ? jsonField.value() : field.getName();
            this.put(json, jsonName, field.getName(), object);
        }
    }

    private void buildMap(JSONObject json, Map<Object, Object> map) {
        Set<Map.Entry<Object, Object>> set = map.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            try {
                if (value instanceof Integer || value instanceof Long || value instanceof Boolean || value instanceof Double || value instanceof Number || value instanceof String || value instanceof Double || value instanceof Float || value instanceof Short || value instanceof Date) {
                    try {
                        json.put(key.toString(), value);
                    }
                    catch (JSONException e) {
                        this.logger.warning(e.getMessage());
                    }
                    continue;
                }
                json.put(key.toString(), this.toJsonObject(value));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public JSONObject toJsonMap(Map<Object, Object> map) {
        Set<Map.Entry<Object, Object>> set = map.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
        JSONObject jsonObject = new JSONObject();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof Integer || value instanceof Long || value instanceof Boolean || value instanceof Double || value instanceof Number || value instanceof String || value instanceof Double || value instanceof Float || value instanceof Short || value instanceof Date) {
                try {
                    jsonObject.put(key, value);
                }
                catch (JSONException e) {
                    this.logger.warning(e.getMessage());
                }
                continue;
            }
            try {
                jsonObject.put(key, this.toJsonObject(value));
            }
            catch (JSONException e) {
                this.logger.warning(e.getMessage());
            }
        }
        return jsonObject;
    }
}

