/*
 * Decompiled with CFR 0.152.
 */
package com.j2mvc.util.json;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.j2mvc.util.json.JSONField;
import com.j2mvc.util.json.JSONUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class JSONParse {
    public static final SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static Logger log = Logger.getLogger(JSONParse.class.getName());

    public static Object parse(String json, Class<?> clazz) {
        String jsonType = JSONUtils.getJSONType(json);
        if (clazz.isAssignableFrom(String.class)) {
            return json;
        }
        if (jsonType.equals("boolean")) {
            return Boolean.parseBoolean(json);
        }
        if (jsonType.equals("number")) {
            return JSONParse.parseNumber(json, clazz);
        }
        if (jsonType.equals("array")) {
            return JSONParse.parseArray(json, clazz);
        }
        if (jsonType.equals("object")) {
            return JSONParse.parseObject(json, clazz);
        }
        return json;
    }

    public static Object parseObject(String json, Class<?> clazz) {
        System.out.print(clazz);
        List<Field> fields = JSONUtils.getFields(null, clazz);
        JSONObject jsonObject = null;
        Object object = null;
        try {
            jsonObject = JSONObject.parseObject((String)json);
            object = clazz.newInstance();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            log.warning("\u5b9e\u4f8b\u5316\u5931\u8d25\uff0c\u5fc5\u987b\u6709\u7a7a\u6784\u9020\u65b9\u6cd5." + e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (object != null) {
            for (Field field : fields) {
                JSONField jsonField = field.getAnnotation(JSONField.class);
                String jsonName = jsonField != null ? jsonField.value() : field.getName();
                try {
                    Object value = JSONParse.parseField(field, jsonObject.getString(jsonName));
                    if (value == null) continue;
                    JSONUtils.setValue(field, object, value);
                }
                catch (JSONException jSONException) {}
            }
        }
        return object;
    }

    private static Object parseField(Field field, String json) {
        if (json == null) {
            return null;
        }
        Class<?> type = field.getType();
        String jsonType = JSONUtils.getJSONType(json);
        if (jsonType.equals("array")) {
            return JSONParse.parseArray(json, field);
        }
        if (jsonType.equals("object") && Map.class.isAssignableFrom(type)) {
            return JSONParse.parseMap(json, field);
        }
        return JSONParse.parse(json, type);
    }

    private static Map<Object, Object> parseMap(String json, Field field) {
        Map map = null;
        String clazzName = field.getClass().getCanonicalName();
        try {
            Class<?> clazz = Class.forName(clazzName);
            map = clazz.getCanonicalName().equals("java.util.Hashtable") ? new Hashtable() : new HashMap();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        List<Class<?>> subTypes = JSONUtils.getGenericTypes(field);
        if (subTypes.size() > 1) {
            Class<?> keyType = subTypes.get(0);
            Class<?> valueType = subTypes.get(1);
            return JSONParse.parseMap(json, keyType, valueType, map);
        }
        return map;
    }

    public static <K, V> Map<K, V> parseMap(String json, Class<?> keyType, Class<?> valueType, Map<K, V> map) {
        map = map != null ? map : new HashMap<Object, Object>();
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)json);
            Set set = jsonObject.entrySet();
            for (Map.Entry entry : set) {
                String keyString = (String)entry.getKey();
                Object key = JSONParse.parse(keyString, keyType);
                Object value = JSONParse.parse(jsonObject.getString(keyString), valueType);
                map.put(key, value);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return map;
    }

    private static Object parseArray(String json, Field field) {
        Class<?> clazz = field.getType();
        String subTypeName = clazz.getCanonicalName().replace("[]", "");
        Class<?> subType = null;
        try {
            subType = Class.forName(subTypeName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        if (String[].class.isAssignableFrom(clazz) || Integer[].class.isAssignableFrom(clazz) || Long[].class.isAssignableFrom(clazz) || Double[].class.isAssignableFrom(clazz) || Float[].class.isAssignableFrom(clazz) || Boolean[].class.isAssignableFrom(clazz) || Number[].class.isAssignableFrom(clazz) || int[].class.isAssignableFrom(clazz) || long[].class.isAssignableFrom(clazz) || double[].class.isAssignableFrom(clazz) || float[].class.isAssignableFrom(clazz) || boolean[].class.isAssignableFrom(clazz)) {
            return JSONParse.parseArray(json, subType);
        }
        List<Class<?>> subTypes = JSONUtils.getGenericTypes(field);
        if (subTypes.size() > 0) {
            return JSONParse.parseList(json, subTypes.get(0));
        }
        return JSONParse.parseArray(json, subType);
    }

    public static <T> Object[] parseArray(String json, Class<T> clazz) {
        Object[] array = null;
        try {
            JSONArray jsonArray = JSONArray.parseArray((String)json);
            int length = jsonArray.size();
            array = String.class.isAssignableFrom(clazz) ? new String[length] : (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) ? new Integer[length] : (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) ? new Long[length] : (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) ? new Double[length] : (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) ? new Float[length] : (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz) ? new Boolean[length] : (Number.class.isAssignableFrom(clazz) ? new Number[length] : (Object[])Array.newInstance(clazz, length)))))));
            if (array != null) {
                for (int i = 0; i < jsonArray.size(); ++i) {
                    String jsonString = jsonArray.getString(i);
                    array[i] = JSONParse.parse(jsonString, clazz);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return array;
    }

    public static <T> List<T> parseList(String json, Class<T> clazz) {
        try {
            JSONArray jsonArray = JSONArray.parseArray((String)json);
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                String jsonString = jsonArray.getString(i);
                Object object = JSONParse.parse(jsonString, clazz);
                list.add(object);
            }
            return list;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String parseString(String json) {
        return json;
    }

    public static Number parseNumber(String json, Class<?> type) {
        if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return Long.parseLong(json.toString());
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return Integer.parseInt(json.toString());
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return Double.parseDouble(json.toString());
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return Float.valueOf(Float.parseFloat(json.toString()));
        }
        return null;
    }
}

