/*
 * Decompiled with CFR 0.152.
 */
package com.j2mvc.util.mail;

import com.j2mvc.util.mail.MailAuthenticator;
import com.j2mvc.util.mail.MailInfo;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class Mail {
    String from;
    boolean auth;
    String name;
    Session session;
    String contentType = "text/html; charset=utf-8";

    public Mail(String from, String hostname, int port, boolean auth, String name, String username, String password) {
        this.from = from;
        this.auth = auth;
        this.name = name;
        Properties props = new Properties();
        props.put("mail.smtp.host", hostname);
        props.put("mail.smtp.port", (Object)port);
        props.put("mail.smtp.auth", (Object)auth);
        this.session = Session.getInstance((Properties)props, (Authenticator)new MailAuthenticator(username, password));
    }

    public boolean sendMail(MailInfo info) throws UnsupportedEncodingException {
        try {
            MimeMessage message = new MimeMessage(this.session);
            InternetAddress address = new InternetAddress(this.from);
            address.setPersonal(MimeUtility.encodeText((String)(this.name + "<" + this.from + ">")));
            message.setFrom((Address)address);
            String[] receivers = info.getReceivers();
            InternetAddress[] recipients = new InternetAddress[receivers.length];
            for (int i = 0; i < receivers.length; ++i) {
                recipients[i] = new InternetAddress(receivers[i]);
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])recipients);
            message.setSubject(info.getSubject());
            message.setSentDate(new Date());
            MimeMultipart mainPart = new MimeMultipart();
            MimeBodyPart body = new MimeBodyPart();
            body.setContent((Object)info.getBody(), this.contentType);
            mainPart.addBodyPart((BodyPart)body);
            message.setContent((Multipart)mainPart);
            Transport.send((Message)message);
            return true;
        }
        catch (MessagingException ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

