/*
 * Decompiled with CFR 0.152.
 */
package jcifs.dcerpc;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import jcifs.dcerpc.DcerpcException;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbExtendedAuthenticator;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import jcifs.smb.SmbNamedPipe;
import jcifs.util.Encdec;

public class DcerpcPipeHandle
extends DcerpcHandle {
    static final int pipeFlags = 27198979;
    SmbNamedPipe pipe;
    SmbFileInputStream in = null;
    SmbFileOutputStream out = null;
    boolean isStart = true;

    public DcerpcPipeHandle(String url, NtlmPasswordAuthentication auth) throws UnknownHostException, MalformedURLException, DcerpcException {
        url = this.init(url);
        this.pipe = new SmbNamedPipe(url, 27198979, auth);
    }

    public DcerpcPipeHandle(String url, SmbExtendedAuthenticator auth) throws UnknownHostException, MalformedURLException, DcerpcException {
        url = this.init(url);
        this.pipe = new SmbNamedPipe(url, 27198979, auth);
    }

    private String init(String url) throws UnknownHostException, MalformedURLException, DcerpcException {
        this.binding = DcerpcHandle.parseBinding(url);
        url = "smb://" + this.binding.server + "/IPC$/" + this.binding.endpoint.substring(6);
        String params = "";
        String server = (String)this.binding.getOption("server");
        if (server != null) {
            params = params + "&server=" + server;
        }
        String address = (String)this.binding.getOption("address");
        if (server != null) {
            params = params + "&address=" + address;
        }
        if (params.length() > 0) {
            url = url + "?" + params.substring(1);
        }
        return url;
    }

    @Override
    protected void doSendFragment(byte[] buf, int off, int length, boolean isDirect) throws IOException {
        if (this.out != null && !this.out.isOpen()) {
            throw new IOException("DCERPC pipe is no longer open");
        }
        if (this.in == null) {
            this.in = (SmbFileInputStream)this.pipe.getNamedPipeInputStream();
        }
        if (this.out == null) {
            this.out = (SmbFileOutputStream)this.pipe.getNamedPipeOutputStream();
        }
        if (isDirect) {
            this.out.writeDirect(buf, off, length, 1);
            return;
        }
        this.out.write(buf, off, length);
    }

    @Override
    protected void doReceiveFragment(byte[] buf, boolean isDirect) throws IOException {
        if (buf.length < this.max_recv) {
            throw new IllegalArgumentException("buffer too small");
        }
        if (buf[0] != 5 && buf[1] != 0) {
            throw new IOException("Unexpected DCERPC PDU header");
        }
        int flags = buf[3] & 0xFF;
        this.isStart = (flags & 2) == 2;
        short length = Encdec.dec_uint16le(buf, 8);
        if (length > this.max_recv) {
            throw new IOException("Unexpected fragment length: " + length);
        }
        for (int off = this.isStart && !isDirect ? this.in.read(buf, 0, 1024) : this.in.readDirect(buf, 0, buf.length); off < length; off += this.in.readDirect(buf, off, length - off)) {
        }
    }

    @Override
    public void close() throws IOException {
        this.state = 0;
        if (this.out != null) {
            this.out.close();
        }
    }
}

