/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.security.Key;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import jcifs.Config;
import jcifs.smb.Kerb5Context;
import jcifs.smb.Kerb5SessionSetupAndX;
import jcifs.smb.Kerb5SessionSetupAndXResponse;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SigningDigest;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbConstants;
import jcifs.smb.SmbException;
import jcifs.smb.SmbExtendedAuthenticator;
import jcifs.smb.SmbSession;
import jcifs.smb.SpnegoContext;
import org.ietf.jgss.GSSException;

public class Kerb5Authenticator
implements SmbExtendedAuthenticator {
    public static final String FLAGS2 = "55301";
    public static final String CAPABILITIES = "-2147483436";
    private static final String SERVICE = "cifs";
    private Subject subject = null;
    private String user = null;
    private String service = "cifs";
    private int userLifetime = 0;
    private int contextLifetime = 0;

    public Kerb5Authenticator(Subject subject) {
        this.subject = subject;
    }

    public void setUser(String name) {
        this.user = name;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getUser() {
        return this.user;
    }

    public void setService(String name) {
        this.service = name;
    }

    public String getService() {
        return this.service;
    }

    public int getUserLifeTime() {
        return this.userLifetime;
    }

    public void setUserLifeTime(int time) {
        this.userLifetime = time;
    }

    public int getLifeTime() {
        return this.contextLifetime;
    }

    public void setLifeTime(int time) {
        this.contextLifetime = time;
    }

    @Override
    public void sessionSetup(final SmbSession session, final ServerMessageBlock andx, final ServerMessageBlock andxResponse) throws SmbException {
        try {
            Subject.doAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Kerb5Authenticator.this.setup(session, andx, andxResponse);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof SmbException) {
                throw (SmbException)e.getException();
            }
            throw new SmbException(e.getMessage(), (Throwable)e.getException());
        }
    }

    private void setup(SmbSession session, ServerMessageBlock andx, ServerMessageBlock andxResponse) throws SmbAuthException, SmbException {
        Kerb5Context context = null;
        SpnegoContext spnego = null;
        try {
            String host = session.transport.address.getHostAddress();
            try {
                host = session.transport.address.getHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            context = this.createContext(host);
            spnego = new SpnegoContext(context.getGSSContext());
            byte[] token = new byte[]{};
            Kerb5SessionSetupAndX request = null;
            Kerb5SessionSetupAndXResponse response = null;
            while (!spnego.isEstablished()) {
                if ((token = spnego.initSecContext(token, 0, token.length)) == null) continue;
                request = new Kerb5SessionSetupAndX(session, null);
                request.getSecurityBlob().set(token);
                response = new Kerb5SessionSetupAndXResponse(andxResponse);
                if (session.transport.digest == null && (session.transport.server.signaturesRequired || session.transport.server.signaturesEnabled && SmbConstants.SIGNPREF)) {
                    Key key = context.searchSessionKey(this.subject);
                    if (key == null) {
                        throw new SmbException("Kerberos session key not found.");
                    }
                    request.digest = new SigningDigest(key.getEncoded());
                }
                session.transport.send(request, response);
                session.transport.digest = request.digest;
                token = response.getSecurityBlob().get();
            }
            session.setUid(response.uid);
            session.setSessionSetup(true);
        }
        catch (GSSException e) {
            throw new SmbException(e.getMessage());
        }
        finally {
            if (context != null) {
                try {
                    context.dispose();
                }
                catch (GSSException gSSException) {}
            }
        }
    }

    private Kerb5Context createContext(String host) throws GSSException {
        Kerb5Context kerb5Context = new Kerb5Context(host, this.service, this.user, this.userLifetime, this.contextLifetime);
        kerb5Context.getGSSContext().requestAnonymity(false);
        kerb5Context.getGSSContext().requestSequenceDet(false);
        kerb5Context.getGSSContext().requestMutualAuth(false);
        kerb5Context.getGSSContext().requestConf(false);
        kerb5Context.getGSSContext().requestInteg(false);
        kerb5Context.getGSSContext().requestReplayDet(false);
        return kerb5Context;
    }

    public boolean equals(Object arg0) {
        if (arg0 != null && Kerb5Authenticator.class == arg0.getClass()) {
            return this.getSubject() == ((Kerb5Authenticator)arg0).getSubject();
        }
        return false;
    }

    @Override
    public String getDomain() {
        String realm = "";
        if (this.subject != null) {
            Set<Principal> pr = this.subject.getPrincipals();
            Iterator<Principal> ite = pr.iterator();
            while (ite.hasNext()) {
                try {
                    KerberosPrincipal entry = (KerberosPrincipal)ite.next();
                    realm = entry.getRealm();
                    break;
                }
                catch (Exception e) {
                }
            }
        }
        if (realm.isEmpty()) {
            return this.getDefaultDomain();
        }
        return realm;
    }

    private String getDefaultDomain() {
        return Config.getProperty("jcifs.smb.client.domain", "?");
    }
}

