/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.smb.AndXServerMessageBlock;
import jcifs.smb.SecurityBlob;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbException;
import jcifs.smb.SmbSession;
import jcifs.smb.SmbTransport;

class Kerb5SessionSetupAndX
extends AndXServerMessageBlock {
    private int sessionKey = 0;
    private SmbSession session;
    private SecurityBlob securityBlob = new SecurityBlob();

    Kerb5SessionSetupAndX(SmbSession session, ServerMessageBlock andx) throws SmbException {
        super(andx);
        this.command = (byte)115;
        this.session = session;
    }

    SecurityBlob getSecurityBlob() {
        return this.securityBlob;
    }

    @Override
    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        Kerb5SessionSetupAndX.writeInt2(this.session.transport.snd_buf_size, dst, dstIndex);
        Kerb5SessionSetupAndX.writeInt2(CAPABILITIES, dst, dstIndex += 2);
        Kerb5SessionSetupAndX.writeInt2(1L, dst, dstIndex += 2);
        Kerb5SessionSetupAndX.writeInt4(this.sessionKey, dst, dstIndex += 2);
        Kerb5SessionSetupAndX.writeInt2(this.securityBlob.length(), dst, dstIndex += 4);
        dstIndex += 2;
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        Kerb5SessionSetupAndX.writeInt4(this.session.transport.capabilities, dst, dstIndex);
        return (dstIndex += 4) - start;
    }

    @Override
    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        System.arraycopy(this.securityBlob.get(), 0, dst, dstIndex, this.securityBlob.length());
        dstIndex += this.securityBlob.length();
        dstIndex += this.writeString(SmbTransport.NATIVE_OS == null ? "" : SmbTransport.NATIVE_OS, dst, dstIndex);
        dstIndex += this.writeString(SmbTransport.NATIVE_LANMAN == null ? "" : SmbTransport.NATIVE_LANMAN, dst, dstIndex);
        return dstIndex - start;
    }

    @Override
    public String toString() {
        String result = new String("Kerb5SessionSetupAndX[" + super.toString() + ",snd_buf_size=" + this.session.transport.snd_buf_size + ",maxMpxCount=" + this.session.transport.maxMpxCount + ",VC_NUMBER=" + 1 + ",sessionKey=" + this.sessionKey + ",securityBlobLength=" + this.securityBlob.length() + ",capabilities=" + CAPABILITIES + ",securityBlob=" + this.securityBlob.toString() + ",os=" + SmbTransport.NATIVE_OS + ",lanman=" + SmbTransport.NATIVE_LANMAN);
        return result;
    }

    @Override
    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }
}

