/*
 * Decompiled with CFR 0.152.
 */
package jcifs.spnego.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import jcifs.spnego.asn1.ASN1OutputStream;
import jcifs.spnego.asn1.BEROutputStream;
import jcifs.spnego.asn1.DEREncodable;
import jcifs.spnego.asn1.DERObject;
import jcifs.spnego.asn1.DEROctetString;
import jcifs.spnego.asn1.DEROutputStream;

public class BERConstructedOctetString
extends DEROctetString {
    private Vector octs;

    private static byte[] toBytes(Vector octs) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        for (int i = 0; i != octs.size(); ++i) {
            DEROctetString o = (DEROctetString)octs.elementAt(i);
            try {
                bOut.write(o.getOctets());
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("exception converting octets " + e.toString());
            }
        }
        return bOut.toByteArray();
    }

    public BERConstructedOctetString(byte[] string) {
        super(string);
    }

    public BERConstructedOctetString(Vector octs) {
        super(BERConstructedOctetString.toBytes(octs));
        this.octs = octs;
    }

    public BERConstructedOctetString(DERObject obj) {
        super(obj);
    }

    public BERConstructedOctetString(DEREncodable obj) {
        super(obj.getDERObject());
    }

    @Override
    public byte[] getOctets() {
        return this.string;
    }

    public Enumeration getObjects() {
        if (this.octs == null) {
            this.octs = this.generateOcts();
        }
        return this.octs.elements();
    }

    private Vector generateOcts() {
        int i;
        byte[] nStr;
        int start = 0;
        int end = 0;
        Vector<DEROctetString> vec = new Vector<DEROctetString>();
        while (end + 1 < this.string.length) {
            if (this.string[end] == 0 && this.string[end + 1] == 0) {
                nStr = new byte[end - start + 1];
                for (i = 0; i != nStr.length; ++i) {
                    nStr[i] = this.string[start + i];
                }
                vec.addElement(new DEROctetString(nStr));
                start = end + 1;
            }
            ++end;
        }
        nStr = new byte[this.string.length - start];
        for (i = 0; i != nStr.length; ++i) {
            nStr[i] = this.string[start + i];
        }
        vec.addElement(new DEROctetString(nStr));
        return vec;
    }

    @Override
    public void encode(DEROutputStream out) throws IOException {
        if (out instanceof ASN1OutputStream || out instanceof BEROutputStream) {
            out.write(36);
            out.write(128);
            if (this.octs == null) {
                this.octs = this.generateOcts();
            }
            for (int i = 0; i != this.octs.size(); ++i) {
                out.writeObject(this.octs.elementAt(i));
            }
            out.write(0);
            out.write(0);
        } else {
            super.encode(out);
        }
    }
}

