/*
 * Decompiled with CFR 0.152.
 */
package jcifs.spnego.asn1;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import jcifs.spnego.asn1.ASN1EncodableVector;
import jcifs.spnego.asn1.BERInputStream;
import jcifs.spnego.asn1.DERBMPString;
import jcifs.spnego.asn1.DERBitString;
import jcifs.spnego.asn1.DERBoolean;
import jcifs.spnego.asn1.DERConstructedSequence;
import jcifs.spnego.asn1.DERConstructedSet;
import jcifs.spnego.asn1.DEREnumerated;
import jcifs.spnego.asn1.DERGeneralizedTime;
import jcifs.spnego.asn1.DERIA5String;
import jcifs.spnego.asn1.DERInteger;
import jcifs.spnego.asn1.DERNull;
import jcifs.spnego.asn1.DERObject;
import jcifs.spnego.asn1.DERObjectIdentifier;
import jcifs.spnego.asn1.DEROctetString;
import jcifs.spnego.asn1.DERPrintableString;
import jcifs.spnego.asn1.DERT61String;
import jcifs.spnego.asn1.DERTaggedObject;
import jcifs.spnego.asn1.DERTags;
import jcifs.spnego.asn1.DERUTCTime;
import jcifs.spnego.asn1.DERUTF8String;
import jcifs.spnego.asn1.DERUniversalString;
import jcifs.spnego.asn1.DERUnknownTag;
import jcifs.spnego.asn1.DERVisibleString;

public class DERInputStream
extends FilterInputStream
implements DERTags {
    public DERInputStream(InputStream is) {
        super(is);
    }

    protected int readLength() throws IOException {
        int length = this.read();
        if (length < 0) {
            throw new IOException("EOF found when length expected");
        }
        if (length == 128) {
            return -1;
        }
        if (length > 127) {
            int size = length & 0x7F;
            length = 0;
            for (int i = 0; i < size; ++i) {
                int next = this.read();
                if (next < 0) {
                    throw new IOException("EOF found reading length");
                }
                length = (length << 8) + next;
            }
        }
        return length;
    }

    protected void readFully(byte[] bytes) throws IOException {
        int left = bytes.length;
        if (left == 0) {
            return;
        }
        while ((left -= this.read(bytes, bytes.length - left, left)) != 0) {
        }
    }

    protected DERObject buildObject(int tag, byte[] bytes) throws IOException {
        switch (tag) {
            case 5: {
                return null;
            }
            case 48: {
                ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
                BERInputStream dIn = new BERInputStream(bIn);
                DERConstructedSequence seq = new DERConstructedSequence();
                try {
                    while (true) {
                        DERObject obj = dIn.readObject();
                        seq.addObject(obj);
                    }
                }
                catch (EOFException ex) {
                    return seq;
                }
            }
            case 49: {
                ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
                BERInputStream dIn = new BERInputStream(bIn);
                ASN1EncodableVector v = new ASN1EncodableVector();
                try {
                    while (true) {
                        DERObject obj = dIn.readObject();
                        v.add(obj);
                    }
                }
                catch (EOFException ex) {
                    return new DERConstructedSet(v);
                }
            }
            case 1: {
                return new DERBoolean(bytes);
            }
            case 2: {
                return new DERInteger(bytes);
            }
            case 10: {
                return new DEREnumerated(bytes);
            }
            case 6: {
                return new DERObjectIdentifier(bytes);
            }
            case 3: {
                byte padBits = bytes[0];
                byte[] data = new byte[bytes.length - 1];
                System.arraycopy(bytes, 1, data, 0, bytes.length - 1);
                return new DERBitString(data, (int)padBits);
            }
            case 12: {
                return new DERUTF8String(bytes);
            }
            case 19: {
                return new DERPrintableString(bytes);
            }
            case 22: {
                return new DERIA5String(bytes);
            }
            case 20: {
                return new DERT61String(bytes);
            }
            case 26: {
                return new DERVisibleString(bytes);
            }
            case 28: {
                return new DERUniversalString(bytes);
            }
            case 30: {
                return new DERBMPString(bytes);
            }
            case 4: {
                return new DEROctetString(bytes);
            }
            case 23: {
                return new DERUTCTime(bytes);
            }
            case 24: {
                return new DERGeneralizedTime(bytes);
            }
        }
        if ((tag & 0x80) != 0) {
            if ((tag & 0x1F) == 31) {
                throw new IOException("unsupported high tag encountered");
            }
            if (bytes.length == 0) {
                if ((tag & 0x20) == 0) {
                    return new DERTaggedObject(false, tag & 0x1F, new DERNull());
                }
                return new DERTaggedObject(false, tag & 0x1F, new DERConstructedSequence());
            }
            if ((tag & 0x20) == 0) {
                return new DERTaggedObject(false, tag & 0x1F, new DEROctetString(bytes));
            }
            ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
            BERInputStream dIn = new BERInputStream(bIn);
            DERObject dObj = dIn.readObject();
            if (dIn.available() == 0) {
                return new DERTaggedObject(tag & 0x1F, dObj);
            }
            DERConstructedSequence seq = new DERConstructedSequence();
            seq.addObject(dObj);
            try {
                while (true) {
                    dObj = dIn.readObject();
                    seq.addObject(dObj);
                }
            }
            catch (EOFException eOFException) {
                return new DERTaggedObject(false, tag & 0x1F, seq);
            }
        }
        return new DERUnknownTag(tag, bytes);
    }

    public DERObject readObject() throws IOException {
        int tag = this.read();
        if (tag == -1) {
            throw new EOFException();
        }
        int length = this.readLength();
        byte[] bytes = new byte[length];
        this.readFully(bytes);
        return this.buildObject(tag, bytes);
    }
}

