/*
 * Decompiled with CFR 0.152.
 */
package butterknife.compiler;

import butterknife.BindAnim;
import butterknife.BindArray;
import butterknife.BindBitmap;
import butterknife.BindBool;
import butterknife.BindColor;
import butterknife.BindDimen;
import butterknife.BindDrawable;
import butterknife.BindFloat;
import butterknife.BindFont;
import butterknife.BindInt;
import butterknife.BindString;
import butterknife.BindView;
import butterknife.BindViews;
import butterknife.OnCheckedChanged;
import butterknife.OnClick;
import butterknife.OnEditorAction;
import butterknife.OnFocusChange;
import butterknife.OnItemClick;
import butterknife.OnItemLongClick;
import butterknife.OnItemSelected;
import butterknife.OnLongClick;
import butterknife.OnPageChange;
import butterknife.OnTextChanged;
import butterknife.OnTouch;
import butterknife.Optional;
import butterknife.compiler.BindingSet;
import butterknife.compiler.FieldAnimationBinding;
import butterknife.compiler.FieldCollectionViewBinding;
import butterknife.compiler.FieldDrawableBinding;
import butterknife.compiler.FieldResourceBinding;
import butterknife.compiler.FieldTypefaceBinding;
import butterknife.compiler.FieldViewBinding;
import butterknife.compiler.Id;
import butterknife.compiler.MethodViewBinding;
import butterknife.compiler.Parameter;
import butterknife.internal.ListenerClass;
import butterknife.internal.ListenerMethod;
import com.google.auto.common.SuperficialValidation;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public final class ButterKnifeProcessor
extends AbstractProcessor {
    private static final String OPTION_SDK_INT = "butterknife.minSdk";
    private static final String OPTION_DEBUGGABLE = "butterknife.debuggable";
    static final Id NO_ID = new Id(-1);
    static final String VIEW_TYPE = "android.view.View";
    static final String ACTIVITY_TYPE = "android.app.Activity";
    static final String DIALOG_TYPE = "android.app.Dialog";
    private static final String COLOR_STATE_LIST_TYPE = "android.content.res.ColorStateList";
    private static final String BITMAP_TYPE = "android.graphics.Bitmap";
    private static final String ANIMATION_TYPE = "android.view.animation.Animation";
    private static final String DRAWABLE_TYPE = "android.graphics.drawable.Drawable";
    private static final String TYPED_ARRAY_TYPE = "android.content.res.TypedArray";
    private static final String TYPEFACE_TYPE = "android.graphics.Typeface";
    private static final String NULLABLE_ANNOTATION_NAME = "Nullable";
    private static final String STRING_TYPE = "java.lang.String";
    private static final String LIST_TYPE = List.class.getCanonicalName();
    private static final List<Class<? extends Annotation>> LISTENERS = Arrays.asList(OnCheckedChanged.class, OnClick.class, OnEditorAction.class, OnFocusChange.class, OnItemClick.class, OnItemLongClick.class, OnItemSelected.class, OnLongClick.class, OnPageChange.class, OnTextChanged.class, OnTouch.class);
    private Types typeUtils;
    private Filer filer;
    @Nullable
    private Trees trees;
    private int sdk = 1;
    private boolean debuggable = true;
    private final RScanner rScanner = new RScanner();

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        String sdk = env.getOptions().get(OPTION_SDK_INT);
        if (sdk != null) {
            try {
                this.sdk = Integer.parseInt(sdk);
            }
            catch (NumberFormatException e) {
                env.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unable to parse supplied minSdk option '" + sdk + "'. Falling back to API 1 support.");
            }
        }
        this.debuggable = !"false".equals(env.getOptions().get(OPTION_DEBUGGABLE));
        this.typeUtils = env.getTypeUtils();
        this.filer = env.getFiler();
        try {
            this.trees = Trees.instance(this.processingEnv);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public Set<String> getSupportedOptions() {
        return ImmutableSet.of((Object)OPTION_SDK_INT, (Object)OPTION_DEBUGGABLE);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        for (Class<? extends Annotation> annotation : this.getSupportedAnnotations()) {
            types.add(annotation.getCanonicalName());
        }
        return types;
    }

    private Set<Class<? extends Annotation>> getSupportedAnnotations() {
        LinkedHashSet<Class<? extends Annotation>> annotations = new LinkedHashSet<Class<? extends Annotation>>();
        annotations.add(BindAnim.class);
        annotations.add(BindArray.class);
        annotations.add(BindBitmap.class);
        annotations.add(BindBool.class);
        annotations.add(BindColor.class);
        annotations.add(BindDimen.class);
        annotations.add(BindDrawable.class);
        annotations.add(BindFloat.class);
        annotations.add(BindFont.class);
        annotations.add(BindInt.class);
        annotations.add(BindString.class);
        annotations.add(BindView.class);
        annotations.add(BindViews.class);
        annotations.addAll(LISTENERS);
        return annotations;
    }

    @Override
    public boolean process(Set<? extends TypeElement> elements, RoundEnvironment env) {
        Map<TypeElement, BindingSet> bindingMap = this.findAndParseTargets(env);
        for (Map.Entry<TypeElement, BindingSet> entry : bindingMap.entrySet()) {
            TypeElement typeElement = entry.getKey();
            BindingSet binding = entry.getValue();
            JavaFile javaFile = binding.brewJava(this.sdk, this.debuggable);
            try {
                javaFile.writeTo(this.filer);
            }
            catch (IOException e) {
                this.error(typeElement, "Unable to write binding for type %s: %s", typeElement, e.getMessage());
            }
        }
        return false;
    }

    private Map<TypeElement, BindingSet> findAndParseTargets(RoundEnvironment env) {
        LinkedHashMap<TypeElement, BindingSet.Builder> builderMap = new LinkedHashMap<TypeElement, BindingSet.Builder>();
        LinkedHashSet<TypeElement> erasedTargetNames = new LinkedHashSet<TypeElement>();
        for (Element element : env.getElementsAnnotatedWith(BindAnim.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceAnimation(element, builderMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindAnim.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindArray.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceArray(element, builderMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindArray.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindBitmap.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceBitmap(element, builderMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindBitmap.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindBool.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceBool(element, builderMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindBool.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindColor.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceColor(element, builderMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindColor.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindDimen.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceDimen(element, builderMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindDimen.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindDrawable.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceDrawable(element, builderMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindDrawable.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindFloat.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceFloat(element, builderMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindFloat.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindFont.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceFont(element, builderMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindFont.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindInt.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceInt(element, builderMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindInt.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindString.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceString(element, builderMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindString.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindView.class)) {
            try {
                this.parseBindView(element, builderMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindView.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindViews.class)) {
            try {
                this.parseBindViews(element, builderMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindViews.class, e);
            }
        }
        for (Class clazz : LISTENERS) {
            this.findAndParseListener(env, clazz, builderMap, erasedTargetNames);
        }
        ArrayDeque entries = new ArrayDeque(builderMap.entrySet());
        LinkedHashMap<TypeElement, BindingSet> linkedHashMap = new LinkedHashMap<TypeElement, BindingSet>();
        while (!entries.isEmpty()) {
            Map.Entry entry = (Map.Entry)entries.removeFirst();
            TypeElement type = (TypeElement)entry.getKey();
            BindingSet.Builder builder = (BindingSet.Builder)entry.getValue();
            TypeElement parentType = this.findParentType(type, erasedTargetNames);
            if (parentType == null) {
                linkedHashMap.put(type, builder.build());
                continue;
            }
            BindingSet parentBinding = (BindingSet)linkedHashMap.get(parentType);
            if (parentBinding != null) {
                builder.setParent(parentBinding);
                linkedHashMap.put(type, builder.build());
                continue;
            }
            entries.addLast(entry);
        }
        return linkedHashMap;
    }

    private void logParsingError(Element element, Class<? extends Annotation> annotation, Exception e) {
        StringWriter stackTrace = new StringWriter();
        e.printStackTrace(new PrintWriter(stackTrace));
        this.error(element, "Unable to parse @%s binding.\n\n%s", annotation.getSimpleName(), stackTrace);
    }

    private boolean isInaccessibleViaGeneratedCode(Class<? extends Annotation> annotationClass, String targetThing, Element element) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.STATIC)) {
            this.error(element, "@%s %s must not be private or static. (%s.%s)", annotationClass.getSimpleName(), targetThing, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (enclosingElement.getKind() != ElementKind.CLASS) {
            this.error(enclosingElement, "@%s %s may only be contained in classes. (%s.%s)", annotationClass.getSimpleName(), targetThing, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (enclosingElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.error(enclosingElement, "@%s %s may not be contained in private classes. (%s.%s)", annotationClass.getSimpleName(), targetThing, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        return hasError;
    }

    private boolean isBindingInWrongPackage(Class<? extends Annotation> annotationClass, Element element) {
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        String qualifiedName = enclosingElement.getQualifiedName().toString();
        if (qualifiedName.startsWith("android.")) {
            this.error(element, "@%s-annotated class incorrectly in Android framework package. (%s)", annotationClass.getSimpleName(), qualifiedName);
            return true;
        }
        if (qualifiedName.startsWith("java.")) {
            this.error(element, "@%s-annotated class incorrectly in Java framework package. (%s)", annotationClass.getSimpleName(), qualifiedName);
            return true;
        }
        return false;
    }

    private void parseBindView(Element element, Map<TypeElement, BindingSet.Builder> builderMap, Set<TypeElement> erasedTargetNames) {
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        boolean hasError = this.isInaccessibleViaGeneratedCode(BindView.class, "fields", element) || this.isBindingInWrongPackage(BindView.class, element);
        TypeMirror elementType = element.asType();
        if (elementType.getKind() == TypeKind.TYPEVAR) {
            TypeVariable typeVariable = (TypeVariable)elementType;
            elementType = typeVariable.getUpperBound();
        }
        Name qualifiedName = enclosingElement.getQualifiedName();
        Name simpleName = element.getSimpleName();
        if (!ButterKnifeProcessor.isSubtypeOfType(elementType, VIEW_TYPE) && !this.isInterface(elementType)) {
            if (elementType.getKind() == TypeKind.ERROR) {
                this.note(element, "@%s field with unresolved type (%s) must elsewhere be generated as a View or interface. (%s.%s)", BindView.class.getSimpleName(), elementType, qualifiedName, simpleName);
            } else {
                this.error(element, "@%s fields must extend from View or be an interface. (%s.%s)", BindView.class.getSimpleName(), qualifiedName, simpleName);
                hasError = true;
            }
        }
        if (hasError) {
            return;
        }
        int id = element.getAnnotation(BindView.class).value();
        BindingSet.Builder builder = builderMap.get(enclosingElement);
        Id resourceId = this.elementToId(element, BindView.class, id);
        if (builder != null) {
            String existingBindingName = builder.findExistingBindingName(resourceId);
            if (existingBindingName != null) {
                this.error(element, "Attempt to use @%s for an already bound ID %d on '%s'. (%s.%s)", BindView.class.getSimpleName(), id, existingBindingName, enclosingElement.getQualifiedName(), element.getSimpleName());
                return;
            }
        } else {
            builder = this.getOrCreateBindingBuilder(builderMap, enclosingElement);
        }
        String name = simpleName.toString();
        TypeName type = TypeName.get((TypeMirror)elementType);
        boolean required = ButterKnifeProcessor.isFieldRequired(element);
        builder.addField(resourceId, new FieldViewBinding(name, type, required));
        erasedTargetNames.add(enclosingElement);
    }

    private void parseBindViews(Element element, Map<TypeElement, BindingSet.Builder> builderMap, Set<TypeElement> erasedTargetNames) {
        Integer duplicateId;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        boolean hasError = this.isInaccessibleViaGeneratedCode(BindViews.class, "fields", element) || this.isBindingInWrongPackage(BindViews.class, element);
        TypeMirror elementType = element.asType();
        String erasedType = this.doubleErasure(elementType);
        TypeMirror viewType = null;
        FieldCollectionViewBinding.Kind kind = null;
        if (elementType.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)elementType;
            viewType = arrayType.getComponentType();
            kind = FieldCollectionViewBinding.Kind.ARRAY;
        } else if (LIST_TYPE.equals(erasedType)) {
            DeclaredType declaredType = (DeclaredType)elementType;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments.size() != 1) {
                this.error(element, "@%s List must have a generic component. (%s.%s)", BindViews.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
                hasError = true;
            } else {
                viewType = typeArguments.get(0);
            }
            kind = FieldCollectionViewBinding.Kind.LIST;
        } else {
            this.error(element, "@%s must be a List or array. (%s.%s)", BindViews.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (viewType != null && viewType.getKind() == TypeKind.TYPEVAR) {
            TypeVariable typeVariable = (TypeVariable)viewType;
            viewType = typeVariable.getUpperBound();
        }
        if (viewType != null && !ButterKnifeProcessor.isSubtypeOfType(viewType, VIEW_TYPE) && !this.isInterface(viewType)) {
            if (viewType.getKind() == TypeKind.ERROR) {
                this.note(element, "@%s List or array with unresolved type (%s) must elsewhere be generated as a View or interface. (%s.%s)", BindViews.class.getSimpleName(), viewType, enclosingElement.getQualifiedName(), element.getSimpleName());
            } else {
                this.error(element, "@%s List or array type must extend from View or be an interface. (%s.%s)", BindViews.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
                hasError = true;
            }
        }
        String name = element.getSimpleName().toString();
        int[] ids = element.getAnnotation(BindViews.class).value();
        if (ids.length == 0) {
            this.error(element, "@%s must specify at least one ID. (%s.%s)", BindViews.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if ((duplicateId = ButterKnifeProcessor.findDuplicate(ids)) != null) {
            this.error(element, "@%s annotation contains duplicate ID %d. (%s.%s)", BindViews.class.getSimpleName(), duplicateId, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (hasError) {
            return;
        }
        TypeName type = TypeName.get((TypeMirror)Objects.requireNonNull(viewType));
        boolean required = ButterKnifeProcessor.isFieldRequired(element);
        BindingSet.Builder builder = this.getOrCreateBindingBuilder(builderMap, enclosingElement);
        builder.addFieldCollection(new FieldCollectionViewBinding(name, type, Objects.requireNonNull(kind), new ArrayList<Id>(this.elementToIds(element, BindViews.class, ids).values()), required));
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceAnimation(Element element, Map<TypeElement, BindingSet.Builder> builderMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        if (!ANIMATION_TYPE.equals(element.asType().toString())) {
            this.error(element, "@%s field type must be 'Animation'. (%s.%s)", BindAnim.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindAnim.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindAnim.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindAnim.class).value();
        Id resourceId = this.elementToId(element, BindAnim.class, id);
        BindingSet.Builder builder = this.getOrCreateBindingBuilder(builderMap, enclosingElement);
        builder.addResource(new FieldAnimationBinding(resourceId, name));
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceBool(Element element, Map<TypeElement, BindingSet.Builder> builderMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        if (element.asType().getKind() != TypeKind.BOOLEAN) {
            this.error(element, "@%s field type must be 'boolean'. (%s.%s)", BindBool.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindBool.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindBool.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindBool.class).value();
        Id resourceId = this.elementToId(element, BindBool.class, id);
        BindingSet.Builder builder = this.getOrCreateBindingBuilder(builderMap, enclosingElement);
        builder.addResource(new FieldResourceBinding(resourceId, name, FieldResourceBinding.Type.BOOL));
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceColor(Element element, Map<TypeElement, BindingSet.Builder> builderMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        boolean isColorStateList = false;
        TypeMirror elementType = element.asType();
        if (COLOR_STATE_LIST_TYPE.equals(elementType.toString())) {
            isColorStateList = true;
        } else if (elementType.getKind() != TypeKind.INT) {
            this.error(element, "@%s field type must be 'int' or 'ColorStateList'. (%s.%s)", BindColor.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindColor.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindColor.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindColor.class).value();
        Id resourceId = this.elementToId(element, BindColor.class, id);
        BindingSet.Builder builder = this.getOrCreateBindingBuilder(builderMap, enclosingElement);
        FieldResourceBinding.Type colorStateList = FieldResourceBinding.Type.COLOR_STATE_LIST;
        FieldResourceBinding.Type color = FieldResourceBinding.Type.COLOR;
        builder.addResource(new FieldResourceBinding(resourceId, name, isColorStateList ? colorStateList : color));
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceDimen(Element element, Map<TypeElement, BindingSet.Builder> builderMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        boolean isInt = false;
        TypeMirror elementType = element.asType();
        if (elementType.getKind() == TypeKind.INT) {
            isInt = true;
        } else if (elementType.getKind() != TypeKind.FLOAT) {
            this.error(element, "@%s field type must be 'int' or 'float'. (%s.%s)", BindDimen.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindDimen.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindDimen.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindDimen.class).value();
        Id resourceId = this.elementToId(element, BindDimen.class, id);
        BindingSet.Builder builder = this.getOrCreateBindingBuilder(builderMap, enclosingElement);
        builder.addResource(new FieldResourceBinding(resourceId, name, isInt ? FieldResourceBinding.Type.DIMEN_AS_INT : FieldResourceBinding.Type.DIMEN_AS_FLOAT));
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceBitmap(Element element, Map<TypeElement, BindingSet.Builder> builderMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        if (!BITMAP_TYPE.equals(element.asType().toString())) {
            this.error(element, "@%s field type must be 'Bitmap'. (%s.%s)", BindBitmap.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindBitmap.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindBitmap.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindBitmap.class).value();
        Id resourceId = this.elementToId(element, BindBitmap.class, id);
        BindingSet.Builder builder = this.getOrCreateBindingBuilder(builderMap, enclosingElement);
        builder.addResource(new FieldResourceBinding(resourceId, name, FieldResourceBinding.Type.BITMAP));
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceDrawable(Element element, Map<TypeElement, BindingSet.Builder> builderMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        if (!DRAWABLE_TYPE.equals(element.asType().toString())) {
            this.error(element, "@%s field type must be 'Drawable'. (%s.%s)", BindDrawable.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindDrawable.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindDrawable.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindDrawable.class).value();
        int tint = element.getAnnotation(BindDrawable.class).tint();
        Map<Integer, Id> resourceIds = this.elementToIds(element, BindDrawable.class, new int[]{id, tint});
        BindingSet.Builder builder = this.getOrCreateBindingBuilder(builderMap, enclosingElement);
        builder.addResource(new FieldDrawableBinding(resourceIds.get(id), name, resourceIds.get(tint)));
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceFloat(Element element, Map<TypeElement, BindingSet.Builder> builderMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        if (element.asType().getKind() != TypeKind.FLOAT) {
            this.error(element, "@%s field type must be 'float'. (%s.%s)", BindFloat.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindFloat.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindFloat.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindFloat.class).value();
        Id resourceId = this.elementToId(element, BindFloat.class, id);
        BindingSet.Builder builder = this.getOrCreateBindingBuilder(builderMap, enclosingElement);
        builder.addResource(new FieldResourceBinding(resourceId, name, FieldResourceBinding.Type.FLOAT));
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceFont(Element element, Map<TypeElement, BindingSet.Builder> builderMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        if (!TYPEFACE_TYPE.equals(element.asType().toString())) {
            this.error(element, "@%s field type must be 'Typeface'. (%s.%s)", BindFont.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindFont.class, "fields", element);
        hasError |= this.isBindingInWrongPackage(BindFont.class, element);
        String name = element.getSimpleName().toString();
        BindFont bindFont = element.getAnnotation(BindFont.class);
        int styleValue = bindFont.style();
        FieldTypefaceBinding.TypefaceStyles style = FieldTypefaceBinding.TypefaceStyles.fromValue(styleValue);
        if (style == null) {
            this.error(element, "@%s style must be NORMAL, BOLD, ITALIC, or BOLD_ITALIC. (%s.%s)", BindFont.class.getSimpleName(), enclosingElement.getQualifiedName(), name);
            hasError = true;
        }
        if (hasError) {
            return;
        }
        BindingSet.Builder builder = this.getOrCreateBindingBuilder(builderMap, enclosingElement);
        Id resourceId = this.elementToId(element, BindFont.class, bindFont.value());
        builder.addResource(new FieldTypefaceBinding(resourceId, name, style));
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceInt(Element element, Map<TypeElement, BindingSet.Builder> builderMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        if (element.asType().getKind() != TypeKind.INT) {
            this.error(element, "@%s field type must be 'int'. (%s.%s)", BindInt.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindInt.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindInt.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindInt.class).value();
        Id resourceId = this.elementToId(element, BindInt.class, id);
        BindingSet.Builder builder = this.getOrCreateBindingBuilder(builderMap, enclosingElement);
        builder.addResource(new FieldResourceBinding(resourceId, name, FieldResourceBinding.Type.INT));
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceString(Element element, Map<TypeElement, BindingSet.Builder> builderMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        if (!STRING_TYPE.equals(element.asType().toString())) {
            this.error(element, "@%s field type must be 'String'. (%s.%s)", BindString.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindString.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindString.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindString.class).value();
        Id resourceId = this.elementToId(element, BindString.class, id);
        BindingSet.Builder builder = this.getOrCreateBindingBuilder(builderMap, enclosingElement);
        builder.addResource(new FieldResourceBinding(resourceId, name, FieldResourceBinding.Type.STRING));
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceArray(Element element, Map<TypeElement, BindingSet.Builder> builderMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        FieldResourceBinding.Type type = ButterKnifeProcessor.getArrayResourceMethodName(element);
        if (type == null) {
            this.error(element, "@%s field type must be one of: String[], int[], CharSequence[], %s. (%s.%s)", BindArray.class.getSimpleName(), TYPED_ARRAY_TYPE, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindArray.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindArray.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindArray.class).value();
        Id resourceId = this.elementToId(element, BindArray.class, id);
        BindingSet.Builder builder = this.getOrCreateBindingBuilder(builderMap, enclosingElement);
        builder.addResource(new FieldResourceBinding(resourceId, name, Objects.requireNonNull(type)));
        erasedTargetNames.add(enclosingElement);
    }

    @Nullable
    private static FieldResourceBinding.Type getArrayResourceMethodName(Element element) {
        TypeMirror typeMirror = element.asType();
        if (TYPED_ARRAY_TYPE.equals(typeMirror.toString())) {
            return FieldResourceBinding.Type.TYPED_ARRAY;
        }
        if (TypeKind.ARRAY.equals((Object)typeMirror.getKind())) {
            ArrayType arrayType = (ArrayType)typeMirror;
            String componentType = arrayType.getComponentType().toString();
            if (STRING_TYPE.equals(componentType)) {
                return FieldResourceBinding.Type.STRING_ARRAY;
            }
            if ("int".equals(componentType)) {
                return FieldResourceBinding.Type.INT_ARRAY;
            }
            if ("java.lang.CharSequence".equals(componentType)) {
                return FieldResourceBinding.Type.TEXT_ARRAY;
            }
        }
        return null;
    }

    @Nullable
    private static Integer findDuplicate(int[] array) {
        LinkedHashSet<Integer> seenElements = new LinkedHashSet<Integer>();
        for (int element : array) {
            if (seenElements.add(element)) continue;
            return element;
        }
        return null;
    }

    private String doubleErasure(TypeMirror elementType) {
        String name = this.typeUtils.erasure(elementType).toString();
        int typeParamStart = name.indexOf(60);
        if (typeParamStart != -1) {
            name = name.substring(0, typeParamStart);
        }
        return name;
    }

    private void findAndParseListener(RoundEnvironment env, Class<? extends Annotation> annotationClass, Map<TypeElement, BindingSet.Builder> builderMap, Set<TypeElement> erasedTargetNames) {
        for (Element element : env.getElementsAnnotatedWith(annotationClass)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseListenerAnnotation(annotationClass, element, builderMap, erasedTargetNames);
            }
            catch (Exception e) {
                StringWriter stackTrace = new StringWriter();
                e.printStackTrace(new PrintWriter(stackTrace));
                this.error(element, "Unable to generate view binder for @%s.\n\n%s", annotationClass.getSimpleName(), stackTrace.toString());
            }
        }
    }

    private void parseListenerAnnotation(Class<? extends Annotation> annotationClass, Element element, Map<TypeElement, BindingSet.Builder> builderMap, Set<TypeElement> erasedTargetNames) throws Exception {
        String returnTypeString;
        boolean hasReturnValue;
        TypeMirror returnType;
        ListenerMethod method;
        ListenerClass listener;
        if (!(element instanceof ExecutableElement) || element.getKind() != ElementKind.METHOD) {
            throw new IllegalStateException(String.format("@%s annotation must be on a method.", annotationClass.getSimpleName()));
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        Annotation annotation = element.getAnnotation(annotationClass);
        Method annotationValue = annotationClass.getDeclaredMethod("value", new Class[0]);
        if (annotationValue.getReturnType() != int[].class) {
            throw new IllegalStateException(String.format("@%s annotation value() type not int[].", annotationClass));
        }
        int[] ids = (int[])annotationValue.invoke((Object)annotation, new Object[0]);
        String name = executableElement.getSimpleName().toString();
        boolean required = ButterKnifeProcessor.isListenerRequired(executableElement);
        boolean hasError = this.isInaccessibleViaGeneratedCode(annotationClass, "methods", element);
        hasError |= this.isBindingInWrongPackage(annotationClass, element);
        Integer duplicateId = ButterKnifeProcessor.findDuplicate(ids);
        if (duplicateId != null) {
            this.error(element, "@%s annotation for method contains duplicate ID %d. (%s.%s)", annotationClass.getSimpleName(), duplicateId, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if ((listener = annotationClass.getAnnotation(ListenerClass.class)) == null) {
            throw new IllegalStateException(String.format("No @%s defined on @%s.", ListenerClass.class.getSimpleName(), annotationClass.getSimpleName()));
        }
        for (int id : ids) {
            if (id != ButterKnifeProcessor.NO_ID.value) continue;
            if (ids.length == 1) {
                if (required) continue;
                this.error(element, "ID-free binding must not be annotated with @Optional. (%s.%s)", enclosingElement.getQualifiedName(), element.getSimpleName());
                hasError = true;
                continue;
            }
            this.error(element, "@%s annotation contains invalid ID %d. (%s.%s)", annotationClass.getSimpleName(), id, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        ListenerMethod[] methods = listener.method();
        if (methods.length > 1) {
            throw new IllegalStateException(String.format("Multiple listener methods specified on @%s.", annotationClass.getSimpleName()));
        }
        if (methods.length == 1) {
            if (listener.callbacks() != ListenerClass.NONE.class) {
                throw new IllegalStateException(String.format("Both method() and callback() defined on @%s.", annotationClass.getSimpleName()));
            }
            method = methods[0];
        } else {
            Method annotationCallback = annotationClass.getDeclaredMethod("callback", new Class[0]);
            Enum callback = (Enum)annotationCallback.invoke((Object)annotation, new Object[0]);
            Field callbackField = callback.getDeclaringClass().getField(callback.name());
            method = callbackField.getAnnotation(ListenerMethod.class);
            if (method == null) {
                throw new IllegalStateException(String.format("No @%s defined on @%s's %s.%s.", ListenerMethod.class.getSimpleName(), annotationClass.getSimpleName(), callback.getDeclaringClass().getSimpleName(), callback.name()));
            }
        }
        List<? extends VariableElement> methodParameters = executableElement.getParameters();
        if (methodParameters.size() > method.parameters().length) {
            this.error(element, "@%s methods can have at most %s parameter(s). (%s.%s)", annotationClass.getSimpleName(), method.parameters().length, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if ((returnType = executableElement.getReturnType()) instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)returnType;
            returnType = typeVariable.getUpperBound();
        }
        boolean bl = hasReturnValue = !"void".equals(returnTypeString = returnType.toString());
        if (!returnTypeString.equals(method.returnType()) && hasReturnValue) {
            this.error(element, "@%s methods must have a '%s' return type. (%s.%s)", annotationClass.getSimpleName(), method.returnType(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (hasError) {
            return;
        }
        Parameter[] parameters = Parameter.NONE;
        if (!methodParameters.isEmpty()) {
            parameters = new Parameter[methodParameters.size()];
            BitSet methodParameterUsed = new BitSet(methodParameters.size());
            String[] parameterTypes = method.parameters();
            for (int i = 0; i < methodParameters.size(); ++i) {
                VariableElement methodParameter = methodParameters.get(i);
                TypeMirror methodParameterType = methodParameter.asType();
                if (methodParameterType instanceof TypeVariable) {
                    TypeVariable typeVariable = (TypeVariable)methodParameterType;
                    methodParameterType = typeVariable.getUpperBound();
                }
                for (int j = 0; j < parameterTypes.length; ++j) {
                    if (methodParameterUsed.get(j) || (!ButterKnifeProcessor.isSubtypeOfType(methodParameterType, parameterTypes[j]) || !ButterKnifeProcessor.isSubtypeOfType(methodParameterType, VIEW_TYPE)) && !ButterKnifeProcessor.isTypeEqual(methodParameterType, parameterTypes[j]) && !this.isInterface(methodParameterType)) continue;
                    parameters[i] = new Parameter(j, TypeName.get((TypeMirror)methodParameterType));
                    methodParameterUsed.set(j);
                    break;
                }
                if (parameters[i] != null) continue;
                StringBuilder builder = new StringBuilder();
                builder.append("Unable to match @").append(annotationClass.getSimpleName()).append(" method arguments. (").append(enclosingElement.getQualifiedName()).append('.').append(element.getSimpleName()).append(')');
                for (int j = 0; j < parameters.length; ++j) {
                    Parameter parameter = parameters[j];
                    builder.append("\n\n  Parameter #").append(j + 1).append(": ").append(methodParameters.get(j).asType().toString()).append("\n    ");
                    if (parameter == null) {
                        builder.append("did not match any listener parameters");
                        continue;
                    }
                    builder.append("matched listener parameter #").append(parameter.getListenerPosition() + 1).append(": ").append(parameter.getType());
                }
                builder.append("\n\nMethods may have up to ").append(method.parameters().length).append(" parameter(s):\n");
                for (String parameterType : method.parameters()) {
                    builder.append("\n  ").append(parameterType);
                }
                builder.append("\n\nThese may be listed in any order but will be searched for from top to bottom.");
                this.error(executableElement, builder.toString(), new Object[0]);
                return;
            }
        }
        MethodViewBinding binding = new MethodViewBinding(name, Arrays.asList(parameters), required, hasReturnValue);
        BindingSet.Builder builder = this.getOrCreateBindingBuilder(builderMap, enclosingElement);
        Map<Integer, Id> resourceIds = this.elementToIds(element, annotationClass, ids);
        for (Map.Entry<Integer, Id> entry : resourceIds.entrySet()) {
            if (builder.addMethod(entry.getValue(), listener, method, binding)) continue;
            this.error(element, "Multiple listener methods with return value specified for ID %d. (%s.%s)", entry.getKey(), enclosingElement.getQualifiedName(), element.getSimpleName());
            return;
        }
        erasedTargetNames.add(enclosingElement);
    }

    private boolean isInterface(TypeMirror typeMirror) {
        return typeMirror instanceof DeclaredType && ((DeclaredType)typeMirror).asElement().getKind() == ElementKind.INTERFACE;
    }

    static boolean isSubtypeOfType(TypeMirror typeMirror, String otherType) {
        Element element;
        if (ButterKnifeProcessor.isTypeEqual(typeMirror, otherType)) {
            return true;
        }
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return false;
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.size() > 0) {
            StringBuilder typeString = new StringBuilder(declaredType.asElement().toString());
            typeString.append('<');
            for (int i = 0; i < typeArguments.size(); ++i) {
                if (i > 0) {
                    typeString.append(',');
                }
                typeString.append('?');
            }
            typeString.append('>');
            if (typeString.toString().equals(otherType)) {
                return true;
            }
        }
        if (!((element = declaredType.asElement()) instanceof TypeElement)) {
            return false;
        }
        TypeElement typeElement = (TypeElement)element;
        TypeMirror superType = typeElement.getSuperclass();
        if (ButterKnifeProcessor.isSubtypeOfType(superType, otherType)) {
            return true;
        }
        for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
            if (!ButterKnifeProcessor.isSubtypeOfType(typeMirror2, otherType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTypeEqual(TypeMirror typeMirror, String otherType) {
        return otherType.equals(typeMirror.toString());
    }

    private BindingSet.Builder getOrCreateBindingBuilder(Map<TypeElement, BindingSet.Builder> builderMap, TypeElement enclosingElement) {
        BindingSet.Builder builder = builderMap.get(enclosingElement);
        if (builder == null) {
            builder = BindingSet.newBuilder(enclosingElement);
            builderMap.put(enclosingElement, builder);
        }
        return builder;
    }

    @Nullable
    private TypeElement findParentType(TypeElement typeElement, Set<TypeElement> parents) {
        TypeMirror type;
        do {
            if ((type = typeElement.getSuperclass()).getKind() != TypeKind.NONE) continue;
            return null;
        } while (!parents.contains(typeElement = (TypeElement)((DeclaredType)type).asElement()));
        return typeElement;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void error(Element element, String message, Object ... args) {
        this.printMessage(Diagnostic.Kind.ERROR, element, message, args);
    }

    private void note(Element element, String message, Object ... args) {
        this.printMessage(Diagnostic.Kind.NOTE, element, message, args);
    }

    private void printMessage(Diagnostic.Kind kind, Element element, String message, Object[] args) {
        if (args.length > 0) {
            message = String.format(message, args);
        }
        this.processingEnv.getMessager().printMessage(kind, message, element);
    }

    private Id elementToId(Element element, Class<? extends Annotation> annotation, int value) {
        JCTree tree = (JCTree)this.trees.getTree(element, ButterKnifeProcessor.getMirror(element, annotation));
        if (tree != null) {
            this.rScanner.reset();
            tree.accept(this.rScanner);
            if (!this.rScanner.resourceIds.isEmpty()) {
                return this.rScanner.resourceIds.values().iterator().next();
            }
        }
        return new Id(value);
    }

    private Map<Integer, Id> elementToIds(Element element, Class<? extends Annotation> annotation, int[] values) {
        LinkedHashMap<Integer, Id> resourceIds = new LinkedHashMap();
        JCTree tree = (JCTree)this.trees.getTree(element, ButterKnifeProcessor.getMirror(element, annotation));
        if (tree != null) {
            this.rScanner.reset();
            tree.accept(this.rScanner);
            resourceIds = this.rScanner.resourceIds;
        }
        for (int value : values) {
            resourceIds.putIfAbsent(value, new Id(value));
        }
        return resourceIds;
    }

    private static boolean hasAnnotationWithName(Element element, String simpleName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String annotationName = annotationMirror.getAnnotationType().asElement().getSimpleName().toString();
            if (!simpleName.equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFieldRequired(Element element) {
        return !ButterKnifeProcessor.hasAnnotationWithName(element, NULLABLE_ANNOTATION_NAME);
    }

    private static boolean isListenerRequired(ExecutableElement element) {
        return element.getAnnotation(Optional.class) == null;
    }

    @Nullable
    private static AnnotationMirror getMirror(Element element, Class<? extends Annotation> annotation) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotation.getCanonicalName())) continue;
            return annotationMirror;
        }
        return null;
    }

    private static class RScanner
    extends TreeScanner {
        Map<Integer, Id> resourceIds = new LinkedHashMap<Integer, Id>();

        private RScanner() {
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jcFieldAccess) {
            Symbol symbol = jcFieldAccess.sym;
            if (symbol.getEnclosingElement() != null && symbol.getEnclosingElement().getEnclosingElement() != null && symbol.getEnclosingElement().getEnclosingElement().enclClass() != null) {
                try {
                    int value = (Integer)Objects.requireNonNull(((Symbol.VarSymbol)symbol).getConstantValue());
                    this.resourceIds.put(value, new Id(value, symbol));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void visitLiteral(JCTree.JCLiteral jcLiteral) {
            try {
                int value = (Integer)jcLiteral.value;
                this.resourceIds.put(value, new Id(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void reset() {
            this.resourceIds.clear();
        }
    }
}

