/*
 * Decompiled with CFR 0.152.
 */
package butterknife.compiler;

import butterknife.compiler.FieldBitmapBinding;
import butterknife.compiler.FieldCollectionViewBinding;
import butterknife.compiler.FieldDrawableBinding;
import butterknife.compiler.FieldResourceBinding;
import butterknife.compiler.FieldViewBinding;
import butterknife.compiler.MethodViewBinding;
import butterknife.compiler.Parameter;
import butterknife.compiler.ViewBinding;
import butterknife.compiler.ViewBindings;
import butterknife.internal.ListenerClass;
import butterknife.internal.ListenerMethod;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;

final class BindingClass {
    private static final ClassName FINDER = ClassName.get((String)"butterknife.internal", (String)"Finder", (String[])new String[0]);
    private static final ClassName VIEW_BINDER = ClassName.get((String)"butterknife.internal", (String)"ViewBinder", (String[])new String[0]);
    private static final ClassName UTILS = ClassName.get((String)"butterknife.internal", (String)"Utils", (String[])new String[0]);
    private static final ClassName VIEW = ClassName.get((String)"android.view", (String)"View", (String[])new String[0]);
    private static final ClassName CONTEXT = ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]);
    private static final ClassName RESOURCES = ClassName.get((String)"android.content.res", (String)"Resources", (String[])new String[0]);
    private static final ClassName THEME = RESOURCES.nestedClass("Theme");
    private static final ClassName BUTTERKNIFE = ClassName.get((String)"butterknife", (String)"ButterKnife", (String[])new String[0]);
    private static final ClassName UNBINDER = ClassName.get((String)"butterknife", (String)"Unbinder", (String[])new String[0]);
    private static final ClassName BITMAP_FACTORY = ClassName.get((String)"android.graphics", (String)"BitmapFactory", (String[])new String[0]);
    public static final String UNBINDER_SIMPLE_NAME = "InnerUnbinder";
    private final Map<Integer, ViewBindings> viewIdMap = new LinkedHashMap<Integer, ViewBindings>();
    private final Map<FieldCollectionViewBinding, int[]> collectionBindings = new LinkedHashMap<FieldCollectionViewBinding, int[]>();
    private final List<FieldBitmapBinding> bitmapBindings = new ArrayList<FieldBitmapBinding>();
    private final List<FieldDrawableBinding> drawableBindings = new ArrayList<FieldDrawableBinding>();
    private final List<FieldResourceBinding> resourceBindings = new ArrayList<FieldResourceBinding>();
    private final Set<BindingClass> descendantBindingClasses = new LinkedHashSet<BindingClass>();
    private final String classPackage;
    private final String className;
    private final String targetClass;
    private final String classFqcn;
    private BindingClass parentBinding;
    private ClassName unbinderClassName;
    private ClassName highestUnbinderClassName;

    BindingClass(String classPackage, String className, String targetClass, String classFqcn) {
        this.classPackage = classPackage;
        this.className = className;
        this.targetClass = targetClass;
        this.classFqcn = classFqcn;
        this.unbinderClassName = ClassName.get((String)classPackage, (String)className, (String[])new String[]{UNBINDER_SIMPLE_NAME});
    }

    void addDescendant(BindingClass bindingClass) {
        this.descendantBindingClasses.add(bindingClass);
    }

    void addBitmap(FieldBitmapBinding binding) {
        this.bitmapBindings.add(binding);
    }

    void addDrawable(FieldDrawableBinding binding) {
        this.drawableBindings.add(binding);
    }

    void addField(int id, FieldViewBinding binding) {
        this.getOrCreateViewBindings(id).addFieldBinding(binding);
    }

    void addFieldCollection(int[] ids, FieldCollectionViewBinding binding) {
        this.collectionBindings.put(binding, ids);
    }

    boolean addMethod(int id, ListenerClass listener, ListenerMethod method, MethodViewBinding binding) {
        ViewBindings viewBindings = this.getOrCreateViewBindings(id);
        if (viewBindings.hasMethodBinding(listener, method) && !"void".equals(method.returnType())) {
            return false;
        }
        viewBindings.addMethodBinding(listener, method, binding);
        return true;
    }

    void addResource(FieldResourceBinding binding) {
        this.resourceBindings.add(binding);
    }

    void setParent(BindingClass parent) {
        this.parentBinding = parent;
    }

    ViewBindings getViewBinding(int id) {
        return this.viewIdMap.get(id);
    }

    private ViewBindings getOrCreateViewBindings(int id) {
        ViewBindings viewId = this.viewIdMap.get(id);
        if (viewId == null) {
            viewId = new ViewBindings(id);
            this.viewIdMap.put(id, viewId);
        }
        return viewId;
    }

    JavaFile brewJava() {
        TypeSpec.Builder result = TypeSpec.classBuilder((String)this.className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{ClassName.bestGuess((String)this.targetClass)}));
        if (this.hasParentBinding()) {
            result.superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.bestGuess((String)this.parentBinding.classFqcn), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}));
        } else {
            result.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)VIEW_BINDER, (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}));
        }
        result.addMethod(this.createBindMethod());
        if (this.hasUnbinder() && this.hasViewBindings()) {
            result.addType(this.createUnbinderClass());
            this.createUnbinderCreateUnbinderMethod(result);
        }
        return JavaFile.builder((String)this.classPackage, (TypeSpec)result.build()).addFileComment("Generated code from Butter Knife. Do not modify!", new Object[0]).build();
    }

    private TypeSpec createUnbinderClass() {
        TypeVariableName generic = TypeVariableName.get((String)"T");
        TypeSpec.Builder result = TypeSpec.classBuilder((String)this.unbinderClassName.simpleName()).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.STATIC}).addTypeVariable(TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{ClassName.bestGuess((String)this.targetClass)}));
        if (this.hasParentBinding() && this.parentBinding.hasUnbinder()) {
            result.superclass((TypeName)ParameterizedTypeName.get((ClassName)this.parentBinding.getUnbinderClassName(), (TypeName[])new TypeName[]{generic}));
        } else {
            result.addSuperinterface((TypeName)UNBINDER);
            result.addField((TypeName)generic, "target", new Modifier[]{Modifier.PRIVATE});
        }
        result.addMethod(this.createUnbinderConstructor((TypeName)generic));
        if (!this.hasParentBinding() || !this.parentBinding.hasUnbinder()) {
            result.addMethod(this.createUnbindInterfaceMethod());
        }
        result.addMethod(this.createUnbindMethod(result, (TypeName)generic));
        return result.build();
    }

    private MethodSpec createUnbinderConstructor(TypeName targetType) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(targetType, "target", new Modifier[0]);
        if (this.hasParentBinding() && this.parentBinding.hasUnbinder()) {
            constructor.addStatement("super(target)", new Object[0]);
        } else {
            constructor.addStatement("this.$1N = $1N", new Object[]{"target"});
        }
        return constructor.build();
    }

    private MethodSpec createUnbindInterfaceMethod() {
        return MethodSpec.methodBuilder((String)"unbind").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("if (target == null) throw new $T($S)", new Object[]{IllegalStateException.class, "Bindings already cleared."}).addStatement("unbind(target)", new Object[0]).addStatement("target = null", new Object[0]).build();
    }

    private MethodSpec createUnbindMethod(TypeSpec.Builder unbinderClass, TypeName targetType) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"unbind").addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(targetType, "target", new Modifier[0]);
        if (this.hasParentBinding() && this.parentBinding.hasUnbinder()) {
            result.addAnnotation(Override.class);
            result.addStatement("super.unbind(target)", new Object[0]);
        }
        for (ViewBindings bindings : this.viewIdMap.values()) {
            this.addFieldAndUnbindStatement(unbinderClass, result, bindings);
            for (FieldViewBinding fieldBinding : bindings.getFieldBindings()) {
                result.addStatement("target.$L = null", new Object[]{fieldBinding.getName()});
            }
        }
        for (FieldCollectionViewBinding fieldCollectionBinding : this.collectionBindings.keySet()) {
            result.addStatement("target.$L = null", new Object[]{fieldCollectionBinding.getName()});
        }
        return result.build();
    }

    private void addFieldAndUnbindStatement(TypeSpec.Builder result, MethodSpec.Builder unbindMethod, ViewBindings bindings) {
        Map<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> classMethodBindings = bindings.getMethodBindings();
        if (classMethodBindings.isEmpty()) {
            return;
        }
        String fieldName = "view" + bindings.getUniqueIdSuffix();
        result.addField((TypeName)VIEW, fieldName, new Modifier[0]);
        boolean needsNullChecked = bindings.getRequiredBindings().isEmpty();
        if (needsNullChecked) {
            unbindMethod.beginControlFlow("if ($L != null)", new Object[]{fieldName});
        }
        for (ListenerClass listenerClass : classMethodBindings.keySet()) {
            if (!"android.view.View".equals(listenerClass.targetType())) {
                unbindMethod.addStatement("(($T) $L).$L(null)", new Object[]{BindingClass.bestGuess(listenerClass.targetType()), fieldName, listenerClass.setter()});
                continue;
            }
            unbindMethod.addStatement("$L.$L(null)", new Object[]{fieldName, listenerClass.setter()});
        }
        if (needsNullChecked) {
            unbindMethod.endControlFlow();
        }
    }

    private void createUnbinderCreateUnbinderMethod(TypeSpec.Builder viewBindingClass) {
        ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)this.unbinderClassName, (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        MethodSpec.Builder createUnbinder = MethodSpec.methodBuilder((String)"createUnbinder").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)returnType).addParameter((TypeName)TypeVariableName.get((String)"T"), "target", new Modifier[0]).addStatement("return new $T($L)", new Object[]{this.unbinderClassName, "target"});
        if (this.hasParentBinding() && this.parentBinding.hasUnbinder()) {
            createUnbinder.addAnnotation(Override.class);
        }
        viewBindingClass.addMethod(createUnbinder.build());
    }

    private MethodSpec createBindMethod() {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"bind").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)UNBINDER).addParameter((TypeName)FINDER, "finder", new Modifier[]{Modifier.FINAL}).addParameter((TypeName)TypeVariableName.get((String)"T"), "target", new Modifier[]{Modifier.FINAL}).addParameter(Object.class, "source", new Modifier[0]);
        if (this.hasResourceBindings()) {
            result.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"ResourceType"}).build());
        }
        if (this.hasParentBinding()) {
            if (this.hasViewBindings()) {
                if (this.highestUnbinderClassName != this.unbinderClassName) {
                    result.addStatement("$T unbinder = ($T) super.bind(finder, target, source)", new Object[]{this.unbinderClassName, this.unbinderClassName});
                } else {
                    result.addStatement("super.bind(finder, target, source)", new Object[0]);
                    result.addStatement("$T unbinder = createUnbinder(target)", new Object[]{this.unbinderClassName});
                }
            } else {
                result.addStatement("$T unbinder = super.bind(finder, target, source)", new Object[]{UNBINDER});
            }
        } else if (this.hasViewBindings()) {
            result.addStatement("$T unbinder = createUnbinder(target)", new Object[]{this.unbinderClassName});
        }
        if (!this.viewIdMap.isEmpty() || !this.collectionBindings.isEmpty()) {
            result.addStatement("$T view", new Object[]{VIEW});
            for (ViewBindings viewBindings : this.viewIdMap.values()) {
                this.addViewBindings(result, viewBindings);
            }
            for (Map.Entry entry : this.collectionBindings.entrySet()) {
                this.emitCollectionBinding(result, (FieldCollectionViewBinding)entry.getKey(), (int[])entry.getValue());
            }
        }
        if (this.hasResourceBindings()) {
            if (this.hasResourceBindingsNeedingTheme()) {
                result.addStatement("$T context = finder.getContext(source)", new Object[]{CONTEXT});
                result.addStatement("$T res = context.getResources()", new Object[]{RESOURCES});
                result.addStatement("$T theme = context.getTheme()", new Object[]{THEME});
            } else {
                result.addStatement("$T res = finder.getContext(source).getResources()", new Object[]{RESOURCES});
            }
            for (FieldBitmapBinding fieldBitmapBinding : this.bitmapBindings) {
                result.addStatement("target.$L = $T.decodeResource(res, $L)", new Object[]{fieldBitmapBinding.getName(), BITMAP_FACTORY, fieldBitmapBinding.getId()});
            }
            for (FieldDrawableBinding fieldDrawableBinding : this.drawableBindings) {
                int tintAttributeId = fieldDrawableBinding.getTintAttributeId();
                if (tintAttributeId != 0) {
                    result.addStatement("target.$L = $T.getTintedDrawable(res, theme, $L, $L)", new Object[]{fieldDrawableBinding.getName(), UTILS, fieldDrawableBinding.getId(), tintAttributeId});
                    continue;
                }
                result.addStatement("target.$L = $T.getDrawable(res, theme, $L)", new Object[]{fieldDrawableBinding.getName(), UTILS, fieldDrawableBinding.getId()});
            }
            for (FieldResourceBinding fieldResourceBinding : this.resourceBindings) {
                if (fieldResourceBinding.isThemeable()) {
                    result.addStatement("target.$L = $T.$L(res, theme, $L)", new Object[]{fieldResourceBinding.getName(), UTILS, fieldResourceBinding.getMethod(), fieldResourceBinding.getId()});
                    continue;
                }
                result.addStatement("target.$L = res.$L($L)", new Object[]{fieldResourceBinding.getName(), fieldResourceBinding.getMethod(), fieldResourceBinding.getId()});
            }
        }
        if (this.hasParentBinding() || this.hasViewBindings()) {
            result.addStatement("return unbinder", new Object[0]);
        } else {
            result.addStatement("return $T.EMPTY", new Object[]{UNBINDER});
        }
        return result.build();
    }

    private void emitCollectionBinding(MethodSpec.Builder result, FieldCollectionViewBinding binding, int[] ids) {
        String ofName;
        switch (binding.getKind()) {
            case ARRAY: {
                ofName = "arrayOf";
                break;
            }
            case LIST: {
                ofName = "listOf";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown kind: " + (Object)((Object)binding.getKind()));
            }
        }
        CodeBlock.Builder builder = CodeBlock.builder();
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                builder.add(", ", new Object[0]);
            }
            String findMethod = binding.isRequired() ? "findRequiredView" : "findOptionalView";
            builder.add("\nfinder.<$T>$L(source, $L, $S)", new Object[]{binding.getType(), findMethod, ids[i], BindingClass.asHumanDescription(Collections.singletonList(binding))});
        }
        result.addStatement("target.$L = $T.$L($L)", new Object[]{binding.getName(), UTILS, ofName, builder.build()});
    }

    private void addViewBindings(MethodSpec.Builder result, ViewBindings bindings) {
        List<ViewBinding> requiredViewBindings = bindings.getRequiredBindings();
        if (requiredViewBindings.isEmpty()) {
            result.addStatement("view = finder.findOptionalView(source, $L, null)", new Object[]{bindings.getId()});
        } else if (bindings.getId() == -1) {
            result.addStatement("view = target", new Object[0]);
        } else {
            result.addStatement("view = finder.findRequiredView(source, $L, $S)", new Object[]{bindings.getId(), BindingClass.asHumanDescription(requiredViewBindings)});
        }
        this.addFieldBindings(result, bindings);
        this.addMethodBindings(result, bindings);
    }

    private void addFieldBindings(MethodSpec.Builder result, ViewBindings bindings) {
        Collection<FieldViewBinding> fieldBindings = bindings.getFieldBindings();
        for (FieldViewBinding fieldBinding : fieldBindings) {
            if (fieldBinding.requiresCast()) {
                result.addStatement("target.$L = finder.castView(view, $L, $S)", new Object[]{fieldBinding.getName(), bindings.getId(), BindingClass.asHumanDescription(fieldBindings)});
                continue;
            }
            result.addStatement("target.$L = view", new Object[]{fieldBinding.getName()});
        }
    }

    private void addMethodBindings(MethodSpec.Builder result, ViewBindings bindings) {
        Map<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> classMethodBindings = bindings.getMethodBindings();
        if (classMethodBindings.isEmpty()) {
            return;
        }
        boolean needsNullChecked = bindings.getRequiredBindings().isEmpty();
        if (needsNullChecked) {
            result.beginControlFlow("if (view != null)", new Object[0]);
        }
        if (this.hasUnbinder()) {
            result.addStatement("unbinder.$L = view", new Object[]{"view" + bindings.getUniqueIdSuffix()});
        }
        for (Map.Entry<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> e : classMethodBindings.entrySet()) {
            ListenerClass listener = e.getKey();
            Map<ListenerMethod, Set<MethodViewBinding>> methodBindings = e.getValue();
            TypeSpec.Builder callback = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)ClassName.bestGuess((String)listener.type()));
            for (ListenerMethod method : BindingClass.getListenerMethods(listener)) {
                MethodSpec.Builder callbackMethod = MethodSpec.methodBuilder((String)method.name()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(BindingClass.bestGuess(method.returnType()));
                String[] parameterTypes = method.parameters();
                int count = parameterTypes.length;
                for (int i = 0; i < count; ++i) {
                    callbackMethod.addParameter(BindingClass.bestGuess(parameterTypes[i]), "p" + i, new Modifier[0]);
                }
                boolean hasReturnType = !"void".equals(method.returnType());
                CodeBlock.Builder builder = CodeBlock.builder();
                if (hasReturnType) {
                    builder.add("return ", new Object[0]);
                }
                if (methodBindings.containsKey(method)) {
                    for (MethodViewBinding binding : methodBindings.get(method)) {
                        builder.add("target.$L(", new Object[]{binding.getName()});
                        List<Parameter> parameters = binding.getParameters();
                        String[] listenerParameters = method.parameters();
                        int count2 = parameters.size();
                        for (int i = 0; i < count2; ++i) {
                            int listenerPosition;
                            Parameter parameter;
                            if (i > 0) {
                                builder.add(", ", new Object[0]);
                            }
                            if ((parameter = parameters.get(i)).requiresCast(listenerParameters[listenerPosition = parameter.getListenerPosition()])) {
                                builder.add("finder.<$T>castParam(p$L, $S, $L, $S, $L)\n", new Object[]{parameter.getType(), listenerPosition, method.name(), listenerPosition, binding.getName(), i});
                                continue;
                            }
                            builder.add("p$L", new Object[]{listenerPosition});
                        }
                        builder.add(");\n", new Object[0]);
                    }
                } else if (hasReturnType) {
                    builder.add("$L;\n", new Object[]{method.defaultReturn()});
                }
                callbackMethod.addCode(builder.build());
                callback.addMethod(callbackMethod.build());
            }
            if (!"android.view.View".equals(listener.targetType())) {
                result.addStatement("(($T) view).$L($L)", new Object[]{BindingClass.bestGuess(listener.targetType()), listener.setter(), callback.build()});
                continue;
            }
            result.addStatement("view.$L($L)", new Object[]{listener.setter(), callback.build()});
        }
        if (needsNullChecked) {
            result.endControlFlow();
        }
    }

    static List<ListenerMethod> getListenerMethods(ListenerClass listener) {
        if (listener.method().length == 1) {
            return Arrays.asList(listener.method());
        }
        try {
            ArrayList<ListenerMethod> methods = new ArrayList<ListenerMethod>();
            Class callbacks = listener.callbacks();
            for (Enum callbackMethod : (Enum[])callbacks.getEnumConstants()) {
                Field callbackField = callbacks.getField(callbackMethod.name());
                ListenerMethod method = callbackField.getAnnotation(ListenerMethod.class);
                if (method == null) {
                    throw new IllegalStateException(String.format("@%s's %s.%s missing @%s annotation.", callbacks.getEnclosingClass().getSimpleName(), callbacks.getSimpleName(), callbackMethod.name(), ListenerMethod.class.getSimpleName()));
                }
                methods.add(method);
            }
            return methods;
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    static String asHumanDescription(Collection<? extends ViewBinding> bindings) {
        Iterator<? extends ViewBinding> iterator = bindings.iterator();
        switch (bindings.size()) {
            case 1: {
                return iterator.next().getDescription();
            }
            case 2: {
                return iterator.next().getDescription() + " and " + iterator.next().getDescription();
            }
        }
        StringBuilder builder = new StringBuilder();
        int count = bindings.size();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            if (i == count - 1) {
                builder.append("and ");
            }
            builder.append(iterator.next().getDescription());
        }
        return builder.toString();
    }

    static TypeName bestGuess(String type) {
        switch (type) {
            case "void": {
                return TypeName.VOID;
            }
            case "boolean": {
                return TypeName.BOOLEAN;
            }
            case "byte": {
                return TypeName.BYTE;
            }
            case "char": {
                return TypeName.CHAR;
            }
            case "double": {
                return TypeName.DOUBLE;
            }
            case "float": {
                return TypeName.FLOAT;
            }
            case "int": {
                return TypeName.INT;
            }
            case "long": {
                return TypeName.LONG;
            }
            case "short": {
                return TypeName.SHORT;
            }
        }
        int left = type.indexOf(60);
        if (left != -1) {
            ClassName typeClassName = ClassName.bestGuess((String)type.substring(0, left));
            ArrayList<WildcardTypeName> typeArguments = new ArrayList<WildcardTypeName>();
            do {
                typeArguments.add(WildcardTypeName.subtypeOf(Object.class));
            } while ((left = type.indexOf(60, left + 1)) != -1);
            return ParameterizedTypeName.get((ClassName)typeClassName, (TypeName[])typeArguments.toArray(new TypeName[typeArguments.size()]));
        }
        return ClassName.bestGuess((String)type);
    }

    boolean hasUnbinder() {
        return this.unbinderClassName != null;
    }

    void setHighestUnbinderClassName(ClassName className) {
        this.highestUnbinderClassName = className;
    }

    ClassName getHighestUnbinderClassName() {
        return this.highestUnbinderClassName;
    }

    void setUnbinderClassName(ClassName className) {
        this.unbinderClassName = className;
    }

    ClassName getUnbinderClassName() {
        return this.unbinderClassName;
    }

    BindingClass getParentBinding() {
        return this.parentBinding;
    }

    boolean hasParentBinding() {
        return this.parentBinding != null;
    }

    private boolean hasResourceBindings() {
        return !this.bitmapBindings.isEmpty() || !this.drawableBindings.isEmpty() || !this.resourceBindings.isEmpty();
    }

    boolean hasViewBindings() {
        return !this.viewIdMap.isEmpty() || !this.collectionBindings.isEmpty();
    }

    Iterable<BindingClass> getDescendants() {
        return this.descendantBindingClasses;
    }

    private boolean hasResourceBindingsNeedingTheme() {
        if (!this.drawableBindings.isEmpty()) {
            return true;
        }
        for (FieldResourceBinding resourceBinding : this.resourceBindings) {
            if (!resourceBinding.isThemeable()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.classFqcn;
    }
}

