/*
 * Decompiled with CFR 0.152.
 */
package butterknife.compiler;

import butterknife.compiler.FieldBitmapBinding;
import butterknife.compiler.FieldCollectionViewBinding;
import butterknife.compiler.FieldDrawableBinding;
import butterknife.compiler.FieldResourceBinding;
import butterknife.compiler.FieldViewBinding;
import butterknife.compiler.Id;
import butterknife.compiler.MethodViewBinding;
import butterknife.compiler.Parameter;
import butterknife.compiler.ViewBinding;
import butterknife.compiler.ViewBindings;
import butterknife.internal.ListenerClass;
import butterknife.internal.ListenerMethod;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;

final class BindingClass {
    private static final ClassName FINDER = ClassName.get((String)"butterknife.internal", (String)"Finder", (String[])new String[0]);
    private static final ClassName VIEW_BINDER = ClassName.get((String)"butterknife.internal", (String)"ViewBinder", (String[])new String[0]);
    private static final ClassName UTILS = ClassName.get((String)"butterknife.internal", (String)"Utils", (String[])new String[0]);
    private static final ClassName VIEW = ClassName.get((String)"android.view", (String)"View", (String[])new String[0]);
    private static final ClassName CONTEXT = ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]);
    private static final ClassName RESOURCES = ClassName.get((String)"android.content.res", (String)"Resources", (String[])new String[0]);
    private static final ClassName THEME = RESOURCES.nestedClass("Theme");
    private static final ClassName UNBINDER = ClassName.get((String)"butterknife", (String)"Unbinder", (String[])new String[0]);
    private static final ClassName BITMAP_FACTORY = ClassName.get((String)"android.graphics", (String)"BitmapFactory", (String[])new String[0]);
    private static final String BIND_TO_TARGET = "bindToTarget";
    private final Map<Id, ViewBindings> viewIdMap = new LinkedHashMap<Id, ViewBindings>();
    private final Map<FieldCollectionViewBinding, List<Id>> collectionBindings = new LinkedHashMap<FieldCollectionViewBinding, List<Id>>();
    private final List<FieldBitmapBinding> bitmapBindings = new ArrayList<FieldBitmapBinding>();
    private final List<FieldDrawableBinding> drawableBindings = new ArrayList<FieldDrawableBinding>();
    private final List<FieldResourceBinding> resourceBindings = new ArrayList<FieldResourceBinding>();
    private final boolean isFinal;
    private final TypeName targetTypeName;
    private final ClassName binderClassName;
    private final ClassName unbinderClassName;
    private BindingClass parentBinding;

    BindingClass(TypeName targetTypeName, ClassName binderClassName, ClassName unbinderClassName, boolean isFinal) {
        this.isFinal = isFinal;
        this.targetTypeName = targetTypeName;
        this.binderClassName = binderClassName;
        this.unbinderClassName = unbinderClassName;
    }

    void addBitmap(FieldBitmapBinding binding) {
        this.bitmapBindings.add(binding);
    }

    void addDrawable(FieldDrawableBinding binding) {
        this.drawableBindings.add(binding);
    }

    void addField(Id id, FieldViewBinding binding) {
        this.getOrCreateViewBindings(id).setFieldBinding(binding);
    }

    void addFieldCollection(List<Id> ids, FieldCollectionViewBinding binding) {
        this.collectionBindings.put(binding, ids);
    }

    boolean addMethod(Id id, ListenerClass listener, ListenerMethod method, MethodViewBinding binding) {
        ViewBindings viewBindings = this.getOrCreateViewBindings(id);
        if (viewBindings.hasMethodBinding(listener, method) && !"void".equals(method.returnType())) {
            return false;
        }
        viewBindings.addMethodBinding(listener, method, binding);
        return true;
    }

    void addResource(FieldResourceBinding binding) {
        this.resourceBindings.add(binding);
    }

    void setParent(BindingClass parent) {
        this.parentBinding = parent;
    }

    ViewBindings getViewBinding(Id id) {
        return this.viewIdMap.get(id);
    }

    private ViewBindings getOrCreateViewBindings(Id id) {
        ViewBindings viewId = this.viewIdMap.get(id);
        if (viewId == null) {
            viewId = new ViewBindings(id);
            this.viewIdMap.put(id, viewId);
        }
        return viewId;
    }

    Collection<JavaFile> brewJava() {
        TypeSpec.Builder result = TypeSpec.classBuilder((ClassName)this.binderClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)VIEW_BINDER, (TypeName[])new TypeName[]{this.targetTypeName}));
        result.addMethod(this.createBindMethod(this.targetTypeName));
        ArrayList<JavaFile> files = new ArrayList<JavaFile>();
        if (this.isGeneratingUnbinder()) {
            files.add(JavaFile.builder((String)this.unbinderClassName.packageName(), (TypeSpec)this.createUnbinderClass()).addFileComment("Generated code from Butter Knife. Do not modify!", new Object[0]).build());
        } else if (!this.isFinal) {
            result.addMethod(this.createBindToTargetMethod());
        }
        files.add(JavaFile.builder((String)this.binderClassName.packageName(), (TypeSpec)result.build()).addFileComment("Generated code from Butter Knife. Do not modify!", new Object[0]).build());
        return files;
    }

    private TypeSpec createUnbinderClass() {
        TypeVariableName targetType;
        TypeSpec.Builder result = TypeSpec.classBuilder((String)this.unbinderClassName.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.isFinal) {
            result.addModifiers(new Modifier[]{Modifier.FINAL});
            targetType = this.targetTypeName;
        } else {
            targetType = TypeVariableName.get((String)"T");
            result.addTypeVariable(TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{this.targetTypeName}));
        }
        if (this.hasInheritedUnbinder()) {
            result.superclass((TypeName)ParameterizedTypeName.get((ClassName)this.getInheritedUnbinder(), (TypeName[])new TypeName[]{targetType}));
        } else {
            result.addSuperinterface((TypeName)UNBINDER);
            result.addField((TypeName)targetType, "target", new Modifier[]{this.isFinal ? Modifier.PRIVATE : Modifier.PROTECTED});
        }
        result.addMethod(this.createUnbinderConstructor((TypeName)targetType));
        if (this.hasViewBindings()) {
            result.addMethod(this.createUnbindInterfaceMethod(result, (TypeName)targetType));
        }
        return result.build();
    }

    private MethodSpec createUnbinderConstructor(TypeName targetType) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.hasMethodBindings()) {
            constructor.addParameter(targetType, "target", new Modifier[]{Modifier.FINAL});
        } else {
            constructor.addParameter(targetType, "target", new Modifier[0]);
        }
        if (this.bindNeedsFinder()) {
            if (this.methodBindingsNeedFinder()) {
                constructor.addParameter((TypeName)FINDER, "finder", new Modifier[]{Modifier.FINAL});
            } else {
                constructor.addParameter((TypeName)FINDER, "finder", new Modifier[0]);
            }
            constructor.addParameter(Object.class, "source", new Modifier[0]);
        }
        if (this.bindNeedsResources()) {
            constructor.addParameter((TypeName)RESOURCES, "res", new Modifier[0]);
        }
        if (this.bindNeedsTheme()) {
            constructor.addParameter((TypeName)THEME, "theme", new Modifier[0]);
        }
        if (this.hasInheritedUnbinder()) {
            CodeBlock.Builder invoke = CodeBlock.builder();
            invoke.add("super(target", new Object[0]);
            if (this.parentBinding.bindNeedsFinder()) {
                invoke.add(", finder, source", new Object[0]);
            }
            if (this.parentBinding.bindNeedsResources()) {
                invoke.add(", res", new Object[0]);
            }
            if (this.parentBinding.bindNeedsTheme()) {
                invoke.add(", theme", new Object[0]);
            }
            constructor.addStatement("$L", new Object[]{invoke.add(")", new Object[0]).build()});
        } else {
            constructor.addStatement("this.target = target", new Object[0]);
        }
        constructor.addCode("\n", new Object[0]);
        this.generateBindViewBody(constructor);
        return constructor.build();
    }

    private MethodSpec createUnbindInterfaceMethod(TypeSpec.Builder unbinderClass, TypeName targetType) {
        boolean rootUnbinderWithFields;
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"unbind").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        boolean bl = rootUnbinderWithFields = !this.hasInheritedUnbinder() && this.hasFieldBindings();
        if (this.hasFieldBindings() || rootUnbinderWithFields) {
            result.addStatement("$T target = this.target", new Object[]{targetType});
        }
        if (!this.hasInheritedUnbinder()) {
            String target = rootUnbinderWithFields ? "target" : "this.target";
            result.addStatement("if ($N == null) throw new $T($S)", new Object[]{target, IllegalStateException.class, "Bindings already cleared."});
        } else {
            result.addStatement("super.unbind()", new Object[0]);
        }
        if (this.hasFieldBindings()) {
            result.addCode("\n", new Object[0]);
            for (ViewBindings bindings : this.viewIdMap.values()) {
                if (bindings.getFieldBinding() == null) continue;
                result.addStatement("target.$L = null", new Object[]{bindings.getFieldBinding().getName()});
            }
            for (FieldCollectionViewBinding fieldCollectionBinding : this.collectionBindings.keySet()) {
                result.addStatement("target.$L = null", new Object[]{fieldCollectionBinding.getName()});
            }
        }
        if (this.hasMethodBindings()) {
            result.addCode("\n", new Object[0]);
            for (ViewBindings bindings : this.viewIdMap.values()) {
                this.addFieldAndUnbindStatement(unbinderClass, result, bindings);
            }
        }
        if (!this.hasInheritedUnbinder()) {
            result.addCode("\n", new Object[0]);
            result.addStatement("this.target = null", new Object[0]);
        }
        return result.build();
    }

    private void addFieldAndUnbindStatement(TypeSpec.Builder result, MethodSpec.Builder unbindMethod, ViewBindings bindings) {
        boolean needsNullChecked;
        Map<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> classMethodBindings = bindings.getMethodBindings();
        if (classMethodBindings.isEmpty()) {
            return;
        }
        String fieldName = "target";
        if (!bindings.isBoundToRoot()) {
            fieldName = "view" + bindings.getId().value;
            result.addField((TypeName)VIEW, fieldName, new Modifier[]{Modifier.PRIVATE});
        }
        if (needsNullChecked = bindings.getRequiredBindings().isEmpty()) {
            unbindMethod.beginControlFlow("if ($N != null)", new Object[]{fieldName});
        }
        for (ListenerClass listenerClass : classMethodBindings.keySet()) {
            boolean requiresRemoval = !"".equals(listenerClass.remover());
            String listenerField = "null";
            if (requiresRemoval) {
                TypeName listenerClassName = BindingClass.bestGuess(listenerClass.type());
                listenerField = fieldName + ((ClassName)listenerClassName).simpleName();
                result.addField(listenerClassName, listenerField, new Modifier[]{Modifier.PRIVATE});
            }
            if (!"android.view.View".equals(listenerClass.targetType())) {
                unbindMethod.addStatement("(($T) $N).$N($N)", new Object[]{BindingClass.bestGuess(listenerClass.targetType()), fieldName, this.removerOrSetter(listenerClass, requiresRemoval), listenerField});
            } else {
                unbindMethod.addStatement("$N.$N($N)", new Object[]{fieldName, this.removerOrSetter(listenerClass, requiresRemoval), listenerField});
            }
            if (!requiresRemoval) continue;
            unbindMethod.addStatement("$N = null", new Object[]{listenerField});
        }
        if (!bindings.isBoundToRoot()) {
            unbindMethod.addStatement("$N = null", new Object[]{fieldName});
        }
        if (needsNullChecked) {
            unbindMethod.endControlFlow();
        }
    }

    private String removerOrSetter(ListenerClass listenerClass, boolean requiresRemoval) {
        return requiresRemoval ? listenerClass.remover() : listenerClass.setter();
    }

    private MethodSpec createBindMethod(TypeName targetType) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"bind").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)UNBINDER).addParameter((TypeName)FINDER, "finder", new Modifier[0]);
        if (this.isFinal && this.hasMethodBindings()) {
            result.addParameter(targetType, "target", new Modifier[]{Modifier.FINAL});
        } else {
            result.addParameter(targetType, "target", new Modifier[0]);
        }
        result.addParameter(Object.class, "source", new Modifier[0]);
        boolean needsFinder = this.bindNeedsFinder();
        boolean needsResources = this.bindNeedsResources();
        boolean needsTheme = this.bindNeedsTheme();
        if (needsResources) {
            if (needsTheme) {
                result.addStatement("$T context = finder.getContext(source)", new Object[]{CONTEXT});
                result.addStatement("$T res = context.getResources()", new Object[]{RESOURCES});
                result.addStatement("$T theme = context.getTheme()", new Object[]{THEME});
            } else {
                result.addStatement("$T res = finder.getContext(source).getResources()", new Object[]{RESOURCES});
            }
        }
        if (this.isFinal && !this.isGeneratingUnbinder()) {
            if (needsResources) {
                result.addCode("\n", new Object[0]);
            }
            this.generateBindViewBody(result);
            result.addCode("\n", new Object[0]);
        }
        CodeBlock.Builder invoke = CodeBlock.builder();
        if (this.isGeneratingUnbinder()) {
            if (this.isFinal) {
                invoke.add("return new $T", new Object[]{this.unbinderClassName});
            } else {
                invoke.add("return new $T<>", new Object[]{this.unbinderClassName});
            }
        } else if (!this.isFinal) {
            invoke.add("$N", new Object[]{BIND_TO_TARGET});
        }
        if (this.isGeneratingUnbinder() || !this.isFinal) {
            invoke.add("(target", new Object[0]);
            if (needsFinder) {
                invoke.add(", finder, source", new Object[0]);
            }
            if (needsResources) {
                invoke.add(", res", new Object[0]);
            }
            if (needsTheme) {
                invoke.add(", theme", new Object[0]);
            }
            result.addStatement("$L", new Object[]{invoke.add(")", new Object[0]).build()});
        }
        if (!this.isGeneratingUnbinder()) {
            result.addStatement("return $T.EMPTY", new Object[]{UNBINDER});
        }
        return result.build();
    }

    private MethodSpec createBindToTargetMethod() {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)BIND_TO_TARGET).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        if (this.hasMethodBindings()) {
            result.addParameter(this.targetTypeName, "target", new Modifier[]{Modifier.FINAL});
        } else {
            result.addParameter(this.targetTypeName, "target", new Modifier[0]);
        }
        if (this.bindNeedsResources()) {
            result.addParameter((TypeName)RESOURCES, "res", new Modifier[0]);
        }
        if (this.bindNeedsTheme()) {
            result.addParameter((TypeName)THEME, "theme", new Modifier[0]);
        }
        this.generateBindViewBody(result);
        return result.build();
    }

    private void generateBindViewBody(MethodSpec.Builder result) {
        if (this.hasUnqualifiedResourceBindings()) {
            result.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"ResourceType"}).build());
        }
        if (!this.hasInheritedUnbinder() && this.hasParentBinding()) {
            CodeBlock.Builder invoke = CodeBlock.builder().add("$T.$N(target", new Object[]{this.parentBinding.binderClassName, BIND_TO_TARGET});
            if (this.parentBinding.bindNeedsFinder()) {
                invoke.add(", finder, source", new Object[0]);
            }
            if (this.parentBinding.bindNeedsResources()) {
                invoke.add(", res", new Object[0]);
            }
            if (this.parentBinding.bindNeedsTheme()) {
                invoke.add(", theme", new Object[0]);
            }
            result.addStatement("$L", new Object[]{invoke.add(")", new Object[0]).build()});
            result.addCode("\n", new Object[0]);
        }
        if (this.hasViewBindings()) {
            if (this.bindNeedsViewLocal()) {
                result.addStatement("$T view", new Object[]{VIEW});
            }
            for (ViewBindings viewBindings : this.viewIdMap.values()) {
                this.addViewBindings(result, viewBindings);
            }
            for (Map.Entry entry : this.collectionBindings.entrySet()) {
                this.emitCollectionBinding(result, (FieldCollectionViewBinding)entry.getKey(), (List)entry.getValue());
            }
            if (this.hasResourceBindings()) {
                result.addCode("\n", new Object[0]);
            }
        }
        if (this.hasResourceBindings()) {
            for (FieldBitmapBinding fieldBitmapBinding : this.bitmapBindings) {
                result.addStatement("target.$L = $T.decodeResource(res, $L)", new Object[]{fieldBitmapBinding.getName(), BITMAP_FACTORY, fieldBitmapBinding.getId().code});
            }
            for (FieldDrawableBinding fieldDrawableBinding : this.drawableBindings) {
                Id tintAttributeId = fieldDrawableBinding.getTintAttributeId();
                if (tintAttributeId.value != 0) {
                    result.addStatement("target.$L = $T.getTintedDrawable(res, theme, $L, $L)", new Object[]{fieldDrawableBinding.getName(), UTILS, fieldDrawableBinding.getId().code, tintAttributeId.code});
                    continue;
                }
                result.addStatement("target.$L = $T.getDrawable(res, theme, $L)", new Object[]{fieldDrawableBinding.getName(), UTILS, fieldDrawableBinding.getId().code});
            }
            for (FieldResourceBinding fieldResourceBinding : this.resourceBindings) {
                if (fieldResourceBinding.isThemeable()) {
                    result.addStatement("target.$L = $T.$L(res, theme, $L)", new Object[]{fieldResourceBinding.getName(), UTILS, fieldResourceBinding.getMethod(), fieldResourceBinding.getId().code});
                    continue;
                }
                result.addStatement("target.$L = res.$L($L)", new Object[]{fieldResourceBinding.getName(), fieldResourceBinding.getMethod(), fieldResourceBinding.getId().code});
            }
        }
    }

    private void emitCollectionBinding(MethodSpec.Builder result, FieldCollectionViewBinding binding, List<Id> ids) {
        String ofName;
        switch (binding.getKind()) {
            case ARRAY: {
                ofName = "arrayOf";
                break;
            }
            case LIST: {
                ofName = "listOf";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown kind: " + (Object)((Object)binding.getKind()));
            }
        }
        CodeBlock.Builder builder = CodeBlock.builder();
        for (int i = 0; i < ids.size(); ++i) {
            if (i > 0) {
                builder.add(", ", new Object[0]);
            }
            builder.add("\nfinder.find", new Object[0]);
            builder.add(binding.isRequired() ? "RequiredView" : "OptionalView", new Object[0]);
            if (BindingClass.requiresCast(binding.getType())) {
                builder.add("AsType", new Object[0]);
            }
            builder.add("(source, $L", new Object[]{ids.get((int)i).code});
            if (binding.isRequired() || BindingClass.requiresCast(binding.getType())) {
                builder.add(", $S", new Object[]{BindingClass.asHumanDescription(Collections.singletonList(binding))});
            }
            if (BindingClass.requiresCast(binding.getType())) {
                builder.add(", $T.class", new Object[]{binding.getRawType()});
            }
            builder.add(")", new Object[0]);
        }
        result.addStatement("target.$L = $T.$L($L)", new Object[]{binding.getName(), UTILS, ofName, builder.build()});
    }

    private void addViewBindings(MethodSpec.Builder result, ViewBindings bindings) {
        if (bindings.isSingleFieldBinding()) {
            FieldViewBinding fieldBinding = bindings.getFieldBinding();
            CodeBlock.Builder invoke = CodeBlock.builder().add("target.$L = finder.find", new Object[]{fieldBinding.getName()});
            invoke.add(fieldBinding.isRequired() ? "RequiredView" : "OptionalView", new Object[0]);
            if (BindingClass.requiresCast(fieldBinding.getType())) {
                invoke.add("AsType", new Object[0]);
            }
            invoke.add("(source, $L", new Object[]{bindings.getId().code});
            if (fieldBinding.isRequired() || BindingClass.requiresCast(fieldBinding.getType())) {
                invoke.add(", $S", new Object[]{BindingClass.asHumanDescription(Collections.singletonList(fieldBinding))});
            }
            if (BindingClass.requiresCast(fieldBinding.getType())) {
                invoke.add(", $T.class", new Object[]{fieldBinding.getRawType()});
            }
            result.addStatement("$L)", new Object[]{invoke.build()});
            return;
        }
        List<ViewBinding> requiredViewBindings = bindings.getRequiredBindings();
        if (requiredViewBindings.isEmpty()) {
            result.addStatement("view = finder.findOptionalView(source, $L)", new Object[]{bindings.getId().code});
        } else if (!bindings.isBoundToRoot()) {
            result.addStatement("view = finder.findRequiredView(source, $L, $S)", new Object[]{bindings.getId().code, BindingClass.asHumanDescription(requiredViewBindings)});
        }
        this.addFieldBindings(result, bindings);
        this.addMethodBindings(result, bindings);
    }

    private void addFieldBindings(MethodSpec.Builder result, ViewBindings bindings) {
        FieldViewBinding fieldBinding = bindings.getFieldBinding();
        if (fieldBinding != null) {
            if (BindingClass.requiresCast(fieldBinding.getType())) {
                result.addStatement("target.$L = finder.castView(view, $L, $S, $T.class)", new Object[]{fieldBinding.getName(), bindings.getId().code, BindingClass.asHumanDescription(Collections.singletonList(fieldBinding)), fieldBinding.getRawType()});
            } else {
                result.addStatement("target.$L = view", new Object[]{fieldBinding.getName()});
            }
        }
    }

    private void addMethodBindings(MethodSpec.Builder result, ViewBindings bindings) {
        Map<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> classMethodBindings = bindings.getMethodBindings();
        if (classMethodBindings.isEmpty()) {
            return;
        }
        boolean needsNullChecked = bindings.getRequiredBindings().isEmpty();
        if (needsNullChecked) {
            result.beginControlFlow("if (view != null)", new Object[0]);
        }
        String fieldName = "target";
        String bindName = "target";
        if (!bindings.isBoundToRoot()) {
            fieldName = "view" + bindings.getId().value;
            bindName = "view";
            if (this.isGeneratingUnbinder()) {
                result.addStatement("$L = view", new Object[]{fieldName});
            }
        }
        for (Map.Entry<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> e : classMethodBindings.entrySet()) {
            ListenerClass listener = e.getKey();
            Map<ListenerMethod, Set<MethodViewBinding>> methodBindings = e.getValue();
            TypeSpec.Builder callback = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)ClassName.bestGuess((String)listener.type()));
            for (ListenerMethod method : BindingClass.getListenerMethods(listener)) {
                MethodSpec.Builder callbackMethod = MethodSpec.methodBuilder((String)method.name()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(BindingClass.bestGuess(method.returnType()));
                String[] parameterTypes = method.parameters();
                int count = parameterTypes.length;
                for (int i = 0; i < count; ++i) {
                    callbackMethod.addParameter(BindingClass.bestGuess(parameterTypes[i]), "p" + i, new Modifier[0]);
                }
                boolean hasReturnType = !"void".equals(method.returnType());
                CodeBlock.Builder builder = CodeBlock.builder();
                if (hasReturnType) {
                    builder.add("return ", new Object[0]);
                }
                if (methodBindings.containsKey(method)) {
                    for (MethodViewBinding binding : methodBindings.get(method)) {
                        builder.add("target.$L(", new Object[]{binding.getName()});
                        List<Parameter> parameters = binding.getParameters();
                        String[] listenerParameters = method.parameters();
                        int count2 = parameters.size();
                        for (int i = 0; i < count2; ++i) {
                            int listenerPosition;
                            Parameter parameter;
                            if (i > 0) {
                                builder.add(", ", new Object[0]);
                            }
                            if ((parameter = parameters.get(i)).requiresCast(listenerParameters[listenerPosition = parameter.getListenerPosition()])) {
                                builder.add("finder.<$T>castParam(p$L, $S, $L, $S, $L)", new Object[]{parameter.getType(), listenerPosition, method.name(), listenerPosition, binding.getName(), i});
                                continue;
                            }
                            builder.add("p$L", new Object[]{listenerPosition});
                        }
                        builder.add(");\n", new Object[0]);
                    }
                } else if (hasReturnType) {
                    builder.add("$L;\n", new Object[]{method.defaultReturn()});
                }
                callbackMethod.addCode(builder.build());
                callback.addMethod(callbackMethod.build());
            }
            boolean requiresRemoval = this.isGeneratingUnbinder() && listener.remover().length() != 0;
            String listenerField = null;
            if (requiresRemoval) {
                TypeName listenerClassName = BindingClass.bestGuess(listener.type());
                listenerField = fieldName + ((ClassName)listenerClassName).simpleName();
                result.addStatement("$L = $L", new Object[]{listenerField, callback.build()});
            }
            if (!"android.view.View".equals(listener.targetType())) {
                result.addStatement("(($T) $N).$L($L)", new Object[]{BindingClass.bestGuess(listener.targetType()), bindName, listener.setter(), requiresRemoval ? listenerField : callback.build()});
                continue;
            }
            result.addStatement("$N.$L($L)", new Object[]{bindName, listener.setter(), requiresRemoval ? listenerField : callback.build()});
        }
        if (needsNullChecked) {
            result.endControlFlow();
        }
    }

    static List<ListenerMethod> getListenerMethods(ListenerClass listener) {
        if (listener.method().length == 1) {
            return Arrays.asList(listener.method());
        }
        try {
            ArrayList<ListenerMethod> methods = new ArrayList<ListenerMethod>();
            Class callbacks = listener.callbacks();
            for (Enum callbackMethod : (Enum[])callbacks.getEnumConstants()) {
                Field callbackField = callbacks.getField(callbackMethod.name());
                ListenerMethod method = callbackField.getAnnotation(ListenerMethod.class);
                if (method == null) {
                    throw new IllegalStateException(String.format("@%s's %s.%s missing @%s annotation.", callbacks.getEnclosingClass().getSimpleName(), callbacks.getSimpleName(), callbackMethod.name(), ListenerMethod.class.getSimpleName()));
                }
                methods.add(method);
            }
            return methods;
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    static String asHumanDescription(Collection<? extends ViewBinding> bindings) {
        Iterator<? extends ViewBinding> iterator = bindings.iterator();
        switch (bindings.size()) {
            case 1: {
                return iterator.next().getDescription();
            }
            case 2: {
                return iterator.next().getDescription() + " and " + iterator.next().getDescription();
            }
        }
        StringBuilder builder = new StringBuilder();
        int count = bindings.size();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            if (i == count - 1) {
                builder.append("and ");
            }
            builder.append(iterator.next().getDescription());
        }
        return builder.toString();
    }

    static TypeName bestGuess(String type) {
        switch (type) {
            case "void": {
                return TypeName.VOID;
            }
            case "boolean": {
                return TypeName.BOOLEAN;
            }
            case "byte": {
                return TypeName.BYTE;
            }
            case "char": {
                return TypeName.CHAR;
            }
            case "double": {
                return TypeName.DOUBLE;
            }
            case "float": {
                return TypeName.FLOAT;
            }
            case "int": {
                return TypeName.INT;
            }
            case "long": {
                return TypeName.LONG;
            }
            case "short": {
                return TypeName.SHORT;
            }
        }
        int left = type.indexOf(60);
        if (left != -1) {
            ClassName typeClassName = ClassName.bestGuess((String)type.substring(0, left));
            ArrayList<WildcardTypeName> typeArguments = new ArrayList<WildcardTypeName>();
            do {
                typeArguments.add(WildcardTypeName.subtypeOf(Object.class));
            } while ((left = type.indexOf(60, left + 1)) != -1);
            return ParameterizedTypeName.get((ClassName)typeClassName, (TypeName[])typeArguments.toArray(new TypeName[typeArguments.size()]));
        }
        return ClassName.bestGuess((String)type);
    }

    private boolean hasParentBinding() {
        return this.parentBinding != null;
    }

    private boolean isGeneratingUnbinder() {
        return this.hasViewBindings() || this.hasInheritedUnbinder();
    }

    private boolean hasInheritedUnbinder() {
        return this.hasParentBinding() && this.parentBinding.isGeneratingUnbinder();
    }

    private ClassName getInheritedUnbinder() {
        return this.parentBinding.unbinderClassName;
    }

    private boolean hasViewBindings() {
        return !this.viewIdMap.isEmpty() || !this.collectionBindings.isEmpty();
    }

    private boolean hasResourceBindings() {
        return !this.bitmapBindings.isEmpty() || !this.drawableBindings.isEmpty() || !this.resourceBindings.isEmpty();
    }

    private boolean hasUnqualifiedResourceBindings() {
        for (FieldBitmapBinding fieldBitmapBinding : this.bitmapBindings) {
            if (fieldBitmapBinding.getId().qualifed) continue;
            return true;
        }
        for (FieldDrawableBinding fieldDrawableBinding : this.drawableBindings) {
            if (fieldDrawableBinding.getId().qualifed) continue;
            return true;
        }
        for (FieldResourceBinding fieldResourceBinding : this.resourceBindings) {
            if (fieldResourceBinding.getId().qualifed) continue;
            return true;
        }
        return false;
    }

    private boolean hasResourceBindingsNeedingTheme() {
        if (!this.drawableBindings.isEmpty()) {
            return true;
        }
        for (FieldResourceBinding resourceBinding : this.resourceBindings) {
            if (!resourceBinding.isThemeable()) continue;
            return true;
        }
        return false;
    }

    private boolean hasMethodBindings() {
        for (ViewBindings viewBindings : this.viewIdMap.values()) {
            if (viewBindings.getMethodBindings().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean methodBindingsNeedFinder() {
        for (ViewBindings viewBindings : this.viewIdMap.values()) {
            for (Map.Entry<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> entry : viewBindings.getMethodBindings().entrySet()) {
                Map<ListenerMethod, Set<MethodViewBinding>> methodBindings = entry.getValue();
                for (ListenerMethod method : BindingClass.getListenerMethods(entry.getKey())) {
                    if (!methodBindings.containsKey(method)) continue;
                    String[] parameterTypes = method.parameters();
                    for (MethodViewBinding methodViewBinding : methodBindings.get(method)) {
                        for (Parameter parameter : methodViewBinding.getParameters()) {
                            if (!parameter.requiresCast(parameterTypes[parameter.getListenerPosition()])) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean hasFieldBindings() {
        for (ViewBindings viewBindings : this.viewIdMap.values()) {
            if (viewBindings.getFieldBinding() == null) continue;
            return true;
        }
        return !this.collectionBindings.isEmpty();
    }

    private boolean bindNeedsFinder() {
        return this.hasViewBindings() || this.hasParentBinding() && this.parentBinding.bindNeedsFinder();
    }

    private boolean bindNeedsResources() {
        return this.hasResourceBindings() || this.hasParentBinding() && this.parentBinding.bindNeedsResources();
    }

    private boolean bindNeedsTheme() {
        return this.hasResourceBindings() && this.hasResourceBindingsNeedingTheme() || this.hasParentBinding() && this.parentBinding.bindNeedsTheme();
    }

    private boolean bindNeedsViewLocal() {
        for (ViewBindings viewBindings : this.viewIdMap.values()) {
            if (!viewBindings.requiresLocal()) continue;
            return true;
        }
        return false;
    }

    private static boolean requiresCast(TypeName type) {
        return !"android.view.View".equals(type.toString());
    }

    public String toString() {
        return this.binderClassName.toString();
    }
}

