/*
 * Decompiled with CFR 0.152.
 */
package butterknife.compiler;

import butterknife.compiler.ButterKnifeProcessor;
import butterknife.compiler.FieldViewBinding;
import butterknife.compiler.Id;
import butterknife.compiler.MethodViewBinding;
import butterknife.compiler.ViewBinding;
import butterknife.internal.ListenerClass;
import butterknife.internal.ListenerMethod;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ViewBindings {
    private final Id id;
    private final LinkedHashMap<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> methodBindings = new LinkedHashMap();
    private FieldViewBinding fieldBinding;

    ViewBindings(Id id) {
        this.id = id;
    }

    public Id getId() {
        return this.id;
    }

    public FieldViewBinding getFieldBinding() {
        return this.fieldBinding;
    }

    public Map<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> getMethodBindings() {
        return this.methodBindings;
    }

    public boolean hasMethodBinding(ListenerClass listener, ListenerMethod method) {
        Map<ListenerMethod, Set<MethodViewBinding>> methods = this.methodBindings.get(listener);
        return methods != null && methods.containsKey(method);
    }

    public void addMethodBinding(ListenerClass listener, ListenerMethod method, MethodViewBinding binding) {
        Map<ListenerMethod, Set<MethodViewBinding>> methods = this.methodBindings.get(listener);
        Set<MethodViewBinding> set = null;
        if (methods == null) {
            methods = new LinkedHashMap<ListenerMethod, Set<MethodViewBinding>>();
            this.methodBindings.put(listener, methods);
        } else {
            set = methods.get(method);
        }
        if (set == null) {
            set = new LinkedHashSet<MethodViewBinding>();
            methods.put(method, set);
        }
        set.add(binding);
    }

    public void setFieldBinding(FieldViewBinding fieldBinding) {
        if (this.fieldBinding != null) {
            throw new AssertionError();
        }
        this.fieldBinding = fieldBinding;
    }

    public List<ViewBinding> getRequiredBindings() {
        ArrayList<ViewBinding> requiredViewBindings = new ArrayList<ViewBinding>();
        if (this.fieldBinding != null && this.fieldBinding.isRequired()) {
            requiredViewBindings.add(this.fieldBinding);
        }
        for (Map<ListenerMethod, Set<MethodViewBinding>> methodBinding : this.methodBindings.values()) {
            for (Set<MethodViewBinding> set : methodBinding.values()) {
                for (MethodViewBinding binding : set) {
                    if (!binding.isRequired()) continue;
                    requiredViewBindings.add(binding);
                }
            }
        }
        return requiredViewBindings;
    }

    public boolean isSingleFieldBinding() {
        return this.methodBindings.isEmpty() && this.fieldBinding != null;
    }

    public boolean requiresLocal() {
        if (this.isBoundToRoot()) {
            return false;
        }
        return !this.isSingleFieldBinding();
    }

    public boolean isBoundToRoot() {
        return ButterKnifeProcessor.NO_ID.equals(this.id);
    }
}

