/*
 * Decompiled with CFR 0.152.
 */
package butterknife.compiler;

import butterknife.OnTouch;
import butterknife.compiler.ButterKnifeProcessor;
import butterknife.compiler.FieldCollectionViewBinding;
import butterknife.compiler.FieldViewBinding;
import butterknife.compiler.Id;
import butterknife.compiler.MemberViewBinding;
import butterknife.compiler.MethodViewBinding;
import butterknife.compiler.Parameter;
import butterknife.compiler.ResourceBinding;
import butterknife.compiler.ViewBinding;
import butterknife.internal.ListenerClass;
import butterknife.internal.ListenerMethod;
import com.google.auto.common.MoreElements;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class BindingSet {
    static final ClassName UTILS = ClassName.get((String)"butterknife.internal", (String)"Utils", (String[])new String[0]);
    private static final ClassName VIEW = ClassName.get((String)"android.view", (String)"View", (String[])new String[0]);
    private static final ClassName CONTEXT = ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]);
    private static final ClassName RESOURCES = ClassName.get((String)"android.content.res", (String)"Resources", (String[])new String[0]);
    private static final ClassName UI_THREAD = ClassName.get((String)"android.support.annotation", (String)"UiThread", (String[])new String[0]);
    private static final ClassName CALL_SUPER = ClassName.get((String)"android.support.annotation", (String)"CallSuper", (String[])new String[0]);
    private static final ClassName SUPPRESS_LINT = ClassName.get((String)"android.annotation", (String)"SuppressLint", (String[])new String[0]);
    private static final ClassName UNBINDER = ClassName.get((String)"butterknife", (String)"Unbinder", (String[])new String[0]);
    static final ClassName BITMAP_FACTORY = ClassName.get((String)"android.graphics", (String)"BitmapFactory", (String[])new String[0]);
    static final ClassName CONTEXT_COMPAT = ClassName.get((String)"android.support.v4.content", (String)"ContextCompat", (String[])new String[0]);
    static final ClassName ANIMATION_UTILS = ClassName.get((String)"android.view.animation", (String)"AnimationUtils", (String[])new String[0]);
    private final TypeName targetTypeName;
    private final ClassName bindingClassName;
    private final boolean isFinal;
    private final boolean isView;
    private final boolean isActivity;
    private final boolean isDialog;
    private final ImmutableList<ViewBinding> viewBindings;
    private final ImmutableList<FieldCollectionViewBinding> collectionBindings;
    private final ImmutableList<ResourceBinding> resourceBindings;
    private final BindingSet parentBinding;

    private BindingSet(TypeName targetTypeName, ClassName bindingClassName, boolean isFinal, boolean isView, boolean isActivity, boolean isDialog, ImmutableList<ViewBinding> viewBindings, ImmutableList<FieldCollectionViewBinding> collectionBindings, ImmutableList<ResourceBinding> resourceBindings, BindingSet parentBinding) {
        this.isFinal = isFinal;
        this.targetTypeName = targetTypeName;
        this.bindingClassName = bindingClassName;
        this.isView = isView;
        this.isActivity = isActivity;
        this.isDialog = isDialog;
        this.viewBindings = viewBindings;
        this.collectionBindings = collectionBindings;
        this.resourceBindings = resourceBindings;
        this.parentBinding = parentBinding;
    }

    JavaFile brewJava(int sdk, boolean debuggable) {
        return JavaFile.builder((String)this.bindingClassName.packageName(), (TypeSpec)this.createType(sdk, debuggable)).addFileComment("Generated code from Butter Knife. Do not modify!", new Object[0]).build();
    }

    private TypeSpec createType(int sdk, boolean debuggable) {
        TypeSpec.Builder result = TypeSpec.classBuilder((String)this.bindingClassName.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.isFinal) {
            result.addModifiers(new Modifier[]{Modifier.FINAL});
        }
        if (this.parentBinding != null) {
            result.superclass((TypeName)this.parentBinding.bindingClassName);
        } else {
            result.addSuperinterface((TypeName)UNBINDER);
        }
        if (this.hasTargetField()) {
            result.addField(this.targetTypeName, "target", new Modifier[]{Modifier.PRIVATE});
        }
        if (this.isView) {
            result.addMethod(this.createBindingConstructorForView());
        } else if (this.isActivity) {
            result.addMethod(this.createBindingConstructorForActivity());
        } else if (this.isDialog) {
            result.addMethod(this.createBindingConstructorForDialog());
        }
        if (!this.constructorNeedsView()) {
            result.addMethod(this.createBindingViewDelegateConstructor());
        }
        result.addMethod(this.createBindingConstructor(sdk, debuggable));
        if (this.hasViewBindings() || this.parentBinding == null) {
            result.addMethod(this.createBindingUnbindMethod(result));
        }
        return result.build();
    }

    private MethodSpec createBindingViewDelegateConstructor() {
        return MethodSpec.constructorBuilder().addJavadoc("@deprecated Use {@link #$T($T, $T)} for direct creation.\n    Only present for runtime invocation through {@code ButterKnife.bind()}.\n", new Object[]{this.bindingClassName, this.targetTypeName, CONTEXT}).addAnnotation(Deprecated.class).addAnnotation(UI_THREAD).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.targetTypeName, "target", new Modifier[0]).addParameter((TypeName)VIEW, "source", new Modifier[0]).addStatement("this(target, source.getContext())", new Object[0]).build();
    }

    private MethodSpec createBindingConstructorForView() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addAnnotation(UI_THREAD).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.targetTypeName, "target", new Modifier[0]);
        if (this.constructorNeedsView()) {
            builder.addStatement("this(target, target)", new Object[0]);
        } else {
            builder.addStatement("this(target, target.getContext())", new Object[0]);
        }
        return builder.build();
    }

    private MethodSpec createBindingConstructorForActivity() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addAnnotation(UI_THREAD).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.targetTypeName, "target", new Modifier[0]);
        if (this.constructorNeedsView()) {
            builder.addStatement("this(target, target.getWindow().getDecorView())", new Object[0]);
        } else {
            builder.addStatement("this(target, target)", new Object[0]);
        }
        return builder.build();
    }

    private MethodSpec createBindingConstructorForDialog() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addAnnotation(UI_THREAD).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.targetTypeName, "target", new Modifier[0]);
        if (this.constructorNeedsView()) {
            builder.addStatement("this(target, target.getWindow().getDecorView())", new Object[0]);
        } else {
            builder.addStatement("this(target, target.getContext())", new Object[0]);
        }
        return builder.build();
    }

    private MethodSpec createBindingConstructor(int sdk, boolean debuggable) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addAnnotation(UI_THREAD).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.hasMethodBindings()) {
            constructor.addParameter(this.targetTypeName, "target", new Modifier[]{Modifier.FINAL});
        } else {
            constructor.addParameter(this.targetTypeName, "target", new Modifier[0]);
        }
        if (this.constructorNeedsView()) {
            constructor.addParameter((TypeName)VIEW, "source", new Modifier[0]);
        } else {
            constructor.addParameter((TypeName)CONTEXT, "context", new Modifier[0]);
        }
        if (this.hasUnqualifiedResourceBindings()) {
            constructor.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"ResourceType"}).build());
        }
        if (this.hasOnTouchMethodBindings()) {
            constructor.addAnnotation(AnnotationSpec.builder((ClassName)SUPPRESS_LINT).addMember("value", "$S", new Object[]{"ClickableViewAccessibility"}).build());
        }
        if (this.parentBinding != null) {
            if (this.parentBinding.constructorNeedsView()) {
                constructor.addStatement("super(target, source)", new Object[0]);
            } else if (this.constructorNeedsView()) {
                constructor.addStatement("super(target, source.getContext())", new Object[0]);
            } else {
                constructor.addStatement("super(target, context)", new Object[0]);
            }
            constructor.addCode("\n", new Object[0]);
        }
        if (this.hasTargetField()) {
            constructor.addStatement("this.target = target", new Object[0]);
            constructor.addCode("\n", new Object[0]);
        }
        if (this.hasViewBindings()) {
            if (this.hasViewLocal()) {
                constructor.addStatement("$T view", new Object[]{VIEW});
            }
            for (Object binding : this.viewBindings) {
                this.addViewBinding(constructor, (ViewBinding)binding, debuggable);
            }
            for (Object binding : this.collectionBindings) {
                constructor.addStatement("$L", new Object[]{((FieldCollectionViewBinding)binding).render(debuggable)});
            }
            if (!this.resourceBindings.isEmpty()) {
                constructor.addCode("\n", new Object[0]);
            }
        }
        if (!this.resourceBindings.isEmpty()) {
            if (this.constructorNeedsView()) {
                constructor.addStatement("$T context = source.getContext()", new Object[]{CONTEXT});
            }
            if (this.hasResourceBindingsNeedingResource(sdk)) {
                constructor.addStatement("$T res = context.getResources()", new Object[]{RESOURCES});
            }
            for (Object binding : this.resourceBindings) {
                constructor.addStatement("$L", new Object[]{binding.render(sdk)});
            }
        }
        return constructor.build();
    }

    private MethodSpec createBindingUnbindMethod(TypeSpec.Builder bindingClass) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"unbind").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (!this.isFinal && this.parentBinding == null) {
            result.addAnnotation(CALL_SUPER);
        }
        if (this.hasTargetField()) {
            if (this.hasFieldBindings()) {
                result.addStatement("$T target = this.target", new Object[]{this.targetTypeName});
            }
            result.addStatement("if (target == null) throw new $T($S)", new Object[]{IllegalStateException.class, "Bindings already cleared."});
            result.addStatement("$N = null", new Object[]{this.hasFieldBindings() ? "this.target" : "target"});
            result.addCode("\n", new Object[0]);
            for (Object binding : this.viewBindings) {
                if (((ViewBinding)binding).getFieldBinding() == null) continue;
                result.addStatement("target.$L = null", new Object[]{((ViewBinding)binding).getFieldBinding().getName()});
            }
            for (Object binding : this.collectionBindings) {
                result.addStatement("target.$L = null", new Object[]{((FieldCollectionViewBinding)binding).name});
            }
        }
        if (this.hasMethodBindings()) {
            result.addCode("\n", new Object[0]);
            for (Object binding : this.viewBindings) {
                this.addFieldAndUnbindStatement(bindingClass, result, (ViewBinding)binding);
            }
        }
        if (this.parentBinding != null) {
            result.addCode("\n", new Object[0]);
            result.addStatement("super.unbind()", new Object[0]);
        }
        return result.build();
    }

    private void addFieldAndUnbindStatement(TypeSpec.Builder result, MethodSpec.Builder unbindMethod, ViewBinding bindings) {
        Map<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> classMethodBindings = bindings.getMethodBindings();
        if (classMethodBindings.isEmpty()) {
            return;
        }
        String fieldName = bindings.isBoundToRoot() ? "viewSource" : "view" + bindings.getId().value;
        result.addField((TypeName)VIEW, fieldName, new Modifier[]{Modifier.PRIVATE});
        boolean needsNullChecked = bindings.getRequiredBindings().isEmpty();
        if (needsNullChecked) {
            unbindMethod.beginControlFlow("if ($N != null)", new Object[]{fieldName});
        }
        for (ListenerClass listenerClass : classMethodBindings.keySet()) {
            boolean requiresRemoval = !"".equals(listenerClass.remover());
            String listenerField = "null";
            if (requiresRemoval) {
                TypeName listenerClassName = BindingSet.bestGuess(listenerClass.type());
                listenerField = fieldName + ((ClassName)listenerClassName).simpleName();
                result.addField(listenerClassName, listenerField, new Modifier[]{Modifier.PRIVATE});
            }
            if (!"android.view.View".equals(listenerClass.targetType())) {
                unbindMethod.addStatement("(($T) $N).$N($N)", new Object[]{BindingSet.bestGuess(listenerClass.targetType()), fieldName, this.removerOrSetter(listenerClass, requiresRemoval), listenerField});
            } else {
                unbindMethod.addStatement("$N.$N($N)", new Object[]{fieldName, this.removerOrSetter(listenerClass, requiresRemoval), listenerField});
            }
            if (!requiresRemoval) continue;
            unbindMethod.addStatement("$N = null", new Object[]{listenerField});
        }
        unbindMethod.addStatement("$N = null", new Object[]{fieldName});
        if (needsNullChecked) {
            unbindMethod.endControlFlow();
        }
    }

    private String removerOrSetter(ListenerClass listenerClass, boolean requiresRemoval) {
        return requiresRemoval ? listenerClass.remover() : listenerClass.setter();
    }

    private void addViewBinding(MethodSpec.Builder result, ViewBinding binding, boolean debuggable) {
        if (binding.isSingleFieldBinding()) {
            FieldViewBinding fieldBinding = binding.getFieldBinding();
            CodeBlock.Builder builder = CodeBlock.builder().add("target.$L = ", new Object[]{fieldBinding.getName()});
            boolean requiresCast = BindingSet.requiresCast(fieldBinding.getType());
            if (!debuggable || !requiresCast && !fieldBinding.isRequired()) {
                builder.add("source.findViewById($L)", new Object[]{binding.getId().code});
            } else {
                builder.add("$T.find", new Object[]{UTILS});
                builder.add(fieldBinding.isRequired() ? "RequiredView" : "OptionalView", new Object[0]);
                if (requiresCast) {
                    builder.add("AsType", new Object[0]);
                }
                builder.add("(source, $L", new Object[]{binding.getId().code});
                if (fieldBinding.isRequired() || requiresCast) {
                    builder.add(", $S", new Object[]{BindingSet.asHumanDescription(Collections.singletonList(fieldBinding))});
                }
                if (requiresCast) {
                    builder.add(", $T.class", new Object[]{fieldBinding.getRawType()});
                }
                builder.add(")", new Object[0]);
            }
            result.addStatement("$L", new Object[]{builder.build()});
            return;
        }
        List<MemberViewBinding> requiredBindings = binding.getRequiredBindings();
        if (!debuggable || requiredBindings.isEmpty()) {
            result.addStatement("view = source.findViewById($L)", new Object[]{binding.getId().code});
        } else if (!binding.isBoundToRoot()) {
            result.addStatement("view = $T.findRequiredView(source, $L, $S)", new Object[]{UTILS, binding.getId().code, BindingSet.asHumanDescription(requiredBindings)});
        }
        this.addFieldBinding(result, binding, debuggable);
        this.addMethodBindings(result, binding, debuggable);
    }

    private void addFieldBinding(MethodSpec.Builder result, ViewBinding binding, boolean debuggable) {
        FieldViewBinding fieldBinding = binding.getFieldBinding();
        if (fieldBinding != null) {
            if (BindingSet.requiresCast(fieldBinding.getType())) {
                if (debuggable) {
                    result.addStatement("target.$L = $T.castView(view, $L, $S, $T.class)", new Object[]{fieldBinding.getName(), UTILS, binding.getId().code, BindingSet.asHumanDescription(Collections.singletonList(fieldBinding)), fieldBinding.getRawType()});
                } else {
                    result.addStatement("target.$L = ($T) view", new Object[]{fieldBinding.getName(), fieldBinding.getType()});
                }
            } else {
                result.addStatement("target.$L = view", new Object[]{fieldBinding.getName()});
            }
        }
    }

    private void addMethodBindings(MethodSpec.Builder result, ViewBinding binding, boolean debuggable) {
        Map<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> classMethodBindings = binding.getMethodBindings();
        if (classMethodBindings.isEmpty()) {
            return;
        }
        boolean needsNullChecked = binding.getRequiredBindings().isEmpty();
        if (needsNullChecked) {
            result.beginControlFlow("if (view != null)", new Object[0]);
        }
        String fieldName = "viewSource";
        String bindName = "source";
        if (!binding.isBoundToRoot()) {
            fieldName = "view" + binding.getId().value;
            bindName = "view";
        }
        result.addStatement("$L = $N", new Object[]{fieldName, bindName});
        for (Map.Entry<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> e : classMethodBindings.entrySet()) {
            ListenerClass listener = e.getKey();
            Map<ListenerMethod, Set<MethodViewBinding>> methodBindings = e.getValue();
            TypeSpec.Builder callback = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)ClassName.bestGuess((String)listener.type()));
            for (ListenerMethod method : BindingSet.getListenerMethods(listener)) {
                MethodSpec.Builder callbackMethod = MethodSpec.methodBuilder((String)method.name()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(BindingSet.bestGuess(method.returnType()));
                String[] parameterTypes = method.parameters();
                int count = parameterTypes.length;
                for (int i = 0; i < count; ++i) {
                    callbackMethod.addParameter(BindingSet.bestGuess(parameterTypes[i]), "p" + i, new Modifier[0]);
                }
                boolean hasReturnType = !"void".equals(method.returnType());
                CodeBlock.Builder builder = CodeBlock.builder();
                if (hasReturnType) {
                    builder.add("return ", new Object[0]);
                }
                if (methodBindings.containsKey(method)) {
                    for (MethodViewBinding methodBinding : methodBindings.get(method)) {
                        builder.add("target.$L(", new Object[]{methodBinding.getName()});
                        List<Parameter> parameters = methodBinding.getParameters();
                        String[] listenerParameters = method.parameters();
                        int count2 = parameters.size();
                        for (int i = 0; i < count2; ++i) {
                            int listenerPosition;
                            Parameter parameter;
                            if (i > 0) {
                                builder.add(", ", new Object[0]);
                            }
                            if ((parameter = parameters.get(i)).requiresCast(listenerParameters[listenerPosition = parameter.getListenerPosition()])) {
                                if (debuggable) {
                                    builder.add("$T.castParam(p$L, $S, $L, $S, $L, $T.class)", new Object[]{UTILS, listenerPosition, method.name(), listenerPosition, methodBinding.getName(), i, parameter.getType()});
                                    continue;
                                }
                                builder.add("($T) p$L", new Object[]{parameter.getType(), listenerPosition});
                                continue;
                            }
                            builder.add("p$L", new Object[]{listenerPosition});
                        }
                        builder.add(");\n", new Object[0]);
                    }
                } else if (hasReturnType) {
                    builder.add("$L;\n", new Object[]{method.defaultReturn()});
                }
                callbackMethod.addCode(builder.build());
                callback.addMethod(callbackMethod.build());
            }
            boolean requiresRemoval = listener.remover().length() != 0;
            String listenerField = null;
            if (requiresRemoval) {
                TypeName listenerClassName = BindingSet.bestGuess(listener.type());
                listenerField = fieldName + ((ClassName)listenerClassName).simpleName();
                result.addStatement("$L = $L", new Object[]{listenerField, callback.build()});
            }
            if (!"android.view.View".equals(listener.targetType())) {
                result.addStatement("(($T) $N).$L($L)", new Object[]{BindingSet.bestGuess(listener.targetType()), bindName, listener.setter(), requiresRemoval ? listenerField : callback.build()});
                continue;
            }
            result.addStatement("$N.$L($L)", new Object[]{bindName, listener.setter(), requiresRemoval ? listenerField : callback.build()});
        }
        if (needsNullChecked) {
            result.endControlFlow();
        }
    }

    private static List<ListenerMethod> getListenerMethods(ListenerClass listener) {
        if (listener.method().length == 1) {
            return Arrays.asList(listener.method());
        }
        try {
            ArrayList<ListenerMethod> methods = new ArrayList<ListenerMethod>();
            Class callbacks = listener.callbacks();
            for (Enum callbackMethod : (Enum[])callbacks.getEnumConstants()) {
                Field callbackField = callbacks.getField(callbackMethod.name());
                ListenerMethod method = callbackField.getAnnotation(ListenerMethod.class);
                if (method == null) {
                    throw new IllegalStateException(String.format("@%s's %s.%s missing @%s annotation.", callbacks.getEnclosingClass().getSimpleName(), callbacks.getSimpleName(), callbackMethod.name(), ListenerMethod.class.getSimpleName()));
                }
                methods.add(method);
            }
            return methods;
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    static String asHumanDescription(Collection<? extends MemberViewBinding> bindings) {
        Iterator<? extends MemberViewBinding> iterator = bindings.iterator();
        switch (bindings.size()) {
            case 1: {
                return iterator.next().getDescription();
            }
            case 2: {
                return iterator.next().getDescription() + " and " + iterator.next().getDescription();
            }
        }
        StringBuilder builder = new StringBuilder();
        int count = bindings.size();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            if (i == count - 1) {
                builder.append("and ");
            }
            builder.append(iterator.next().getDescription());
        }
        return builder.toString();
    }

    private static TypeName bestGuess(String type) {
        switch (type) {
            case "void": {
                return TypeName.VOID;
            }
            case "boolean": {
                return TypeName.BOOLEAN;
            }
            case "byte": {
                return TypeName.BYTE;
            }
            case "char": {
                return TypeName.CHAR;
            }
            case "double": {
                return TypeName.DOUBLE;
            }
            case "float": {
                return TypeName.FLOAT;
            }
            case "int": {
                return TypeName.INT;
            }
            case "long": {
                return TypeName.LONG;
            }
            case "short": {
                return TypeName.SHORT;
            }
        }
        int left = type.indexOf(60);
        if (left != -1) {
            ClassName typeClassName = ClassName.bestGuess((String)type.substring(0, left));
            ArrayList<WildcardTypeName> typeArguments = new ArrayList<WildcardTypeName>();
            do {
                typeArguments.add(WildcardTypeName.subtypeOf(Object.class));
            } while ((left = type.indexOf(60, left + 1)) != -1);
            return ParameterizedTypeName.get((ClassName)typeClassName, (TypeName[])typeArguments.toArray(new TypeName[typeArguments.size()]));
        }
        return ClassName.bestGuess((String)type);
    }

    private boolean hasViewBindings() {
        return !this.viewBindings.isEmpty() || !this.collectionBindings.isEmpty();
    }

    private boolean hasUnqualifiedResourceBindings() {
        for (ResourceBinding binding : this.resourceBindings) {
            if (binding.id().qualifed) continue;
            return true;
        }
        return false;
    }

    private boolean hasResourceBindingsNeedingResource(int sdk) {
        for (ResourceBinding binding : this.resourceBindings) {
            if (!binding.requiresResources(sdk)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMethodBindings() {
        for (ViewBinding bindings : this.viewBindings) {
            if (bindings.getMethodBindings().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean hasOnTouchMethodBindings() {
        for (ViewBinding bindings : this.viewBindings) {
            if (!bindings.getMethodBindings().containsKey(OnTouch.class.getAnnotation(ListenerClass.class))) continue;
            return true;
        }
        return false;
    }

    private boolean hasFieldBindings() {
        for (ViewBinding bindings : this.viewBindings) {
            if (bindings.getFieldBinding() == null) continue;
            return true;
        }
        return !this.collectionBindings.isEmpty();
    }

    private boolean hasTargetField() {
        return this.hasFieldBindings() || this.hasMethodBindings();
    }

    private boolean hasViewLocal() {
        for (ViewBinding bindings : this.viewBindings) {
            if (!bindings.requiresLocal()) continue;
            return true;
        }
        return false;
    }

    private boolean constructorNeedsView() {
        return this.hasViewBindings() || this.parentBinding != null && this.parentBinding.constructorNeedsView();
    }

    static boolean requiresCast(TypeName type) {
        return !"android.view.View".equals(type.toString());
    }

    public String toString() {
        return this.bindingClassName.toString();
    }

    static Builder newBuilder(TypeElement enclosingElement) {
        TypeMirror typeMirror = enclosingElement.asType();
        boolean isView = ButterKnifeProcessor.isSubtypeOfType(typeMirror, "android.view.View");
        boolean isActivity = ButterKnifeProcessor.isSubtypeOfType(typeMirror, "android.app.Activity");
        boolean isDialog = ButterKnifeProcessor.isSubtypeOfType(typeMirror, "android.app.Dialog");
        TypeName targetType = TypeName.get((TypeMirror)typeMirror);
        if (targetType instanceof ParameterizedTypeName) {
            targetType = ((ParameterizedTypeName)targetType).rawType;
        }
        String packageName = MoreElements.getPackage((Element)enclosingElement).getQualifiedName().toString();
        String className = enclosingElement.getQualifiedName().toString().substring(packageName.length() + 1).replace('.', '$');
        ClassName bindingClassName = ClassName.get((String)packageName, (String)(className + "_ViewBinding"), (String[])new String[0]);
        boolean isFinal = enclosingElement.getModifiers().contains((Object)Modifier.FINAL);
        return new Builder(targetType, bindingClassName, isFinal, isView, isActivity, isDialog);
    }

    static final class Builder {
        private final TypeName targetTypeName;
        private final ClassName bindingClassName;
        private final boolean isFinal;
        private final boolean isView;
        private final boolean isActivity;
        private final boolean isDialog;
        private BindingSet parentBinding;
        private final Map<Id, ViewBinding.Builder> viewIdMap = new LinkedHashMap<Id, ViewBinding.Builder>();
        private final ImmutableList.Builder<FieldCollectionViewBinding> collectionBindings = ImmutableList.builder();
        private final ImmutableList.Builder<ResourceBinding> resourceBindings = ImmutableList.builder();

        private Builder(TypeName targetTypeName, ClassName bindingClassName, boolean isFinal, boolean isView, boolean isActivity, boolean isDialog) {
            this.targetTypeName = targetTypeName;
            this.bindingClassName = bindingClassName;
            this.isFinal = isFinal;
            this.isView = isView;
            this.isActivity = isActivity;
            this.isDialog = isDialog;
        }

        void addField(Id id, FieldViewBinding binding) {
            this.getOrCreateViewBindings(id).setFieldBinding(binding);
        }

        void addFieldCollection(FieldCollectionViewBinding binding) {
            this.collectionBindings.add((Object)binding);
        }

        boolean addMethod(Id id, ListenerClass listener, ListenerMethod method, MethodViewBinding binding) {
            ViewBinding.Builder viewBinding = this.getOrCreateViewBindings(id);
            if (viewBinding.hasMethodBinding(listener, method) && !"void".equals(method.returnType())) {
                return false;
            }
            viewBinding.addMethodBinding(listener, method, binding);
            return true;
        }

        void addResource(ResourceBinding binding) {
            this.resourceBindings.add((Object)binding);
        }

        void setParent(BindingSet parent) {
            this.parentBinding = parent;
        }

        String findExistingBindingName(Id id) {
            ViewBinding.Builder builder = this.viewIdMap.get(id);
            if (builder == null) {
                return null;
            }
            FieldViewBinding fieldBinding = builder.fieldBinding;
            if (fieldBinding == null) {
                return null;
            }
            return fieldBinding.getName();
        }

        private ViewBinding.Builder getOrCreateViewBindings(Id id) {
            ViewBinding.Builder viewId = this.viewIdMap.get(id);
            if (viewId == null) {
                viewId = new ViewBinding.Builder(id);
                this.viewIdMap.put(id, viewId);
            }
            return viewId;
        }

        BindingSet build() {
            ImmutableList.Builder viewBindings = ImmutableList.builder();
            for (ViewBinding.Builder builder : this.viewIdMap.values()) {
                viewBindings.add((Object)builder.build());
            }
            return new BindingSet(this.targetTypeName, this.bindingClassName, this.isFinal, this.isView, this.isActivity, this.isDialog, viewBindings.build(), this.collectionBindings.build(), this.resourceBindings.build(), this.parentBinding);
        }
    }
}

