/*
 * Decompiled with CFR 0.152.
 */
package butterknife.compiler;

import android.support.annotation.Nullable;
import butterknife.compiler.Id;
import butterknife.compiler.ResourceBinding;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;

final class FieldTypefaceBinding
implements ResourceBinding {
    private static final ClassName RESOURCES_COMPAT = ClassName.get((String)"android.support.v4.content.res", (String)"ResourcesCompat", (String[])new String[0]);
    private static final ClassName TYPEFACE = ClassName.get((String)"android.graphics", (String)"Typeface", (String[])new String[0]);
    private final Id id;
    private final String name;
    private final TypefaceStyles style;

    FieldTypefaceBinding(Id id, String name, TypefaceStyles style) {
        this.id = id;
        this.name = name;
        this.style = style;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean requiresResources(int sdk) {
        return sdk >= 26;
    }

    @Override
    public CodeBlock render(int sdk) {
        CodeBlock typeface;
        CodeBlock codeBlock = typeface = sdk >= 26 ? CodeBlock.of((String)"res.getFont($L)", (Object[])new Object[]{this.id.code}) : CodeBlock.of((String)"$T.getFont(context, $L)", (Object[])new Object[]{RESOURCES_COMPAT, this.id.code});
        if (this.style != TypefaceStyles.NORMAL) {
            typeface = CodeBlock.of((String)"$1T.create($2L, $1T.$3L)", (Object[])new Object[]{TYPEFACE, typeface, this.style});
        }
        return CodeBlock.of((String)"target.$L = $L", (Object[])new Object[]{this.name, typeface});
    }

    static enum TypefaceStyles {
        NORMAL(0),
        BOLD(1),
        ITALIC(2),
        BOLD_ITALIC(3);

        final int value;

        private TypefaceStyles(int value) {
            this.value = value;
        }

        @Nullable
        static TypefaceStyles fromValue(int value) {
            for (TypefaceStyles style : TypefaceStyles.values()) {
                if (style.value != value) continue;
                return style;
            }
            return null;
        }
    }
}

