/*
 * Decompiled with CFR 0.152.
 */
package butterknife.plugin;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Modifier;

public final class FinalRClassBuilder {
    private static final String SUPPORT_ANNOTATION_PACKAGE = "android.support.annotation";
    private static final String[] SUPPORTED_TYPES = new String[]{"array", "attr", "bool", "color", "dimen", "drawable", "id", "integer", "string"};

    private FinalRClassBuilder() {
    }

    public static void brewJava(File rFile, File outputDir, String packageName, String className) throws Exception {
        CompilationUnit compilationUnit = JavaParser.parse((File)rFile);
        TypeDeclaration resourceClass = (TypeDeclaration)compilationUnit.getTypes().get(0);
        TypeSpec.Builder result = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.FINAL});
        for (Node node : resourceClass.getChildrenNodes()) {
            if (!(node instanceof TypeDeclaration)) continue;
            FinalRClassBuilder.addResourceType(Arrays.asList(SUPPORTED_TYPES), result, (TypeDeclaration)node);
        }
        JavaFile finalR = JavaFile.builder((String)packageName, (TypeSpec)result.build()).addFileComment("Generated code from Butter Knife gradle plugin. Do not modify!", new Object[0]).build();
        finalR.writeTo(outputDir);
    }

    private static void addResourceType(List<String> supportedTypes, TypeSpec.Builder result, TypeDeclaration node) {
        if (!supportedTypes.contains(node.getName())) {
            return;
        }
        String type = node.getName();
        TypeSpec.Builder resourceType = TypeSpec.classBuilder((String)type).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        for (BodyDeclaration field : node.getMembers()) {
            if (!(field instanceof FieldDeclaration)) continue;
            FinalRClassBuilder.addResourceField(resourceType, (VariableDeclarator)((FieldDeclaration)field).getVariables().get(0), FinalRClassBuilder.getSupportAnnotationClass(type));
        }
        result.addType(resourceType.build());
    }

    private static void addResourceField(TypeSpec.Builder resourceType, VariableDeclarator variable, ClassName annotation) {
        String fieldName = variable.getId().getName();
        String fieldValue = variable.getInit().toString();
        FieldSpec.Builder fieldSpecBuilder = FieldSpec.builder(Integer.TYPE, (String)fieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(fieldValue, new Object[0]);
        if (annotation != null) {
            fieldSpecBuilder.addAnnotation(annotation);
        }
        resourceType.addField(fieldSpecBuilder.build());
    }

    private static ClassName getSupportAnnotationClass(String type) {
        return ClassName.get((String)SUPPORT_ANNOTATION_PACKAGE, (String)(FinalRClassBuilder.capitalize(type) + "Res"), (String[])new String[0]);
    }

    private static String capitalize(String word) {
        return Character.toUpperCase(word.charAt(0)) + word.substring(1);
    }
}

