/*
 * Decompiled with CFR 0.152.
 */
package butterknife;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.AdapterView;
import android.widget.CompoundButton;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.viewpager.widget.ViewPager;
import butterknife.BindAnim;
import butterknife.BindArray;
import butterknife.BindBitmap;
import butterknife.BindBool;
import butterknife.BindColor;
import butterknife.BindDimen;
import butterknife.BindDrawable;
import butterknife.BindFloat;
import butterknife.BindFont;
import butterknife.BindInt;
import butterknife.BindString;
import butterknife.BindView;
import butterknife.BindViews;
import butterknife.CompositeUnbinder;
import butterknife.EmptyTextWatcher;
import butterknife.FieldUnbinder;
import butterknife.ListenerUnbinder;
import butterknife.OnCheckedChanged;
import butterknife.OnClick;
import butterknife.OnEditorAction;
import butterknife.OnFocusChange;
import butterknife.OnItemClick;
import butterknife.OnItemLongClick;
import butterknife.OnLongClick;
import butterknife.OnPageChange;
import butterknife.OnTextChanged;
import butterknife.OnTouch;
import butterknife.Optional;
import butterknife.Setter;
import butterknife.Unbinder;
import butterknife.ViewCollections;
import butterknife.internal.Utils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ButterKnife {
    private static final String TAG = "ButterKnife";
    private static boolean debug = false;
    private static final Setter<CompoundButton, CompoundButton.OnCheckedChangeListener> ON_CHECKED_CHANGE = (view, value, index) -> view.setOnCheckedChangeListener(value);
    private static final Setter<View, View.OnClickListener> ON_CLICK = (view, value, index) -> view.setOnClickListener(value);
    private static final Setter<TextView, TextView.OnEditorActionListener> ON_EDITOR_ACTION = (view, value, index) -> view.setOnEditorActionListener(value);
    private static final Setter<View, View.OnFocusChangeListener> ON_FOCUS_CHANGE = (view, value, index) -> view.setOnFocusChangeListener(value);
    private static final Setter<AdapterView<?>, AdapterView.OnItemClickListener> ON_ITEM_CLICK = (view, value, index) -> view.setOnItemClickListener(value);
    private static final Setter<AdapterView<?>, AdapterView.OnItemLongClickListener> ON_ITEM_LONG_CLICK = (view, value, index) -> view.setOnItemLongClickListener(value);
    private static final Setter<View, View.OnLongClickListener> ON_LONG_CLICK = (view, value, index) -> view.setOnLongClickListener(value);
    private static final Setter<View, View.OnTouchListener> ON_TOUCH = (view, value, index) -> view.setOnTouchListener(value);
    private static final Setter<ViewPager, ViewPager.OnPageChangeListener> ADD_ON_PAGE_CHANGE = (view, value, index) -> view.addOnPageChangeListener(value);
    private static final Setter<ViewPager, ViewPager.OnPageChangeListener> REMOVE_ON_PAGE_CHANGE = (view, value, index) -> view.removeOnPageChangeListener(value);
    private static final Setter<TextView, TextWatcher> ADD_TEXT_WATCHER = (view, value, index) -> view.addTextChangedListener(value);
    private static final Setter<TextView, TextWatcher> REMOVE_TEXT_WATCHER = (view, value, index) -> view.removeTextChangedListener(value);
    private static final Class<?>[] ON_CHECKED_CHANGED_TYPES = new Class[]{CompoundButton.class, Boolean.TYPE};
    private static final Class<?>[] ON_CLICK_TYPES = new Class[]{View.class};
    private static final Class<?>[] ON_EDITOR_ACTION_TYPES = new Class[]{TextView.class, Integer.TYPE, KeyEvent.class};
    private static final Class<?>[] ON_FOCUS_CHANGE_TYPES = new Class[]{View.class, Boolean.TYPE};
    private static final Class<?>[] ON_ITEM_CLICK_TYPES = new Class[]{AdapterView.class, View.class, Integer.TYPE, Long.TYPE};
    private static final Class<?>[] ON_ITEM_LONG_CLICK_TYPES = ON_ITEM_CLICK_TYPES;
    private static final Class<?>[] ON_LONG_CLICK_TYPES = ON_CLICK_TYPES;
    private static final Class<?>[] ON_PAGE_SCROLLED_TYPES = new Class[]{Integer.TYPE, Float.TYPE, Integer.TYPE};
    private static final Class<?>[] ON_PAGE_SELECTED_TYPES = new Class[]{Integer.TYPE};
    private static final Class<?>[] ON_PAGE_SCROLL_STATE_CHANGED_TYPES = new Class[]{Integer.TYPE};
    private static final Class<?>[] ON_TEXT_CHANGED_TYPES = new Class[]{CharSequence.class, Integer.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] BEFORE_TEXT_CHANGED_TYPES = ON_TEXT_CHANGED_TYPES;
    private static final Class<?>[] AFTER_TEXT_CHANGED_TYPES = new Class[]{Editable.class};
    private static final Class<?>[] ON_TOUCH_TYPES = new Class[]{View.class, MotionEvent.class};

    private ButterKnife() {
        throw new AssertionError();
    }

    public static void setDebug(boolean debug) {
        ButterKnife.debug = debug;
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull Activity target) {
        View sourceView = target.getWindow().getDecorView();
        return ButterKnife.bind((Object)target, sourceView);
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull View target) {
        return ButterKnife.bind((Object)target, target);
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull Dialog target) {
        View sourceView = target.getWindow().getDecorView();
        return ButterKnife.bind((Object)target, sourceView);
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull Object target, @NonNull Activity source) {
        View sourceView = source.getWindow().getDecorView();
        return ButterKnife.bind(target, sourceView);
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull Object target, @NonNull Dialog source) {
        View sourceView = source.getWindow().getDecorView();
        return ButterKnife.bind(target, sourceView);
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull Object target, @NonNull View source) {
        String clsName;
        ArrayList<Unbinder> unbinders = new ArrayList<Unbinder>();
        Class<?> targetClass = target.getClass();
        if ((targetClass.getModifiers() & 2) != 0) {
            throw new IllegalArgumentException(targetClass.getName() + " must not be private.");
        }
        while (!((clsName = targetClass.getName()).startsWith("android.") || clsName.startsWith("java.") || clsName.startsWith("androidx."))) {
            for (Field field : targetClass.getDeclaredFields()) {
                int unbinderStartingSize = unbinders.size();
                Unbinder unbinder = ButterKnife.parseBindView(target, field, source);
                if (unbinder != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseBindViews(target, field, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseBindAnim(target, field, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseBindArray(target, field, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseBindBitmap(target, field, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseBindBool(target, field, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseBindColor(target, field, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseBindDimen(target, field, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseBindDrawable(target, field, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseBindFloat(target, field, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseBindFont(target, field, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseBindInt(target, field, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseBindString(target, field, source)) != null) {
                    unbinders.add(unbinder);
                }
                if (unbinders.size() - unbinderStartingSize <= 1) continue;
                throw new IllegalStateException("More than one bind annotation on " + targetClass.getName() + "." + field.getName());
            }
            for (AccessibleObject accessibleObject : targetClass.getDeclaredMethods()) {
                Unbinder unbinder = ButterKnife.parseOnCheckedChanged(target, (Method)accessibleObject, source);
                if (unbinder != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseOnClick(target, (Method)accessibleObject, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseOnEditorAction(target, (Method)accessibleObject, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseOnFocusChange(target, (Method)accessibleObject, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseOnItemClick(target, (Method)accessibleObject, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseOnItemLongClick(target, (Method)accessibleObject, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseOnLongClick(target, (Method)accessibleObject, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseOnPageChange(target, (Method)accessibleObject, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseOnTextChanged(target, (Method)accessibleObject, source)) != null) {
                    unbinders.add(unbinder);
                }
                if ((unbinder = ButterKnife.parseOnTouch(target, (Method)accessibleObject, source)) == null) continue;
                unbinders.add(unbinder);
            }
            targetClass = targetClass.getSuperclass();
        }
        if (unbinders.isEmpty()) {
            if (debug) {
                Log.d((String)TAG, (String)"MISS: Reached framework class. Abandoning search.");
            }
            return Unbinder.EMPTY;
        }
        if (debug) {
            Log.d((String)TAG, (String)("HIT: Reflectively found " + unbinders.size() + " bindings."));
        }
        return new CompositeUnbinder(unbinders);
    }

    @Nullable
    private static Unbinder parseBindView(Object target, Field field, View source) {
        BindView bindView = field.getAnnotation(BindView.class);
        if (bindView == null) {
            return null;
        }
        ButterKnife.validateMember(field);
        int id = bindView.value();
        Class<?> viewClass = field.getType();
        if (!View.class.isAssignableFrom(viewClass) && !viewClass.isInterface()) {
            throw new IllegalStateException("@BindView fields must extend from View or be an interface. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
        }
        String who = "field '" + field.getName() + "'";
        Object view = Utils.findOptionalViewAsType((View)source, (int)id, (String)who, viewClass);
        ButterKnife.trySet(field, target, view);
        return new FieldUnbinder(target, field);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static Unbinder parseBindViews(Object target, Field field, View source) {
        Object[] value;
        Class viewClass;
        BindViews bindViews = field.getAnnotation(BindViews.class);
        if (bindViews == null) {
            return null;
        }
        ButterKnife.validateMember(field);
        Class<?> fieldClass = field.getType();
        boolean isArray = fieldClass.isArray();
        if (isArray) {
            viewClass = fieldClass.getComponentType();
        } else {
            if (fieldClass != List.class) throw new IllegalStateException("@BindViews must be a List or array. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
            Type fieldType = field.getGenericType();
            if (!(fieldType instanceof ParameterizedType)) throw new IllegalStateException("@BindViews List must have a generic component. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
            Type viewType = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
            viewClass = (Class)viewType;
        }
        if (!View.class.isAssignableFrom(viewClass) && !viewClass.isInterface()) {
            throw new IllegalStateException("@BindViews List or array type must extend from View or be an interface. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
        }
        int[] ids = bindViews.value();
        if (ids.length == 0) {
            throw new IllegalStateException("@BindViews must specify at least one ID. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
        }
        Object[] views = new ArrayList(ids.length);
        String who = "field '" + field.getName() + "'";
        for (int id : ids) {
            Object view = Utils.findOptionalViewAsType((View)source, (int)id, (String)who, (Class)viewClass);
            if (view == null) continue;
            views.add(view);
        }
        if (isArray) {
            Object[] viewArray = (Object[])Array.newInstance(viewClass, views.size());
            value = views.toArray(viewArray);
        } else {
            value = views;
        }
        ButterKnife.trySet(field, target, value);
        return new FieldUnbinder(target, field);
    }

    @Nullable
    private static Unbinder parseBindAnim(Object target, Field field, View source) {
        BindAnim bindAnim = field.getAnnotation(BindAnim.class);
        if (bindAnim == null) {
            return null;
        }
        ButterKnife.validateMember(field);
        int id = bindAnim.value();
        Context context = source.getContext();
        Class<?> fieldType = field.getType();
        if (fieldType != Animation.class) {
            throw new IllegalStateException("@BindAnim field type must be 'Animation'. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
        }
        Animation value = AnimationUtils.loadAnimation((Context)context, (int)id);
        ButterKnife.trySet(field, target, value);
        return Unbinder.EMPTY;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static Unbinder parseBindArray(Object target, Field field, View source) {
        void var6_12;
        BindArray bindArray = field.getAnnotation(BindArray.class);
        if (bindArray == null) {
            return null;
        }
        ButterKnife.validateMember(field);
        int id = bindArray.value();
        Resources resources = source.getContext().getResources();
        Class<?> fieldType = field.getType();
        if (fieldType == TypedArray.class) {
            TypedArray typedArray = resources.obtainTypedArray(id);
        } else {
            if (!fieldType.isArray()) throw new IllegalStateException("@BindArray field type must be one of: String[], int[], CharSequence[], android.content.res.TypedArray. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
            Class<?> componentType = fieldType.getComponentType();
            if (componentType == String.class) {
                String[] stringArray = resources.getStringArray(id);
            } else if (componentType == Integer.TYPE) {
                int[] nArray = resources.getIntArray(id);
            } else {
                if (componentType != CharSequence.class) throw new IllegalStateException("@BindArray field type must be one of: String[], int[], CharSequence[], android.content.res.TypedArray. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
                CharSequence[] charSequenceArray = resources.getTextArray(id);
            }
        }
        ButterKnife.trySet(field, target, var6_12);
        return Unbinder.EMPTY;
    }

    @Nullable
    private static Unbinder parseBindBitmap(Object target, Field field, View source) {
        BindBitmap bindBitmap = field.getAnnotation(BindBitmap.class);
        if (bindBitmap == null) {
            return null;
        }
        ButterKnife.validateMember(field);
        int id = bindBitmap.value();
        Resources resources = source.getContext().getResources();
        Class<?> fieldType = field.getType();
        if (fieldType != Bitmap.class) {
            throw new IllegalStateException("@BindBitmap field type must be 'Bitmap'. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
        }
        Bitmap value = BitmapFactory.decodeResource((Resources)resources, (int)id);
        ButterKnife.trySet(field, target, value);
        return Unbinder.EMPTY;
    }

    @Nullable
    private static Unbinder parseBindBool(Object target, Field field, View source) {
        BindBool bindBool = field.getAnnotation(BindBool.class);
        if (bindBool == null) {
            return null;
        }
        ButterKnife.validateMember(field);
        int id = bindBool.value();
        Resources resources = source.getContext().getResources();
        Class<?> fieldType = field.getType();
        if (fieldType != Boolean.TYPE) {
            throw new IllegalStateException("@BindBool field type must be 'boolean'. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
        }
        Boolean value = resources.getBoolean(id);
        ButterKnife.trySet(field, target, value);
        return Unbinder.EMPTY;
    }

    @Nullable
    private static Unbinder parseBindColor(Object target, Field field, View source) {
        Integer value;
        BindColor bindColor = field.getAnnotation(BindColor.class);
        if (bindColor == null) {
            return null;
        }
        ButterKnife.validateMember(field);
        int id = bindColor.value();
        Context context = source.getContext();
        Class<?> fieldType = field.getType();
        if (fieldType == Integer.TYPE) {
            value = ContextCompat.getColor((Context)context, (int)id);
        } else if (fieldType == ColorStateList.class) {
            value = ContextCompat.getColorStateList((Context)context, (int)id);
        } else {
            throw new IllegalStateException("@BindColor field type must be 'int' or 'ColorStateList'. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
        }
        ButterKnife.trySet(field, target, value);
        return Unbinder.EMPTY;
    }

    @Nullable
    private static Unbinder parseBindDimen(Object target, Field field, View source) {
        Number value;
        BindDimen bindDimen = field.getAnnotation(BindDimen.class);
        if (bindDimen == null) {
            return null;
        }
        ButterKnife.validateMember(field);
        int id = bindDimen.value();
        Resources resources = source.getContext().getResources();
        Class<?> fieldType = field.getType();
        if (fieldType == Integer.TYPE) {
            value = resources.getDimensionPixelSize(id);
        } else if (fieldType == Float.TYPE) {
            value = Float.valueOf(resources.getDimension(id));
        } else {
            throw new IllegalStateException("@BindDimen field type must be 'int' or 'float'. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
        }
        ButterKnife.trySet(field, target, value);
        return Unbinder.EMPTY;
    }

    @Nullable
    private static Unbinder parseBindDrawable(Object target, Field field, View source) {
        BindDrawable bindDrawable = field.getAnnotation(BindDrawable.class);
        if (bindDrawable == null) {
            return null;
        }
        ButterKnife.validateMember(field);
        int id = bindDrawable.value();
        int tint = bindDrawable.tint();
        Context context = source.getContext();
        Class<?> fieldType = field.getType();
        if (fieldType != Drawable.class) {
            throw new IllegalStateException("@BindDrawable field type must be 'Drawable'. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
        }
        Drawable value = tint != -1 ? Utils.getTintedDrawable((Context)context, (int)id, (int)tint) : ContextCompat.getDrawable((Context)context, (int)id);
        ButterKnife.trySet(field, target, value);
        return Unbinder.EMPTY;
    }

    @Nullable
    private static Unbinder parseBindFloat(Object target, Field field, View source) {
        BindFloat bindInt = field.getAnnotation(BindFloat.class);
        if (bindInt == null) {
            return null;
        }
        ButterKnife.validateMember(field);
        int id = bindInt.value();
        Context context = source.getContext();
        Class<?> fieldType = field.getType();
        if (fieldType != Float.TYPE) {
            throw new IllegalStateException("@BindFloat field type must be 'float'. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
        }
        Float value = Float.valueOf(Utils.getFloat((Context)context, (int)id));
        ButterKnife.trySet(field, target, value);
        return Unbinder.EMPTY;
    }

    @Nullable
    private static Unbinder parseBindFont(Object target, Field field, View source) {
        Typeface value;
        BindFont bindFont = field.getAnnotation(BindFont.class);
        if (bindFont == null) {
            return null;
        }
        ButterKnife.validateMember(field);
        int id = bindFont.value();
        int style = bindFont.style();
        Context context = source.getContext();
        Class<?> fieldType = field.getType();
        if (fieldType == Typeface.class) {
            Typeface font = ResourcesCompat.getFont((Context)context, (int)id);
            switch (style) {
                case 0: {
                    value = font;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    value = Typeface.create((Typeface)font, (int)style);
                    break;
                }
                default: {
                    throw new IllegalStateException("@BindFont style must be NORMAL, BOLD, ITALIC, or BOLD_ITALIC. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
                }
            }
        } else {
            throw new IllegalStateException("@BindFont field type must be 'Typeface'. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
        }
        ButterKnife.trySet(field, target, value);
        return Unbinder.EMPTY;
    }

    @Nullable
    private static Unbinder parseBindInt(Object target, Field field, View source) {
        BindInt bindInt = field.getAnnotation(BindInt.class);
        if (bindInt == null) {
            return null;
        }
        ButterKnife.validateMember(field);
        int id = bindInt.value();
        Resources resources = source.getContext().getResources();
        Class<?> fieldType = field.getType();
        if (fieldType != Integer.TYPE) {
            throw new IllegalStateException("@BindInt field type must be 'int'. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
        }
        Integer value = resources.getInteger(id);
        ButterKnife.trySet(field, target, value);
        return Unbinder.EMPTY;
    }

    @Nullable
    private static Unbinder parseBindString(Object target, Field field, View source) {
        BindString bindString = field.getAnnotation(BindString.class);
        if (bindString == null) {
            return null;
        }
        ButterKnife.validateMember(field);
        int id = bindString.value();
        Context context = source.getContext();
        Class<?> fieldType = field.getType();
        if (fieldType != String.class) {
            throw new IllegalStateException("@BindString field type must be 'String'. (" + field.getDeclaringClass().getName() + '.' + field.getName() + ')');
        }
        String value = context.getString(id);
        ButterKnife.trySet(field, target, value);
        return Unbinder.EMPTY;
    }

    @Nullable
    private static Unbinder parseOnCheckedChanged(Object target, Method method, View source) {
        OnCheckedChanged onCheckedChanged = method.getAnnotation(OnCheckedChanged.class);
        if (onCheckedChanged == null) {
            return null;
        }
        ButterKnife.validateMember(method);
        ButterKnife.validateReturnType(method, Void.TYPE);
        ArgumentTransformer argumentTransformer = ButterKnife.createArgumentTransformer(method, ON_CHECKED_CHANGED_TYPES);
        List views = ButterKnife.findViews(source, onCheckedChanged.value(), ButterKnife.isRequired(method), method.getName(), CompoundButton.class);
        ViewCollections.set(views, ON_CHECKED_CHANGE, (buttonView, isChecked) -> ButterKnife.tryInvoke(method, target, argumentTransformer.transform(buttonView, isChecked)));
        return new ListenerUnbinder<CompoundButton, CompoundButton.OnCheckedChangeListener>(views, ON_CHECKED_CHANGE);
    }

    @Nullable
    private static Unbinder parseOnClick(Object target, Method method, View source) {
        OnClick onClick = method.getAnnotation(OnClick.class);
        if (onClick == null) {
            return null;
        }
        ButterKnife.validateMember(method);
        ButterKnife.validateReturnType(method, Void.TYPE);
        ArgumentTransformer argumentTransformer = ButterKnife.createArgumentTransformer(method, ON_CLICK_TYPES);
        List views = ButterKnife.findViews(source, onClick.value(), ButterKnife.isRequired(method), method.getName(), View.class);
        ViewCollections.set(views, ON_CLICK, v -> ButterKnife.tryInvoke(method, target, argumentTransformer.transform(v)));
        return new ListenerUnbinder<View, View.OnClickListener>(views, ON_CLICK);
    }

    @Nullable
    private static Unbinder parseOnEditorAction(Object target, Method method, View source) {
        OnEditorAction onEditorAction = method.getAnnotation(OnEditorAction.class);
        if (onEditorAction == null) {
            return null;
        }
        ButterKnife.validateMember(method);
        boolean propagateReturn = ButterKnife.validateReturnType(method, Boolean.TYPE);
        ArgumentTransformer argumentTransformer = ButterKnife.createArgumentTransformer(method, ON_EDITOR_ACTION_TYPES);
        List views = ButterKnife.findViews(source, onEditorAction.value(), ButterKnife.isRequired(method), method.getName(), TextView.class);
        ViewCollections.set(views, ON_EDITOR_ACTION, (v, actionId, event) -> {
            Object value = ButterKnife.tryInvoke(method, target, argumentTransformer.transform(v, actionId, event));
            return propagateReturn ? (Boolean)value : true;
        });
        return new ListenerUnbinder<TextView, TextView.OnEditorActionListener>(views, ON_EDITOR_ACTION);
    }

    @Nullable
    private static Unbinder parseOnFocusChange(Object target, Method method, View source) {
        OnFocusChange onFocusChange = method.getAnnotation(OnFocusChange.class);
        if (onFocusChange == null) {
            return null;
        }
        ButterKnife.validateMember(method);
        ButterKnife.validateReturnType(method, Void.TYPE);
        ArgumentTransformer argumentTransformer = ButterKnife.createArgumentTransformer(method, ON_FOCUS_CHANGE_TYPES);
        List views = ButterKnife.findViews(source, onFocusChange.value(), ButterKnife.isRequired(method), method.getName(), View.class);
        ViewCollections.set(views, ON_FOCUS_CHANGE, (v, hasFocus) -> ButterKnife.tryInvoke(method, target, argumentTransformer.transform(v, hasFocus)));
        return new ListenerUnbinder<View, View.OnFocusChangeListener>(views, ON_FOCUS_CHANGE);
    }

    @Nullable
    private static Unbinder parseOnItemClick(Object target, Method method, View source) {
        OnItemClick onItemClick = method.getAnnotation(OnItemClick.class);
        if (onItemClick == null) {
            return null;
        }
        ButterKnife.validateMember(method);
        ButterKnife.validateReturnType(method, Void.TYPE);
        ArgumentTransformer argumentTransformer = ButterKnife.createArgumentTransformer(method, ON_ITEM_CLICK_TYPES);
        List views = ButterKnife.findViews(source, onItemClick.value(), ButterKnife.isRequired(method), method.getName(), AdapterView.class);
        ViewCollections.set(views, ON_ITEM_CLICK, (parent, view, position, id) -> ButterKnife.tryInvoke(method, target, argumentTransformer.transform(parent, view, position, id)));
        return new ListenerUnbinder(views, ON_ITEM_CLICK);
    }

    @Nullable
    private static Unbinder parseOnItemLongClick(Object target, Method method, View source) {
        OnItemLongClick onItemLongClick = method.getAnnotation(OnItemLongClick.class);
        if (onItemLongClick == null) {
            return null;
        }
        ButterKnife.validateMember(method);
        boolean propagateReturn = ButterKnife.validateReturnType(method, Boolean.TYPE);
        ArgumentTransformer argumentTransformer = ButterKnife.createArgumentTransformer(method, ON_ITEM_LONG_CLICK_TYPES);
        List views = ButterKnife.findViews(source, onItemLongClick.value(), ButterKnife.isRequired(method), method.getName(), AdapterView.class);
        ViewCollections.set(views, ON_ITEM_LONG_CLICK, (parent, view, position, id) -> {
            Object value = ButterKnife.tryInvoke(method, target, argumentTransformer.transform(parent, view, position, id));
            return propagateReturn ? (Boolean)value : true;
        });
        return new ListenerUnbinder(views, ON_ITEM_LONG_CLICK);
    }

    @Nullable
    private static Unbinder parseOnLongClick(Object target, Method method, View source) {
        OnLongClick onLongClick = method.getAnnotation(OnLongClick.class);
        if (onLongClick == null) {
            return null;
        }
        ButterKnife.validateMember(method);
        boolean propagateReturn = ButterKnife.validateReturnType(method, Boolean.TYPE);
        ArgumentTransformer argumentTransformer = ButterKnife.createArgumentTransformer(method, ON_LONG_CLICK_TYPES);
        List views = ButterKnife.findViews(source, onLongClick.value(), ButterKnife.isRequired(method), method.getName(), View.class);
        ViewCollections.set(views, ON_LONG_CLICK, v -> {
            Object returnValue = ButterKnife.tryInvoke(method, target, argumentTransformer.transform(v));
            return propagateReturn ? (Boolean)returnValue : true;
        });
        return new ListenerUnbinder<View, View.OnLongClickListener>(views, ON_LONG_CLICK);
    }

    @Nullable
    private static Unbinder parseOnPageChange(final Object target, final Method method, View source) {
        ViewPager.SimpleOnPageChangeListener listener;
        OnPageChange onPageChange = method.getAnnotation(OnPageChange.class);
        if (onPageChange == null) {
            return null;
        }
        ButterKnife.validateMember(method);
        ButterKnife.validateReturnType(method, Void.TYPE);
        List views = ButterKnife.findViews(source, onPageChange.value(), ButterKnife.isRequired(method), method.getName(), ViewPager.class);
        switch (onPageChange.callback()) {
            case PAGE_SCROLLED: {
                final ArgumentTransformer argumentTransformer = ButterKnife.createArgumentTransformer(method, ON_PAGE_SCROLLED_TYPES);
                listener = new ViewPager.SimpleOnPageChangeListener(){

                    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                        ButterKnife.tryInvoke(method, target, argumentTransformer.transform(position, Float.valueOf(positionOffset), positionOffsetPixels));
                    }
                };
                break;
            }
            case PAGE_SELECTED: {
                final ArgumentTransformer argumentTransformer = ButterKnife.createArgumentTransformer(method, ON_PAGE_SELECTED_TYPES);
                listener = new ViewPager.SimpleOnPageChangeListener(){

                    public void onPageSelected(int position) {
                        ButterKnife.tryInvoke(method, target, argumentTransformer.transform(position));
                    }
                };
                break;
            }
            case PAGE_SCROLL_STATE_CHANGED: {
                final ArgumentTransformer argumentTransformer = ButterKnife.createArgumentTransformer(method, ON_PAGE_SCROLL_STATE_CHANGED_TYPES);
                listener = new ViewPager.SimpleOnPageChangeListener(){

                    public void onPageScrollStateChanged(int state) {
                        ButterKnife.tryInvoke(method, target, argumentTransformer.transform(state));
                    }
                };
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        ViewCollections.set(views, ADD_ON_PAGE_CHANGE, (Object)listener);
        return new ListenerUnbinder<ViewPager, ViewPager.SimpleOnPageChangeListener>(views, REMOVE_ON_PAGE_CHANGE, listener);
    }

    @Nullable
    private static Unbinder parseOnTextChanged(final Object target, final Method method, View source) {
        EmptyTextWatcher textWatcher;
        OnTextChanged onTextChanged = method.getAnnotation(OnTextChanged.class);
        if (onTextChanged == null) {
            return null;
        }
        ButterKnife.validateMember(method);
        ButterKnife.validateReturnType(method, Void.TYPE);
        List views = ButterKnife.findViews(source, onTextChanged.value(), ButterKnife.isRequired(method), method.getName(), View.class);
        switch (onTextChanged.callback()) {
            case TEXT_CHANGED: {
                final ArgumentTransformer argumentTransformer = ButterKnife.createArgumentTransformer(method, ON_TEXT_CHANGED_TYPES);
                textWatcher = new EmptyTextWatcher(){

                    @Override
                    public void onTextChanged(CharSequence s, int start, int before, int count) {
                        ButterKnife.tryInvoke(method, target, argumentTransformer.transform(s, start, before, count));
                    }
                };
                break;
            }
            case BEFORE_TEXT_CHANGED: {
                final ArgumentTransformer argumentTransformer = ButterKnife.createArgumentTransformer(method, BEFORE_TEXT_CHANGED_TYPES);
                textWatcher = new EmptyTextWatcher(){

                    @Override
                    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                        ButterKnife.tryInvoke(method, target, argumentTransformer.transform(s, start, count, after));
                    }
                };
                break;
            }
            case AFTER_TEXT_CHANGED: {
                final ArgumentTransformer argumentTransformer = ButterKnife.createArgumentTransformer(method, AFTER_TEXT_CHANGED_TYPES);
                textWatcher = new EmptyTextWatcher(){

                    @Override
                    public void afterTextChanged(Editable s) {
                        ButterKnife.tryInvoke(method, target, argumentTransformer.transform(s));
                    }
                };
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        ViewCollections.set(views, ADD_TEXT_WATCHER, (Object)textWatcher);
        return new ListenerUnbinder<TextView, 4>(views, (Setter<TextView, 4>)REMOVE_TEXT_WATCHER, textWatcher);
    }

    @Nullable
    private static Unbinder parseOnTouch(Object target, Method method, View source) {
        OnTouch onTouch = method.getAnnotation(OnTouch.class);
        if (onTouch == null) {
            return null;
        }
        ButterKnife.validateMember(method);
        boolean propagateReturn = ButterKnife.validateReturnType(method, Boolean.TYPE);
        ArgumentTransformer argumentTransformer = ButterKnife.createArgumentTransformer(method, ON_TOUCH_TYPES);
        List views = ButterKnife.findViews(source, onTouch.value(), ButterKnife.isRequired(method), method.getName(), View.class);
        ViewCollections.set(views, ON_TOUCH, (v, event) -> {
            Object returnValue = ButterKnife.tryInvoke(method, target, argumentTransformer.transform(v));
            return propagateReturn ? (Boolean)returnValue : true;
        });
        return new ListenerUnbinder<View, View.OnTouchListener>(views, ON_TOUCH);
    }

    private static <T extends View> List<T> findViews(View source, int[] ids, boolean isRequired, String name, Class<? extends View> cls) {
        if (ids.length == 1 && ids[0] == -1) {
            return Collections.singletonList(cls.cast(source));
        }
        String who = "method '" + name + "'";
        ArrayList<View> views = new ArrayList<View>(ids.length);
        for (int id : ids) {
            if (isRequired) {
                views.add((View)Utils.findRequiredViewAsType((View)source, (int)id, (String)who, cls));
                continue;
            }
            View view = (View)Utils.findOptionalViewAsType((View)source, (int)id, (String)who, cls);
            if (view == null) continue;
            views.add(view);
        }
        return views;
    }

    private static <T extends AccessibleObject> void validateMember(T object) {
        int modifiers = ((Member)((Object)object)).getModifiers();
        if ((modifiers & 0xA) != 0) {
            throw new IllegalStateException(((Member)((Object)object)).getDeclaringClass().getName() + "." + ((Member)((Object)object)).getName() + " must not be private or static");
        }
        if ((modifiers & 1) == 0) {
            object.setAccessible(true);
        }
    }

    private static boolean validateReturnType(Method method, Class<?> expected) {
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            return false;
        }
        if (returnType != expected) {
            String expectedType = "'" + expected.getName() + "'";
            if (expected != Void.TYPE) {
                expectedType = "'void' or " + expectedType;
            }
            throw new IllegalStateException(method.getDeclaringClass().getName() + "." + method.getName() + " must have return type of " + expectedType);
        }
        return true;
    }

    private static boolean isRequired(Method method) {
        return method.getAnnotation(Optional.class) == null;
    }

    private static ArgumentTransformer createArgumentTransformer(Method method, Class<?>[] callbackParameterTypes) {
        Object[] targetParameterTypes = method.getParameterTypes();
        int targetParameterLength = targetParameterTypes.length;
        if (targetParameterLength == 0) {
            return ArgumentTransformer.EMPTY;
        }
        int callbackParameterLength = callbackParameterTypes.length;
        if (targetParameterLength > callbackParameterLength) {
            throw new IllegalStateException(method.getDeclaringClass().getName() + "." + method.getName() + " must have at most " + callbackParameterLength + " parameter(s).");
        }
        if (Arrays.equals(targetParameterTypes, callbackParameterTypes)) {
            return ArgumentTransformer.IDENTITY;
        }
        boolean[] callbackIndexUsed = new boolean[callbackParameterLength];
        final int[] indexMap = new int[targetParameterLength];
        for (int targetIndex = 0; targetIndex < targetParameterLength; ++targetIndex) {
            int callbackIndex;
            block9: {
                Object targetParameterType = targetParameterTypes[targetIndex];
                for (callbackIndex = 0; callbackIndex < callbackParameterLength; ++callbackIndex) {
                    Class<?> callbackParameterType;
                    if (!(!callbackIndexUsed[callbackIndex] && ((callbackParameterType = callbackParameterTypes[callbackIndex]).equals(targetParameterType) || View.class.isAssignableFrom(callbackParameterType) && callbackParameterType.isAssignableFrom((Class<?>)targetParameterType) || ((Class)targetParameterType).isInterface()))) {
                        continue;
                    }
                    break block9;
                }
                StringBuilder builder = new StringBuilder();
                builder.append("Unable to match ").append(method.getDeclaringClass().getName()).append('.').append(method.getName()).append(" method arguments.");
                for (int i = 0; i < targetParameterLength; ++i) {
                    builder.append("\n\n  Parameter #").append(i + 1).append(": ").append(((Class)targetParameterTypes[i]).getName()).append("\n    ");
                    if (i < targetIndex) {
                        builder.append("matched listener parameter #").append(indexMap[i]).append(": ").append(callbackParameterTypes[indexMap[i]].getName());
                        continue;
                    }
                    builder.append("did not match any listener parameters");
                }
                builder.append("\n\nMethods may have up to ").append(callbackParameterLength).append(" parameter(s):\n");
                for (Class<?> callbackParameter : callbackParameterTypes) {
                    builder.append("\n  ").append(callbackParameter.getName());
                }
                builder.append("\n\nThese may be listed in any order but will be searched for from top to bottom.");
                throw new IllegalStateException(builder.toString());
            }
            indexMap[targetIndex] = callbackIndex;
            callbackIndexUsed[callbackIndex] = true;
        }
        return new ArgumentTransformer(){

            @Override
            public Object[] transform(Object ... arguments) {
                Object[] newArguments = new Object[indexMap.length];
                for (int i = 0; i < indexMap.length; ++i) {
                    newArguments[i] = arguments[indexMap[i]];
                }
                return newArguments;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder("ArgumentTransformer[");
                for (int i = 0; i < indexMap.length; ++i) {
                    if (i > 0) {
                        builder.append(", ");
                    }
                    builder.append(i).append(" => ").append(indexMap[i]);
                }
                return builder.append(']').toString();
            }
        };
    }

    static void trySet(Field field, Object target, @Nullable Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to assign " + value + " to " + field + " on " + target, e);
        }
    }

    private static Object tryInvoke(Method method, Object target, Object ... arguments) {
        ReflectiveOperationException cause;
        try {
            return method.invoke(target, arguments);
        }
        catch (IllegalAccessException e) {
            cause = e;
        }
        catch (InvocationTargetException e) {
            cause = e;
        }
        throw new RuntimeException("Unable to invoke " + method + " on " + target + " with arguments " + Arrays.toString(arguments), cause);
    }

    private static interface ArgumentTransformer {
        public static final ArgumentTransformer EMPTY = new ArgumentTransformer(){
            private final Object[] empty = new Object[0];

            @Override
            public Object[] transform(Object ... arguments) {
                return this.empty;
            }

            public String toString() {
                return "ArgumentTransformer[empty]";
            }
        };
        public static final ArgumentTransformer IDENTITY = new ArgumentTransformer(){

            @Override
            public Object[] transform(Object ... arguments) {
                return arguments;
            }

            public String toString() {
                return "ArgumentTransformer[identity]";
            }
        };

        public Object[] transform(Object ... var1);
    }
}

