/*
 * Decompiled with CFR 0.152.
 */
package butterknife;

import android.app.Activity;
import android.view.View;
import butterknife.InjectView;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class Views {
    private static final Map<Class<?>, Method> INJECTORS = new LinkedHashMap();

    private Views() {
    }

    public static void inject(Activity target) {
        Views.inject(target, Activity.class, target);
    }

    public static void inject(Object target, View source) {
        Views.inject(target, View.class, source);
    }

    private static void inject(Object target, Class<?> sourceType, Object source) {
        try {
            Class<?> targetClass = target.getClass();
            Method inject = INJECTORS.get(targetClass);
            if (inject == null) {
                Class<?> injector = Class.forName(targetClass.getName() + "$$ViewInjector");
                inject = injector.getMethod("inject", targetClass, sourceType);
                INJECTORS.put(targetClass, inject);
            }
            inject.invoke(null, target, source);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnableToInjectException("Unable to inject views for " + target, e);
        }
    }

    public static <T extends View> T findById(View view, int id) {
        return (T)view.findViewById(id);
    }

    public static <T extends View> T findById(Activity activity, int id) {
        return (T)activity.findViewById(id);
    }

    @SupportedAnnotationTypes(value={"butterknife.InjectView"})
    public static class AnnotationProcessor
    extends AbstractProcessor {
        static final String SUFFIX = "$$ViewInjector";
        private static final String TYPE_ACTIVITY = "android.app.Activity";
        private static final String TYPE_VIEW = "android.view.View";
        private static final String INJECTION = "    target.%s = (%s) source.findViewById(%s);";
        private static final String INJECTOR = "package %s;\n\npublic class %s {\n  public static void inject(%s target, %s source) {\n%s  }\n}\n";

        @Override
        public SourceVersion getSupportedSourceVersion() {
            return SourceVersion.latestSupported();
        }

        private void error(String message, Object ... args) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(message, args));
        }

        @Override
        public boolean process(Set<? extends TypeElement> elements, RoundEnvironment env) {
            LinkedHashMap injectionsByClass = new LinkedHashMap();
            HashSet<TypeMirror> injectionTargets = new HashSet<TypeMirror>();
            for (Element element : env.getElementsAnnotatedWith(InjectView.class)) {
                TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
                if (enclosingElement.getKind() != ElementKind.CLASS) {
                    this.error("Unexpected @InjectView on field in " + element, new Object[0]);
                    continue;
                }
                Set<Modifier> modifiers = element.getModifiers();
                if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.PROTECTED) || modifiers.contains((Object)Modifier.STATIC)) {
                    this.error("@InjectView fields must not be private, protected, or static: " + enclosingElement.getQualifiedName() + "." + element, new Object[0]);
                    continue;
                }
                HashSet<InjectionPoint> injections = (HashSet<InjectionPoint>)injectionsByClass.get(enclosingElement);
                if (injections == null) {
                    injections = new HashSet<InjectionPoint>();
                    injectionsByClass.put(enclosingElement, injections);
                }
                String variableName = element.getSimpleName().toString();
                String type = ((Object)element.asType()).toString();
                int value = element.getAnnotation(InjectView.class).value();
                injections.add(new InjectionPoint(variableName, type, value));
                injectionTargets.add(enclosingElement.asType());
            }
            for (Map.Entry entry : injectionsByClass.entrySet()) {
                TypeElement type = (TypeElement)entry.getKey();
                String targetType = type.getQualifiedName().toString();
                String sourceType = this.resolveSourceType(type);
                String packageName = this.processingEnv.getElementUtils().getPackageOf(type).toString();
                String className = type.getQualifiedName().toString().substring(packageName.length() + 1).replace('.', '$') + SUFFIX;
                String parentClass = this.resolveParentType(type, injectionTargets);
                StringBuilder injections = new StringBuilder();
                if (parentClass != null) {
                    injections.append("    ").append(parentClass).append(SUFFIX).append(".inject(activity);\n\n");
                }
                for (InjectionPoint injectionPoint : (Set)entry.getValue()) {
                    injections.append(injectionPoint).append("\n");
                }
                try {
                    JavaFileObject jfo = this.processingEnv.getFiler().createSourceFile(packageName + "." + className, type);
                    Writer writer = jfo.openWriter();
                    writer.write(String.format(INJECTOR, packageName, className, targetType, sourceType, injections.toString()));
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    this.error(e.getMessage(), new Object[0]);
                }
            }
            return true;
        }

        private String resolveSourceType(TypeElement typeElement) {
            TypeMirror type;
            while ((type = typeElement.getSuperclass()).getKind() != TypeKind.NONE) {
                if (((Object)type).toString().equals(TYPE_ACTIVITY)) {
                    return TYPE_ACTIVITY;
                }
                typeElement = (TypeElement)((DeclaredType)type).asElement();
            }
            return TYPE_VIEW;
        }

        private String resolveParentType(TypeElement typeElement, Set<TypeMirror> parents) {
            TypeMirror type;
            while ((type = typeElement.getSuperclass()).getKind() != TypeKind.NONE) {
                if (parents.contains(type)) {
                    return ((Object)type).toString();
                }
                typeElement = (TypeElement)((DeclaredType)type).asElement();
            }
            return null;
        }

        private static class InjectionPoint {
            private final String variableName;
            private final String type;
            private final int value;

            InjectionPoint(String variableName, String type, int value) {
                this.variableName = variableName;
                this.type = type;
                this.value = value;
            }

            public String toString() {
                return String.format(AnnotationProcessor.INJECTION, this.variableName, this.type, this.value);
            }
        }
    }

    public static class UnableToInjectException
    extends RuntimeException {
        UnableToInjectException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

