/*
 * Decompiled with CFR 0.152.
 */
package butterknife;

import android.app.Activity;
import android.view.View;
import butterknife.InjectView;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class Views {
    private static final Map<Class<?>, Method> INJECTORS = new LinkedHashMap();

    private Views() {
    }

    public static void inject(Activity target) {
        Views.inject(target, target, Finder.ACTIVITY);
    }

    public static void inject(View target) {
        Views.inject(target, target, Finder.VIEW);
    }

    public static void inject(Object target, Activity source) {
        Views.inject(target, source, Finder.ACTIVITY);
    }

    public static void inject(Object target, View source) {
        Views.inject(target, source, Finder.VIEW);
    }

    private static void inject(Object target, Object source, Finder finder) {
        try {
            Class<?> targetClass = target.getClass();
            Method inject = INJECTORS.get(targetClass);
            if (inject == null) {
                Class<?> injector = Class.forName(targetClass.getName() + "$$ViewInjector");
                inject = injector.getMethod("inject", Finder.class, targetClass, Object.class);
                INJECTORS.put(targetClass, inject);
            }
            inject.invoke(null, new Object[]{finder, target, source});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnableToInjectException("Unable to inject views for " + target, e);
        }
    }

    public static <T extends View> T findById(View view, int id) {
        return (T)view.findViewById(id);
    }

    public static <T extends View> T findById(Activity activity, int id) {
        return (T)activity.findViewById(id);
    }

    @SupportedAnnotationTypes(value={"butterknife.InjectView"})
    public static class InjectViewProcessor
    extends AbstractProcessor {
        static final String SUFFIX = "$$ViewInjector";
        private static final String INJECTION = "    target.%s = finder.findById(source, %s);";
        private static final String PARENT = "    %s.inject(finder, target, source);";
        private static final String INJECTOR = "// Generated code from Butter Knife. Do not modify!\npackage %s;\n\nimport butterknife.Views.Finder;\n\npublic class %s {\n  public static void inject(Finder finder, %s target, Object source) {\n%s  }\n}\n";

        @Override
        public SourceVersion getSupportedSourceVersion() {
            return SourceVersion.latestSupported();
        }

        private void error(Element element, String message, Object ... args) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(message, args), element);
        }

        @Override
        public boolean process(Set<? extends TypeElement> elements, RoundEnvironment env) {
            Elements elementUtils = this.processingEnv.getElementUtils();
            Types typeUtils = this.processingEnv.getTypeUtils();
            Filer filer = this.processingEnv.getFiler();
            TypeMirror viewType = elementUtils.getTypeElement("android.view.View").asType();
            LinkedHashMap injectionsByClass = new LinkedHashMap();
            HashSet<TypeMirror> injectionTargets = new HashSet<TypeMirror>();
            for (Element element : env.getElementsAnnotatedWith(InjectView.class)) {
                TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
                if (!typeUtils.isSubtype(element.asType(), viewType)) {
                    this.error(element, "@InjectView fields must extend from View (%s.%s).", enclosingElement.getQualifiedName(), element);
                    continue;
                }
                Set<Modifier> modifiers = element.getModifiers();
                if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.STATIC)) {
                    this.error(element, "@InjectView fields must not be private or static (%s.%s).", enclosingElement.getQualifiedName(), element);
                    continue;
                }
                if (enclosingElement.getKind() != ElementKind.CLASS) {
                    this.error(element, "@InjectView field annotations may only be specified in classes (%s).", enclosingElement);
                    continue;
                }
                if (enclosingElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    this.error(element, "@InjectView fields may not be on private classes (%s).", enclosingElement);
                    continue;
                }
                HashSet<InjectionPoint> injections = (HashSet<InjectionPoint>)injectionsByClass.get(enclosingElement);
                if (injections == null) {
                    injections = new HashSet<InjectionPoint>();
                    injectionsByClass.put(enclosingElement, injections);
                }
                String variableName = element.getSimpleName().toString();
                int value = element.getAnnotation(InjectView.class).value();
                injections.add(new InjectionPoint(variableName, value));
                injectionTargets.add(enclosingElement.asType());
            }
            for (Map.Entry entry : injectionsByClass.entrySet()) {
                TypeElement type = (TypeElement)entry.getKey();
                Set injectionPoints = (Set)entry.getValue();
                String targetType = type.getQualifiedName().toString();
                String packageName = elementUtils.getPackageOf(type).getQualifiedName().toString();
                String className = type.getQualifiedName().toString().substring(packageName.length() + 1).replace('.', '$') + SUFFIX;
                String parentClass = this.resolveParentType(type, injectionTargets);
                StringBuilder injections = new StringBuilder();
                if (parentClass != null) {
                    injections.append(String.format(PARENT, parentClass)).append('\n');
                }
                for (InjectionPoint injectionPoint : injectionPoints) {
                    injections.append(injectionPoint).append('\n');
                }
                try {
                    JavaFileObject jfo = filer.createSourceFile(packageName + "." + className, type);
                    Writer writer = jfo.openWriter();
                    writer.write(String.format(INJECTOR, packageName, className, targetType, injections.toString()));
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    this.error(type, "Unable to write injector for type %s: %s", type, e.getMessage());
                }
            }
            return true;
        }

        private String resolveParentType(TypeElement typeElement, Set<TypeMirror> parents) {
            TypeMirror type;
            while ((type = typeElement.getSuperclass()).getKind() != TypeKind.NONE) {
                if (parents.contains(type)) {
                    return ((Object)type).toString();
                }
                typeElement = (TypeElement)((DeclaredType)type).asElement();
            }
            return null;
        }

        private static class InjectionPoint {
            private final String variableName;
            private final int value;

            InjectionPoint(String variableName, int value) {
                this.variableName = variableName;
                this.value = value;
            }

            public String toString() {
                return String.format(InjectViewProcessor.INJECTION, this.variableName, this.value);
            }
        }
    }

    public static class UnableToInjectException
    extends RuntimeException {
        UnableToInjectException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static enum Finder {
        VIEW{

            @Override
            public <T extends View> T findById(Object source, int id) {
                return (T)((View)source).findViewById(id);
            }
        }
        ,
        ACTIVITY{

            @Override
            public <T extends View> T findById(Object source, int id) {
                return (T)((Activity)source).findViewById(id);
            }
        };


        public abstract <T extends View> T findById(Object var1, int var2);
    }
}

