/*
 * Decompiled with CFR 0.152.
 */
package butterknife;

import android.app.Activity;
import android.view.View;
import butterknife.InjectView;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class Views {
    static final Map<Class<?>, Method> INJECTORS = new LinkedHashMap();
    static final Map<Class<?>, Method> RESETTERS = new LinkedHashMap();
    static final Method NO_OP = null;

    private Views() {
    }

    public static void inject(Activity target) {
        Views.inject(target, target, Finder.ACTIVITY);
    }

    public static void inject(View target) {
        Views.inject(target, target, Finder.VIEW);
    }

    public static void inject(Object target, Activity source) {
        Views.inject(target, source, Finder.ACTIVITY);
    }

    public static void inject(Object target, View source) {
        Views.inject(target, source, Finder.VIEW);
    }

    public static void reset(Object target) {
        Class<?> targetClass = target.getClass();
        try {
            Method reset = Views.findResettersForClass(targetClass);
            if (reset != null) {
                reset.invoke(null, target);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnableToResetException("Unable to reset views for " + target, e);
        }
    }

    static void inject(Object target, Object source, Finder finder) {
        Class<?> targetClass = target.getClass();
        try {
            Method inject = Views.findInjectorForClass(targetClass);
            if (inject != null) {
                inject.invoke(null, new Object[]{finder, target, source});
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnableToInjectException("Unable to inject views for " + target, e);
        }
    }

    static Method findInjectorForClass(Class<?> cls) throws NoSuchMethodException {
        Method inject = INJECTORS.get(cls);
        if (inject != null) {
            return inject;
        }
        String clsName = cls.getName();
        if (clsName.startsWith("android.") || clsName.startsWith("java.")) {
            return NO_OP;
        }
        try {
            Class<?> injector = Class.forName(clsName + "$$ViewInjector");
            inject = injector.getMethod("inject", Finder.class, cls, Object.class);
        }
        catch (ClassNotFoundException e) {
            inject = Views.findInjectorForClass(cls.getSuperclass());
        }
        INJECTORS.put(cls, inject);
        return inject;
    }

    static Method findResettersForClass(Class<?> cls) throws NoSuchMethodException {
        Method inject = RESETTERS.get(cls);
        if (inject != null) {
            return inject;
        }
        String clsName = cls.getName();
        if (clsName.startsWith("android.") || clsName.startsWith("java.")) {
            return NO_OP;
        }
        try {
            Class<?> injector = Class.forName(clsName + "$$ViewInjector");
            inject = injector.getMethod("reset", cls);
        }
        catch (ClassNotFoundException e) {
            inject = Views.findResettersForClass(cls.getSuperclass());
        }
        RESETTERS.put(cls, inject);
        return inject;
    }

    public static <T extends View> T findById(View view, int id) {
        return (T)view.findViewById(id);
    }

    public static <T extends View> T findById(Activity activity, int id) {
        return (T)activity.findViewById(id);
    }

    @SupportedAnnotationTypes(value={"butterknife.InjectView"})
    public static class InjectViewProcessor
    extends AbstractProcessor {
        static final String SUFFIX = "$$ViewInjector";
        private static final String FINDER = "    view = finder.findById(source, %s);";
        private static final String INJECT = "    target.%s = (%s) view;";
        private static final String RESET = "    target.%s = null;";
        private static final String PARENT_INJECT = "    %s%s.inject(finder, target, source);";
        private static final String PARENT_RESET = "    %s%s.reset(target);";
        private static final String INJECTOR = "// Generated code from Butter Knife. Do not modify!\npackage %s;\n\nimport android.view.View;\nimport butterknife.Views.Finder;\n\npublic class %s {\n  public static void inject(Finder finder, %s target, Object source) {\n    View view;\n%s  }\n\n  public static void reset(%s target) {\n%s  }\n}\n";

        @Override
        public SourceVersion getSupportedSourceVersion() {
            return SourceVersion.latestSupported();
        }

        private void error(Element element, String message, Object ... args) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(message, args), element);
        }

        @Override
        public boolean process(Set<? extends TypeElement> elements, RoundEnvironment env) {
            Elements elementUtils = this.processingEnv.getElementUtils();
            Types typeUtils = this.processingEnv.getTypeUtils();
            Filer filer = this.processingEnv.getFiler();
            TypeMirror viewType = elementUtils.getTypeElement("android.view.View").asType();
            LinkedHashMap injectionsByClass = new LinkedHashMap();
            LinkedHashSet<TypeMirror> injectionTargets = new LinkedHashSet<TypeMirror>();
            for (Element element : env.getElementsAnnotatedWith(InjectView.class)) {
                TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
                if (!typeUtils.isSubtype(element.asType(), viewType)) {
                    this.error(element, "@InjectView fields must extend from View (%s.%s).", enclosingElement.getQualifiedName(), element);
                    continue;
                }
                Set<Modifier> modifiers = element.getModifiers();
                if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.STATIC)) {
                    this.error(element, "@InjectView fields must not be private or static (%s.%s).", enclosingElement.getQualifiedName(), element);
                    continue;
                }
                if (enclosingElement.getKind() != ElementKind.CLASS) {
                    this.error(element, "@InjectView field annotations may only be specified in classes (%s).", enclosingElement);
                    continue;
                }
                if (enclosingElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    this.error(element, "@InjectView fields may not be on private classes (%s).", enclosingElement);
                    continue;
                }
                LinkedHashMap<Integer, LinkedHashSet<InjectionPoint>> injections = (LinkedHashMap<Integer, LinkedHashSet<InjectionPoint>>)injectionsByClass.get(enclosingElement);
                if (injections == null) {
                    injections = new LinkedHashMap<Integer, LinkedHashSet<InjectionPoint>>();
                    injectionsByClass.put(enclosingElement, injections);
                }
                String variableName = element.getSimpleName().toString();
                int value = element.getAnnotation(InjectView.class).value();
                String type = ((Object)element.asType()).toString();
                LinkedHashSet<InjectionPoint> injectionPoints = (LinkedHashSet<InjectionPoint>)injections.get(value);
                if (injectionPoints == null) {
                    injectionPoints = new LinkedHashSet<InjectionPoint>();
                    injections.put(value, injectionPoints);
                }
                injectionPoints.add(new InjectionPoint(variableName, type));
                TypeMirror erasedInjectionType = typeUtils.erasure(enclosingElement.asType());
                injectionTargets.add(erasedInjectionType);
            }
            for (Map.Entry entry : injectionsByClass.entrySet()) {
                TypeElement type = (TypeElement)entry.getKey();
                String targetType = type.getQualifiedName().toString();
                String classPackage = this.getPackageName(type);
                String className = InjectViewProcessor.getClassName(type, classPackage) + SUFFIX;
                String classFqcn = classPackage + "." + className;
                String parentClassFqcn = this.findParentFqcn(type, injectionTargets);
                StringBuilder injectBuilder = new StringBuilder();
                StringBuilder resetBuilder = new StringBuilder();
                if (parentClassFqcn != null) {
                    injectBuilder.append(String.format(PARENT_INJECT, parentClassFqcn, SUFFIX)).append('\n');
                    resetBuilder.append(String.format(PARENT_RESET, parentClassFqcn, SUFFIX)).append('\n');
                }
                for (Map.Entry viewIdInjections : ((Map)entry.getValue()).entrySet()) {
                    injectBuilder.append(String.format(FINDER, viewIdInjections.getKey())).append('\n');
                    for (InjectionPoint injectionPoint : (Set)viewIdInjections.getValue()) {
                        injectBuilder.append(injectionPoint).append('\n');
                        resetBuilder.append(String.format(RESET, injectionPoint.variableName)).append('\n');
                    }
                }
                String injections = injectBuilder.toString();
                String resetters = resetBuilder.toString();
                try {
                    JavaFileObject jfo = filer.createSourceFile(classFqcn, type);
                    Writer writer = jfo.openWriter();
                    writer.write(String.format(INJECTOR, classPackage, className, targetType, injections, targetType, resetters));
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    this.error(type, "Unable to write injector for type %s: %s", type, e.getMessage());
                }
            }
            return true;
        }

        private String findParentFqcn(TypeElement typeElement, Set<TypeMirror> parents) {
            TypeMirror type;
            do {
                if ((type = typeElement.getSuperclass()).getKind() == TypeKind.NONE) {
                    return null;
                }
                typeElement = (TypeElement)((DeclaredType)type).asElement();
            } while (!this.containsTypeMirror(parents, type));
            String packageName = this.getPackageName(typeElement);
            return packageName + "." + InjectViewProcessor.getClassName(typeElement, packageName);
        }

        private boolean containsTypeMirror(Collection<TypeMirror> mirrors, TypeMirror query) {
            Types typeUtils = this.processingEnv.getTypeUtils();
            query = typeUtils.erasure(query);
            for (TypeMirror mirror : mirrors) {
                if (!typeUtils.isSameType(mirror, query)) continue;
                return true;
            }
            return false;
        }

        private String getPackageName(TypeElement type) {
            return this.processingEnv.getElementUtils().getPackageOf(type).getQualifiedName().toString();
        }

        private static String getClassName(TypeElement type, String packageName) {
            return type.getQualifiedName().toString().substring(packageName.length() + 1).replace('.', '$');
        }

        private static class InjectionPoint {
            private final String variableName;
            private final String type;

            InjectionPoint(String variableName, String type) {
                this.variableName = variableName;
                this.type = type;
            }

            public String toString() {
                return String.format(InjectViewProcessor.INJECT, this.variableName, this.type);
            }
        }
    }

    public static class UnableToResetException
    extends RuntimeException {
        UnableToResetException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class UnableToInjectException
    extends RuntimeException {
        UnableToInjectException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static enum Finder {
        VIEW{

            @Override
            public View findById(Object source, int id) {
                return ((View)source).findViewById(id);
            }
        }
        ,
        ACTIVITY{

            @Override
            public View findById(Object source, int id) {
                return ((Activity)source).findViewById(id);
            }
        };


        public abstract View findById(Object var1, int var2);
    }
}

