/*
 * Decompiled with CFR 0.152.
 */
package butterknife;

import android.app.Activity;
import android.app.Dialog;
import android.util.Log;
import android.view.View;
import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import butterknife.Unbinder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ButterKnife {
    private static final String TAG = "ButterKnife";
    private static boolean debug = false;
    @VisibleForTesting
    static final Map<Class<?>, Constructor<? extends Unbinder>> BINDINGS = new LinkedHashMap();

    private ButterKnife() {
        throw new AssertionError((Object)"No instances.");
    }

    public static void setDebug(boolean debug) {
        ButterKnife.debug = debug;
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull Activity target) {
        View sourceView = target.getWindow().getDecorView();
        return ButterKnife.bind((Object)target, sourceView);
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull View target) {
        return ButterKnife.bind((Object)target, target);
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull Dialog target) {
        View sourceView = target.getWindow().getDecorView();
        return ButterKnife.bind((Object)target, sourceView);
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull Object target, @NonNull Activity source) {
        View sourceView = source.getWindow().getDecorView();
        return ButterKnife.bind(target, sourceView);
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull Object target, @NonNull Dialog source) {
        View sourceView = source.getWindow().getDecorView();
        return ButterKnife.bind(target, sourceView);
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull Object target, @NonNull View source) {
        Constructor<? extends Unbinder> constructor;
        Class<?> targetClass = target.getClass();
        if (debug) {
            Log.d((String)TAG, (String)("Looking up binding for " + targetClass.getName()));
        }
        if ((constructor = ButterKnife.findBindingConstructorForClass(targetClass)) == null) {
            return Unbinder.EMPTY;
        }
        try {
            return constructor.newInstance(target, source);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to invoke " + constructor, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to invoke " + constructor, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException("Unable to create binding instance.", cause);
        }
    }

    @Nullable
    @CheckResult
    @UiThread
    private static Constructor<? extends Unbinder> findBindingConstructorForClass(Class<?> cls) {
        Constructor<Object> bindingCtor = BINDINGS.get(cls);
        if (bindingCtor != null || BINDINGS.containsKey(cls)) {
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Cached in binding map.");
            }
            return bindingCtor;
        }
        String clsName = cls.getName();
        if (clsName.startsWith("android.") || clsName.startsWith("java.") || clsName.startsWith("androidx.")) {
            if (debug) {
                Log.d((String)TAG, (String)"MISS: Reached framework class. Abandoning search.");
            }
            return null;
        }
        try {
            Class<?> bindingClass = cls.getClassLoader().loadClass(clsName + "_ViewBinding");
            bindingCtor = bindingClass.getConstructor(cls, View.class);
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Loaded binding class and constructor.");
            }
        }
        catch (ClassNotFoundException e) {
            if (debug) {
                Log.d((String)TAG, (String)("Not found. Trying superclass " + cls.getSuperclass().getName()));
            }
            bindingCtor = ButterKnife.findBindingConstructorForClass(cls.getSuperclass());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find binding constructor for " + clsName, e);
        }
        BINDINGS.put(cls, bindingCtor);
        return bindingCtor;
    }
}

