/*
 * Decompiled with CFR 0.152.
 */
package butterknife.internal;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

class TargetClass {
    private final Map<Integer, ViewId> viewIdMap = new LinkedHashMap<Integer, ViewId>();
    private final String classPackage;
    private final String className;
    private final String targetClass;
    private String parentInjector;

    TargetClass(String classPackage, String className, String targetClass) {
        this.classPackage = classPackage;
        this.className = className;
        this.targetClass = targetClass;
    }

    void addField(int id, String name, String type, boolean required) {
        this.getTargetView((int)id).fields.add(new FieldInjection(name, type, required));
    }

    boolean addMethod(int id, String name, String parameterType, boolean required) {
        ViewId targetView = this.getTargetView(id);
        if (targetView.method != null) {
            return false;
        }
        targetView.method = new MethodInjection(name, parameterType, required);
        return true;
    }

    void setParentInjector(String parentInjector) {
        this.parentInjector = parentInjector;
    }

    private ViewId getTargetView(int id) {
        ViewId viewId = this.viewIdMap.get(id);
        if (viewId == null) {
            viewId = new ViewId(id);
            this.viewIdMap.put(id, viewId);
        }
        return viewId;
    }

    String getFqcn() {
        return this.classPackage + "." + this.className;
    }

    String brewJava() {
        StringBuilder builder = new StringBuilder();
        builder.append("// Generated code from Butter Knife. Do not modify!\n");
        builder.append("package ").append(this.classPackage).append(";\n\n");
        builder.append("import android.view.View;\n");
        builder.append("import butterknife.Views.Finder;\n\n");
        builder.append("public class ").append(this.className).append(" {\n");
        builder.append("  public static void inject(Finder finder, final ").append(this.targetClass).append(" target, Object source) {\n");
        if (this.parentInjector != null) {
            builder.append("    ").append(this.parentInjector).append(".inject(finder, target, source);\n\n");
        }
        builder.append("    View view;\n");
        for (Map.Entry<Integer, ViewId> entry : this.viewIdMap.entrySet()) {
            int id = entry.getKey();
            builder.append("    view = finder.findById(source, ").append(id).append(");\n");
            ViewId viewId = entry.getValue();
            for (FieldInjection fieldInjection : viewId.fields) {
                if (fieldInjection.required) {
                    builder.append("    if (view == null) {\n").append("      throw new IllegalStateException(\"Required view with id '").append(id).append("' for field '").append(fieldInjection.name).append("' was not found. If this field binding is optional add '@Optional'.\");\n").append("    }\n");
                }
                builder.append("    target.").append(fieldInjection.name).append(" = ");
                if (!"android.view.View".equals(fieldInjection.type)) {
                    builder.append("(").append(fieldInjection.type).append(") ");
                }
                builder.append("view;\n");
            }
            MethodInjection method = viewId.method;
            if (method == null) continue;
            if (method.required) {
                builder.append("    if (view == null) {\n").append("      throw new IllegalStateException(\"Required view with id '").append(id).append("' for method '").append(method.name).append("' was not found. If this method binding is optional add '@Optional'.\");\n").append("    }\n");
            } else {
                builder.append("    if (view != null) {\n  ");
            }
            builder.append("    view.setOnClickListener(new View.OnClickListener() {\n").append("      @Override public void onClick(View view) {\n").append("        target.").append(method.name).append("(");
            if (method.type != null) {
                builder.append("(").append(method.type).append(") view");
            }
            builder.append(");\n").append("      }\n").append("    });\n");
            if (method.required) continue;
            builder.append("    }\n");
        }
        builder.append("  }\n\n");
        builder.append("  public static void reset(").append(this.targetClass).append(" target) {\n");
        if (this.parentInjector != null) {
            builder.append("    ").append(this.parentInjector).append(".reset(target);\n\n");
        }
        for (ViewId viewId : this.viewIdMap.values()) {
            for (FieldInjection fieldInjection : viewId.fields) {
                builder.append("    target.").append(fieldInjection.name).append(" = null;\n");
            }
        }
        builder.append("  }\n");
        builder.append("}\n");
        return builder.toString();
    }

    static class MethodInjection {
        final String name;
        final String type;
        final boolean required;

        MethodInjection(String name, String type, boolean required) {
            this.name = name;
            this.type = type;
            this.required = required;
        }
    }

    static class FieldInjection {
        final String name;
        final String type;
        final boolean required;

        FieldInjection(String name, String type, boolean required) {
            this.name = name;
            this.type = type;
            this.required = required;
        }
    }

    static class ViewId {
        final int id;
        final Set<FieldInjection> fields = new LinkedHashSet<FieldInjection>();
        MethodInjection method;

        ViewId(int id) {
            this.id = id;
        }
    }
}

