/*
 * Decompiled with CFR 0.152.
 */
package butterknife.internal;

import butterknife.InjectView;
import butterknife.OnCheckedChanged;
import butterknife.OnClick;
import butterknife.OnEditorAction;
import butterknife.OnFocusChanged;
import butterknife.OnItemClick;
import butterknife.OnItemLongClick;
import butterknife.OnLongClick;
import butterknife.Optional;
import butterknife.internal.Listener;
import butterknife.internal.ListenerClass;
import butterknife.internal.Parameter;
import butterknife.internal.ViewInjector;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public final class InjectViewProcessor
extends AbstractProcessor {
    public static final String SUFFIX = "$$ViewInjector";
    static final String VIEW_TYPE = "android.view.View";
    private static final Map<Class<?>, Listener> LISTENER_MAP = new LinkedHashMap();
    private static final List<Class<? extends Annotation>> LISTENERS = Arrays.asList(OnCheckedChanged.class, OnClick.class, OnEditorAction.class, OnFocusChanged.class, OnItemClick.class, OnItemLongClick.class, OnLongClick.class);
    private Elements elementUtils;
    private Types typeUtils;
    private Filer filer;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.elementUtils = env.getElementUtils();
        this.typeUtils = env.getTypeUtils();
        this.filer = env.getFiler();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> supportTypes = new LinkedHashSet<String>();
        supportTypes.add(InjectView.class.getCanonicalName());
        for (Class<? extends Annotation> listener : LISTENERS) {
            supportTypes.add(listener.getCanonicalName());
        }
        return supportTypes;
    }

    @Override
    public boolean process(Set<? extends TypeElement> elements, RoundEnvironment env) {
        Map<TypeElement, ViewInjector> targetClassMap = this.findAndParseTargets(env);
        for (Map.Entry<TypeElement, ViewInjector> entry : targetClassMap.entrySet()) {
            TypeElement typeElement = entry.getKey();
            ViewInjector viewInjector = entry.getValue();
            try {
                JavaFileObject jfo = this.filer.createSourceFile(viewInjector.getFqcn(), typeElement);
                Writer writer = jfo.openWriter();
                writer.write(viewInjector.brewJava());
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                this.error(typeElement, "Unable to write injector for type %s: %s", typeElement, e.getMessage());
            }
        }
        return true;
    }

    private Map<TypeElement, ViewInjector> findAndParseTargets(RoundEnvironment env) {
        LinkedHashMap<TypeElement, ViewInjector> targetClassMap = new LinkedHashMap<TypeElement, ViewInjector>();
        LinkedHashSet<TypeMirror> erasedTargetTypes = new LinkedHashSet<TypeMirror>();
        for (Element element : env.getElementsAnnotatedWith(InjectView.class)) {
            try {
                this.parseInjectView(element, targetClassMap, erasedTargetTypes);
            }
            catch (Exception e) {
                StringWriter stackTrace = new StringWriter();
                e.printStackTrace(new PrintWriter(stackTrace));
                this.error(element, "Unable to generate view injector for @InjectView.\n\n%s", stackTrace.toString());
            }
        }
        for (Class clazz : LISTENERS) {
            this.findAndParseListener(env, clazz, targetClassMap, erasedTargetTypes);
        }
        for (Map.Entry entry : targetClassMap.entrySet()) {
            String parentClassFqcn = this.findParentFqcn((TypeElement)entry.getKey(), erasedTargetTypes);
            if (parentClassFqcn == null) continue;
            ((ViewInjector)entry.getValue()).setParentInjector(parentClassFqcn + SUFFIX);
        }
        return targetClassMap;
    }

    private boolean isValidForGeneratedCode(Class<? extends Annotation> annotationClass, String targetThing, Element element) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.STATIC)) {
            this.error(element, "@%s %s must not be private or static. (%s.%s)", annotationClass.getSimpleName(), targetThing, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (enclosingElement.getKind() != ElementKind.CLASS) {
            this.error(enclosingElement, "@%s %s may only be contained in classes. (%s.%s)", annotationClass.getSimpleName(), targetThing, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (enclosingElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.error(enclosingElement, "@%s %s may not be contained in private classes. (%s.%s)", annotationClass.getSimpleName(), targetThing, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        return hasError;
    }

    private void parseInjectView(Element element, Map<TypeElement, ViewInjector> targetClassMap, Set<TypeMirror> erasedTargetTypes) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        if (!this.isSubtypeOfType(element.asType(), VIEW_TYPE)) {
            this.error(element, "@InjectView fields must extend from View (%s.%s).", enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (hasError |= this.isValidForGeneratedCode(InjectView.class, "fields", element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(InjectView.class).value();
        String type = ((Object)element.asType()).toString();
        boolean required = element.getAnnotation(Optional.class) == null;
        ViewInjector viewInjector = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
        viewInjector.addField(id, name, type, required);
        TypeMirror erasedTargetType = this.typeUtils.erasure(enclosingElement.asType());
        erasedTargetTypes.add(erasedTargetType);
    }

    private void findAndParseListener(RoundEnvironment env, Class<? extends Annotation> annotationClass, Map<TypeElement, ViewInjector> targetClassMap, Set<TypeMirror> erasedTargetTypes) {
        for (Element element : env.getElementsAnnotatedWith(annotationClass)) {
            try {
                this.parseListenerAnnotation(annotationClass, element, targetClassMap, erasedTargetTypes);
            }
            catch (Exception e) {
                StringWriter stackTrace = new StringWriter();
                e.printStackTrace(new PrintWriter(stackTrace));
                this.error(element, "Unable to generate view injector for @%s.\n\n%s", annotationClass.getSimpleName(), stackTrace.toString());
            }
        }
    }

    private void parseListenerAnnotation(Class<? extends Annotation> annotationClass, Element element, Map<TypeElement, ViewInjector> targetClassMap, Set<TypeMirror> erasedTargetTypes) throws Exception {
        List<? extends VariableElement> methodParameters;
        if (!(element instanceof ExecutableElement) || element.getKind() != ElementKind.METHOD) {
            this.error(element, "@%s annotation must be on a method.", annotationClass.getSimpleName());
            return;
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        Annotation annotation = element.getAnnotation(annotationClass);
        Method annotationValue = annotationClass.getDeclaredMethod("value", new Class[0]);
        if (annotationValue == null || annotationValue.getReturnType() != int[].class) {
            this.error(element, "@%s annotation lacks int[] value property. (%s.%s)", annotationClass, enclosingElement.getQualifiedName(), element.getSimpleName());
            return;
        }
        int[] ids = (int[])annotationValue.invoke((Object)annotation, new Object[0]);
        String name = executableElement.getSimpleName().toString();
        boolean required = element.getAnnotation(Optional.class) == null;
        boolean hasError = this.isValidForGeneratedCode(annotationClass, "methods", element);
        LinkedHashSet<Integer> seenIds = new LinkedHashSet<Integer>(ids.length);
        for (int id : ids) {
            if (seenIds.add(id)) continue;
            this.error(element, "@%s annotation for method contains duplicate ID %d. (%s.%s)", annotationClass.getSimpleName(), id, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        ListenerClass listenerClass = annotationClass.getAnnotation(ListenerClass.class);
        if (listenerClass == null) {
            this.error(element, "No @%s defined on @%s.", ListenerClass.class.getSimpleName(), annotationClass.getSimpleName());
            return;
        }
        Class<?> listenerClassClass = listenerClass.value();
        Listener listener = LISTENER_MAP.get(listenerClassClass);
        if (listener == null) {
            try {
                listener = Listener.from(listenerClassClass);
                LISTENER_MAP.put(listenerClassClass, listener);
            }
            catch (IllegalArgumentException e) {
                this.error(this.elementUtils.getTypeElement(annotationClass.getName()), "%s (%s on @%s)", e.getMessage(), listenerClassClass.getName(), annotationClass.getName());
                return;
            }
        }
        if ((methodParameters = executableElement.getParameters()).size() > listener.getParameterTypes().size()) {
            this.error(element, "@%s methods can have at most %s parameter(s). (%s.%s)", annotationClass.getSimpleName(), listener.getParameterTypes().size(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (!((Object)executableElement.getReturnType()).toString().equals(listener.getReturnType())) {
            this.error(element, "@%s methods must have a '%s' return type. (%s.%s)", annotationClass.getSimpleName(), listener.getReturnType(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (hasError) {
            return;
        }
        Parameter[] parameters = Parameter.NONE;
        if (!methodParameters.isEmpty()) {
            parameters = new Parameter[methodParameters.size()];
            BitSet methodParameterUsed = new BitSet(methodParameters.size());
            List<String> parameterTypes = listener.getParameterTypes();
            for (int i = 0; i < methodParameters.size(); ++i) {
                VariableElement methodParameter = methodParameters.get(i);
                TypeMirror methodParameterType = methodParameter.asType();
                for (int j = 0; j < parameterTypes.size(); ++j) {
                    if (methodParameterUsed.get(j) || !this.isSubtypeOfType(methodParameterType, parameterTypes.get(j))) continue;
                    parameters[i] = new Parameter(j, ((Object)methodParameterType).toString());
                    methodParameterUsed.set(j);
                    break;
                }
                if (parameters[i] != null) continue;
                StringBuilder builder = new StringBuilder();
                builder.append("Unable to match @").append(annotationClass.getSimpleName()).append(" method arguments. (").append(enclosingElement.getQualifiedName()).append('.').append(element.getSimpleName()).append(')');
                for (int j = 0; j < parameters.length; ++j) {
                    Parameter parameter = parameters[j];
                    builder.append("\n\n  Parameter #").append(j + 1).append(": ").append(((Object)methodParameters.get(j).asType()).toString()).append("\n    ");
                    if (parameter == null) {
                        builder.append("did not match any listener parameters");
                        continue;
                    }
                    builder.append("matched listener parameter #").append(parameter.getListenerPosition() + 1).append(": ").append(parameter.getType());
                }
                builder.append("\n\nMethods may have up to ").append(listener.getParameterTypes().size()).append(" parameter(s):\n");
                for (String parameterType : listener.getParameterTypes()) {
                    builder.append("\n  ").append(parameterType);
                }
                builder.append("\n\nThese may be listed in any order but will be searched for from top to bottom.");
                this.error(executableElement, builder.toString(), new Object[0]);
                return;
            }
        }
        ViewInjector viewInjector = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
        for (int id : ids) {
            if (viewInjector.addMethod(id, listener, name, Arrays.asList(parameters), required)) continue;
            this.error(element, "Multiple @%s methods declared for ID %s in %s.", annotationClass.getSimpleName(), id, enclosingElement.getQualifiedName());
            return;
        }
        TypeMirror erasedTargetType = this.typeUtils.erasure(enclosingElement.asType());
        erasedTargetTypes.add(erasedTargetType);
    }

    private boolean isSubtypeOfType(TypeMirror typeMirror, String otherType) {
        Element element;
        if (otherType.equals(((Object)typeMirror).toString())) {
            return true;
        }
        if (!(typeMirror instanceof DeclaredType)) {
            return false;
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.size() > 0) {
            StringBuilder typeString = new StringBuilder(declaredType.asElement().toString());
            typeString.append('<');
            for (int i = 0; i < typeArguments.size(); ++i) {
                if (i > 0) {
                    typeString.append(',');
                }
                typeString.append('?');
            }
            typeString.append('>');
            if (typeString.toString().equals(otherType)) {
                return true;
            }
        }
        if (!((element = declaredType.asElement()) instanceof TypeElement)) {
            return false;
        }
        TypeElement typeElement = (TypeElement)element;
        TypeMirror superType = typeElement.getSuperclass();
        if (this.isSubtypeOfType(superType, otherType)) {
            return true;
        }
        for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
            if (!this.isSubtypeOfType(typeMirror2, otherType)) continue;
            return true;
        }
        return false;
    }

    private ViewInjector getOrCreateTargetClass(Map<TypeElement, ViewInjector> targetClassMap, TypeElement enclosingElement) {
        ViewInjector viewInjector = targetClassMap.get(enclosingElement);
        if (viewInjector == null) {
            String targetType = enclosingElement.getQualifiedName().toString();
            String classPackage = this.getPackageName(enclosingElement);
            String className = InjectViewProcessor.getClassName(enclosingElement, classPackage) + SUFFIX;
            viewInjector = new ViewInjector(classPackage, className, targetType);
            targetClassMap.put(enclosingElement, viewInjector);
        }
        return viewInjector;
    }

    private static String getClassName(TypeElement type, String packageName) {
        int packageLen = packageName.length() + 1;
        return type.getQualifiedName().toString().substring(packageLen).replace('.', '$');
    }

    private String findParentFqcn(TypeElement typeElement, Set<TypeMirror> parents) {
        TypeMirror type;
        do {
            if ((type = typeElement.getSuperclass()).getKind() == TypeKind.NONE) {
                return null;
            }
            typeElement = (TypeElement)((DeclaredType)type).asElement();
        } while (!this.containsTypeMirror(parents, type));
        String packageName = this.getPackageName(typeElement);
        return packageName + "." + InjectViewProcessor.getClassName(typeElement, packageName);
    }

    private boolean containsTypeMirror(Collection<TypeMirror> mirrors, TypeMirror query) {
        query = this.typeUtils.erasure(query);
        for (TypeMirror mirror : mirrors) {
            if (!this.typeUtils.isSameType(mirror, query)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void error(Element element, String message, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(message, args), element);
    }

    private String getPackageName(TypeElement type) {
        return this.elementUtils.getPackageOf(type).getQualifiedName().toString();
    }
}

