/*
 * Decompiled with CFR 0.152.
 */
package butterknife.internal;

import butterknife.internal.Binding;
import butterknife.internal.FieldBinding;
import butterknife.internal.Listener;
import butterknife.internal.MethodBinding;
import butterknife.internal.Parameter;
import butterknife.internal.ViewInjection;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class ViewInjector {
    private final Map<Integer, ViewInjection> viewIdMap = new LinkedHashMap<Integer, ViewInjection>();
    private final String classPackage;
    private final String className;
    private final String targetClass;
    private String parentInjector;

    ViewInjector(String classPackage, String className, String targetClass) {
        this.classPackage = classPackage;
        this.className = className;
        this.targetClass = targetClass;
    }

    void addField(int id, String name, String type, boolean required) {
        this.getOrCreateViewBinding(id).addFieldBinding(new FieldBinding(name, type, required));
    }

    boolean addMethod(int id, Listener listener, String name, List<Parameter> parameters, boolean required) {
        try {
            this.getOrCreateViewBinding(id).addMethodBinding(listener, new MethodBinding(name, parameters, required));
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    void setParentInjector(String parentInjector) {
        this.parentInjector = parentInjector;
    }

    private ViewInjection getOrCreateViewBinding(int id) {
        ViewInjection viewId = this.viewIdMap.get(id);
        if (viewId == null) {
            viewId = new ViewInjection(id);
            this.viewIdMap.put(id, viewId);
        }
        return viewId;
    }

    String getFqcn() {
        return this.classPackage + "." + this.className;
    }

    String brewJava() {
        StringBuilder builder = new StringBuilder();
        builder.append("// Generated code from Butter Knife. Do not modify!\n");
        builder.append("package ").append(this.classPackage).append(";\n\n");
        builder.append("import android.view.View;\n");
        builder.append("import butterknife.ButterKnife.Finder;\n\n");
        builder.append("public class ").append(this.className).append(" {\n");
        this.emitInject(builder);
        builder.append('\n');
        this.emitReset(builder);
        builder.append("}\n");
        return builder.toString();
    }

    private void emitInject(StringBuilder builder) {
        builder.append("  public static void inject(Finder finder, final ").append(this.targetClass).append(" target, Object source) {\n");
        if (this.parentInjector != null) {
            builder.append("    ").append(this.parentInjector).append(".inject(finder, target, source);\n\n");
        }
        builder.append("    View view;\n");
        for (ViewInjection injection : this.viewIdMap.values()) {
            this.emitViewInjection(builder, injection);
        }
        builder.append("  }\n");
    }

    private void emitViewInjection(StringBuilder builder, ViewInjection injection) {
        builder.append("    view = finder.findById(source, ").append(injection.getId()).append(");\n");
        List<Binding> requiredBindings = injection.getRequiredBindings();
        if (!requiredBindings.isEmpty()) {
            builder.append("    if (view == null) {\n").append("      throw new IllegalStateException(\"Required view with id '").append(injection.getId()).append("' for ");
            ViewInjector.emitHumanDescription(builder, requiredBindings);
            builder.append(" was not found. If this view is optional add '@Optional' annotation.\");\n").append("    }\n");
        }
        this.emitFieldBindings(builder, injection);
        this.emitMethodBindings(builder, injection);
    }

    private void emitFieldBindings(StringBuilder builder, ViewInjection injection) {
        Collection<FieldBinding> fieldBindings = injection.getFieldBindings();
        if (fieldBindings.isEmpty()) {
            return;
        }
        for (FieldBinding fieldBinding : fieldBindings) {
            builder.append("    target.").append(fieldBinding.getName()).append(" = ");
            ViewInjector.emitCastIfNeeded(builder, fieldBinding.getType());
            builder.append("view;\n");
        }
    }

    private void emitMethodBindings(StringBuilder builder, ViewInjection injection) {
        Map<Listener, MethodBinding> methodBindings = injection.getMethodBindings();
        if (methodBindings.isEmpty()) {
            return;
        }
        String extraIndent = "";
        boolean needsNullChecked = injection.getRequiredBindings().isEmpty();
        if (needsNullChecked) {
            builder.append("    if (view != null) {\n");
            extraIndent = "  ";
        }
        for (Map.Entry<Listener, MethodBinding> entry : methodBindings.entrySet()) {
            Listener listener = entry.getKey();
            MethodBinding methodBinding = entry.getValue();
            boolean needsCast = !"android.view.View".equals(listener.getOwnerType());
            builder.append(extraIndent).append("    ");
            if (needsCast) {
                builder.append("((").append(listener.getOwnerType()).append(") ");
            }
            builder.append("view");
            if (needsCast) {
                builder.append(')');
            }
            builder.append('.').append(listener.getSetterName()).append("(\n");
            builder.append(extraIndent).append("      new ").append(listener.getType()).append("() {\n");
            builder.append(extraIndent).append("        @Override public ").append(listener.getReturnType()).append(' ').append(listener.getMethodName()).append("(\n");
            List<String> parameterTypes = listener.getParameterTypes();
            int count = parameterTypes.size();
            for (int i = 0; i < count; ++i) {
                builder.append(extraIndent).append("          ").append(parameterTypes.get(i)).append(" p").append(i);
                if (i < count - 1) {
                    builder.append(',');
                }
                builder.append('\n');
            }
            builder.append(extraIndent).append("        ) {\n");
            builder.append(extraIndent).append("          ");
            if (!"void".equals(listener.getReturnType())) {
                builder.append("return ");
            }
            builder.append("target.").append(methodBinding.getName()).append('(');
            List<Parameter> parameters = methodBinding.getParameters();
            List<String> listenerParameters = listener.getParameterTypes();
            int count2 = parameters.size();
            for (int i = 0; i < count2; ++i) {
                Parameter parameter = parameters.get(i);
                int listenerPosition = parameter.getListenerPosition();
                ViewInjector.emitCastIfNeeded(builder, listenerParameters.get(listenerPosition), parameter.getType());
                builder.append('p').append(listenerPosition);
                if (i >= count2 - 1) continue;
                builder.append(", ");
            }
            builder.append(");\n");
            builder.append(extraIndent).append("        }\n");
            builder.append(extraIndent).append("      });\n");
        }
        if (needsNullChecked) {
            builder.append("    }\n");
        }
    }

    private void emitReset(StringBuilder builder) {
        builder.append("  public static void reset(").append(this.targetClass).append(" target) {\n");
        if (this.parentInjector != null) {
            builder.append("    ").append(this.parentInjector).append(".reset(target);\n\n");
        }
        for (ViewInjection injection : this.viewIdMap.values()) {
            for (FieldBinding fieldBinding : injection.getFieldBindings()) {
                builder.append("    target.").append(fieldBinding.getName()).append(" = null;\n");
            }
        }
        builder.append("  }\n");
    }

    static void emitCastIfNeeded(StringBuilder builder, String viewType) {
        ViewInjector.emitCastIfNeeded(builder, "android.view.View", viewType);
    }

    static void emitCastIfNeeded(StringBuilder builder, String sourceType, String destinationType) {
        if (!sourceType.equals(destinationType)) {
            builder.append('(').append(destinationType).append(") ");
        }
    }

    static void emitHumanDescription(StringBuilder builder, List<Binding> bindings) {
        switch (bindings.size()) {
            case 1: {
                builder.append(bindings.get(0).getDescription());
                break;
            }
            case 2: {
                builder.append(bindings.get(0).getDescription()).append(" and ").append(bindings.get(1).getDescription());
                break;
            }
            default: {
                int count = bindings.size();
                for (int i = 0; i < count; ++i) {
                    Binding requiredField = bindings.get(i);
                    if (i != 0) {
                        builder.append(", ");
                    }
                    if (i == count - 1) {
                        builder.append("and ");
                    }
                    builder.append(requiredField.getDescription());
                }
            }
        }
    }
}

