/*
 * Decompiled with CFR 0.152.
 */
package butterknife.internal;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

final class Listener {
    private final String ownerType;
    private final String setterName;
    private final String type;
    private final String returnType;
    private final String methodName;
    private final List<String> parameterTypes;

    static Listener from(TypeElement listenerElement, Types typeUtils) {
        List<? extends Element> listenerEnclosedElements = listenerElement.getEnclosedElements();
        if (listenerEnclosedElements.size() != 1) {
            throw new IllegalArgumentException(listenerElement.getSimpleName() + " is not a single-method interface");
        }
        ExecutableElement listenerMethod = (ExecutableElement)listenerEnclosedElements.get(0);
        TypeMirror ownerTypeMirror = listenerElement.getEnclosingElement().asType();
        ownerTypeMirror = typeUtils.erasure(ownerTypeMirror);
        String ownerType = ((Object)ownerTypeMirror).toString();
        String setterName = "set" + listenerElement.getSimpleName();
        String type = listenerElement.getQualifiedName().toString();
        String methodName = listenerMethod.getSimpleName().toString();
        String returnType = ((Object)listenerMethod.getReturnType()).toString();
        List<? extends VariableElement> listenerParameterTypes = listenerMethod.getParameters();
        ArrayList<String> parameterTypes = new ArrayList<String>(listenerParameterTypes.size());
        for (VariableElement variableElement : listenerParameterTypes) {
            String parameterType = ((Object)variableElement.asType()).toString();
            if (parameterType.startsWith("java.lang.") && !parameterType.substring(10).contains(".")) {
                parameterType = parameterType.substring(10);
            }
            parameterTypes.add(parameterType);
        }
        return new Listener(ownerType, setterName, type, returnType, methodName, parameterTypes);
    }

    private Listener(String ownerType, String setterName, String type, String returnType, String methodName, List<String> parameterTypes) {
        this.ownerType = ownerType;
        this.setterName = setterName;
        this.type = type;
        this.returnType = returnType;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public String getSetterName() {
        return this.setterName;
    }

    String getType() {
        return this.type;
    }

    String getReturnType() {
        return this.returnType;
    }

    String getMethodName() {
        return this.methodName;
    }

    List<String> getParameterTypes() {
        return this.parameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Listener listener = (Listener)o;
        return this.methodName.equals(listener.methodName) && this.ownerType.equals(listener.ownerType) && ((Object)this.parameterTypes).equals(listener.parameterTypes) && this.returnType.equals(listener.returnType) && this.setterName.equals(listener.setterName) && this.type.equals(listener.type);
    }

    public int hashCode() {
        int result = this.ownerType.hashCode();
        result = 31 * result + this.setterName.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.returnType.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + ((Object)this.parameterTypes).hashCode();
        return result;
    }
}

