/*
 * Decompiled with CFR 0.152.
 */
package butterknife.internal;

import butterknife.InjectView;
import butterknife.InjectViews;
import butterknife.OnCheckedChanged;
import butterknife.OnClick;
import butterknife.OnEditorAction;
import butterknife.OnFocusChange;
import butterknife.OnItemClick;
import butterknife.OnItemLongClick;
import butterknife.OnItemSelected;
import butterknife.OnLongClick;
import butterknife.OnPageChange;
import butterknife.OnTextChanged;
import butterknife.Optional;
import butterknife.internal.CollectionBinding;
import butterknife.internal.ListenerBinding;
import butterknife.internal.ListenerClass;
import butterknife.internal.ListenerMethod;
import butterknife.internal.Parameter;
import butterknife.internal.ViewBinding;
import butterknife.internal.ViewInjector;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public final class ButterKnifeProcessor
extends AbstractProcessor {
    public static final String SUFFIX = "$$ViewInjector";
    static final String VIEW_TYPE = "android.view.View";
    private static final String LIST_TYPE = List.class.getCanonicalName();
    private static final List<Class<? extends Annotation>> LISTENERS = Arrays.asList(OnCheckedChanged.class, OnClick.class, OnEditorAction.class, OnFocusChange.class, OnItemClick.class, OnItemLongClick.class, OnItemSelected.class, OnLongClick.class, OnPageChange.class, OnTextChanged.class);
    private Elements elementUtils;
    private Types typeUtils;
    private Filer filer;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.elementUtils = env.getElementUtils();
        this.typeUtils = env.getTypeUtils();
        this.filer = env.getFiler();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> supportTypes = new LinkedHashSet<String>();
        supportTypes.add(InjectView.class.getCanonicalName());
        supportTypes.add(InjectViews.class.getCanonicalName());
        for (Class<? extends Annotation> listener : LISTENERS) {
            supportTypes.add(listener.getCanonicalName());
        }
        return supportTypes;
    }

    @Override
    public boolean process(Set<? extends TypeElement> elements, RoundEnvironment env) {
        Map<TypeElement, ViewInjector> targetClassMap = this.findAndParseTargets(env);
        for (Map.Entry<TypeElement, ViewInjector> entry : targetClassMap.entrySet()) {
            TypeElement typeElement = entry.getKey();
            ViewInjector viewInjector = entry.getValue();
            try {
                JavaFileObject jfo = this.filer.createSourceFile(viewInjector.getFqcn(), typeElement);
                Writer writer = jfo.openWriter();
                writer.write(viewInjector.brewJava());
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                this.error(typeElement, "Unable to write injector for type %s: %s", typeElement, e.getMessage());
            }
        }
        return true;
    }

    private Map<TypeElement, ViewInjector> findAndParseTargets(RoundEnvironment env) {
        StringWriter stackTrace;
        LinkedHashMap<TypeElement, ViewInjector> targetClassMap = new LinkedHashMap<TypeElement, ViewInjector>();
        LinkedHashSet<String> erasedTargetNames = new LinkedHashSet<String>();
        for (Element element : env.getElementsAnnotatedWith(InjectView.class)) {
            try {
                this.parseInjectView(element, targetClassMap, erasedTargetNames);
            }
            catch (Exception e) {
                stackTrace = new StringWriter();
                e.printStackTrace(new PrintWriter(stackTrace));
                this.error(element, "Unable to generate view injector for @InjectView.\n\n%s", stackTrace);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(InjectViews.class)) {
            try {
                this.parseInjectViews(element, targetClassMap, erasedTargetNames);
            }
            catch (Exception e) {
                stackTrace = new StringWriter();
                e.printStackTrace(new PrintWriter(stackTrace));
                this.error(element, "Unable to generate view injector for @InjectViews.\n\n%s", stackTrace);
            }
        }
        for (Class clazz : LISTENERS) {
            this.findAndParseListener(env, clazz, targetClassMap, erasedTargetNames);
        }
        for (Map.Entry entry : targetClassMap.entrySet()) {
            String parentClassFqcn = this.findParentFqcn((TypeElement)entry.getKey(), erasedTargetNames);
            if (parentClassFqcn == null) continue;
            ((ViewInjector)entry.getValue()).setParentInjector(parentClassFqcn + SUFFIX);
        }
        return targetClassMap;
    }

    private boolean isValidForGeneratedCode(Class<? extends Annotation> annotationClass, String targetThing, Element element) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.STATIC)) {
            this.error(element, "@%s %s must not be private or static. (%s.%s)", annotationClass.getSimpleName(), targetThing, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (enclosingElement.getKind() != ElementKind.CLASS) {
            this.error(enclosingElement, "@%s %s may only be contained in classes. (%s.%s)", annotationClass.getSimpleName(), targetThing, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (enclosingElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.error(enclosingElement, "@%s %s may not be contained in private classes. (%s.%s)", annotationClass.getSimpleName(), targetThing, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        return hasError;
    }

    private void parseInjectView(Element element, Map<TypeElement, ViewInjector> targetClassMap, Set<String> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        TypeMirror elementType = element.asType();
        if (elementType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)elementType;
            elementType = typeVariable.getUpperBound();
        }
        if (!this.isSubtypeOfType(elementType, VIEW_TYPE)) {
            this.error(element, "@InjectView fields must extend from View. (%s.%s)", enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isValidForGeneratedCode(InjectView.class, "fields", element);
        if (element.getAnnotation(InjectViews.class) != null) {
            this.error(element, "Only one of @InjectView and @InjectViews is allowed. (%s.%s)", enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (hasError) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(InjectView.class).value();
        String type = elementType.toString();
        boolean required = element.getAnnotation(Optional.class) == null;
        ViewInjector viewInjector = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
        ViewBinding binding = new ViewBinding(name, type, required);
        viewInjector.addView(id, binding);
        erasedTargetNames.add(enclosingElement.toString());
    }

    private void parseInjectViews(Element element, Map<TypeElement, ViewInjector> targetClassMap, Set<String> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        TypeMirror elementType = element.asType();
        TypeMirror erasedType = this.typeUtils.erasure(elementType);
        TypeMirror viewType = null;
        CollectionBinding.Kind kind = null;
        if (elementType.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)elementType;
            viewType = arrayType.getComponentType();
            kind = CollectionBinding.Kind.ARRAY;
        } else if (LIST_TYPE.equals(erasedType.toString())) {
            DeclaredType declaredType = (DeclaredType)elementType;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments.size() != 1) {
                this.error(element, "@InjectViews List must have a generic component. (%s.%s)", enclosingElement.getQualifiedName(), element.getSimpleName());
                hasError = true;
            } else {
                viewType = typeArguments.get(0);
            }
            kind = CollectionBinding.Kind.LIST;
        } else {
            this.error(element, "@InjectViews must be a List or array. (%s.%s)", enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (viewType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)viewType;
            viewType = typeVariable.getUpperBound();
        }
        if (viewType != null && !this.isSubtypeOfType(viewType, VIEW_TYPE)) {
            this.error(element, "@InjectViews type must extend from View. (%s.%s)", enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (hasError |= this.isValidForGeneratedCode(InjectViews.class, "fields", element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int[] ids = element.getAnnotation(InjectViews.class).value();
        if (ids.length == 0) {
            this.error(element, "@InjectViews must specify at least one ID. (%s.%s)", enclosingElement.getQualifiedName(), element.getSimpleName());
            return;
        }
        assert (viewType != null);
        String type = viewType.toString();
        ViewInjector viewInjector = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
        CollectionBinding binding = new CollectionBinding(name, type, kind);
        viewInjector.addCollection(ids, binding);
        erasedTargetNames.add(enclosingElement.toString());
    }

    private void findAndParseListener(RoundEnvironment env, Class<? extends Annotation> annotationClass, Map<TypeElement, ViewInjector> targetClassMap, Set<String> erasedTargetNames) {
        for (Element element : env.getElementsAnnotatedWith(annotationClass)) {
            try {
                this.parseListenerAnnotation(annotationClass, element, targetClassMap, erasedTargetNames);
            }
            catch (Exception e) {
                StringWriter stackTrace = new StringWriter();
                e.printStackTrace(new PrintWriter(stackTrace));
                this.error(element, "Unable to generate view injector for @%s.\n\n%s", annotationClass.getSimpleName(), stackTrace.toString());
            }
        }
    }

    private void parseListenerAnnotation(Class<? extends Annotation> annotationClass, Element element, Map<TypeElement, ViewInjector> targetClassMap, Set<String> erasedTargetNames) throws Exception {
        TypeMirror returnType;
        ListenerMethod method;
        if (!(element instanceof ExecutableElement) || element.getKind() != ElementKind.METHOD) {
            throw new IllegalStateException(String.format("@%s annotation must be on a method.", annotationClass.getSimpleName()));
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        Annotation annotation = element.getAnnotation(annotationClass);
        Method annotationValue = annotationClass.getDeclaredMethod("value", new Class[0]);
        if (annotationValue.getReturnType() != int[].class) {
            throw new IllegalStateException(String.format("@%s annotation value() type not int[].", annotationClass));
        }
        int[] ids = (int[])annotationValue.invoke((Object)annotation, new Object[0]);
        String name = executableElement.getSimpleName().toString();
        boolean required = element.getAnnotation(Optional.class) == null;
        boolean hasError = this.isValidForGeneratedCode(annotationClass, "methods", element);
        LinkedHashSet<Integer> seenIds = new LinkedHashSet<Integer>();
        for (int id : ids) {
            if (seenIds.add(id)) continue;
            this.error(element, "@%s annotation for method contains duplicate ID %d. (%s.%s)", annotationClass.getSimpleName(), id, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        ListenerClass listener = annotationClass.getAnnotation(ListenerClass.class);
        if (listener == null) {
            throw new IllegalStateException(String.format("No @%s defined on @%s.", ListenerClass.class.getSimpleName(), annotationClass.getSimpleName()));
        }
        ListenerMethod[] methods = listener.method();
        if (methods.length > 1) {
            throw new IllegalStateException(String.format("Multiple listener methods specified on @%s.", annotationClass.getSimpleName()));
        }
        if (methods.length == 1) {
            if (listener.callbacks() != ListenerClass.NONE.class) {
                throw new IllegalStateException(String.format("Both method() and callback() defined on @%s.", annotationClass.getSimpleName()));
            }
            method = methods[0];
        } else {
            Method annotationCallback = annotationClass.getDeclaredMethod("callback", new Class[0]);
            Enum callback = (Enum)annotationCallback.invoke((Object)annotation, new Object[0]);
            Field callbackField = callback.getDeclaringClass().getField(callback.name());
            method = callbackField.getAnnotation(ListenerMethod.class);
            if (method == null) {
                throw new IllegalStateException(String.format("No @%s defined on @%s's %s.%s.", ListenerMethod.class.getSimpleName(), annotationClass.getSimpleName(), callback.getDeclaringClass().getSimpleName(), callback.name()));
            }
        }
        List<? extends VariableElement> methodParameters = executableElement.getParameters();
        if (methodParameters.size() > method.parameters().length) {
            this.error(element, "@%s methods can have at most %s parameter(s). (%s.%s)", annotationClass.getSimpleName(), method.parameters().length, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if ((returnType = executableElement.getReturnType()) instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)returnType;
            returnType = typeVariable.getUpperBound();
        }
        if (!returnType.toString().equals(method.returnType())) {
            this.error(element, "@%s methods must have a '%s' return type. (%s.%s)", annotationClass.getSimpleName(), method.returnType(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (hasError) {
            return;
        }
        Parameter[] parameters = Parameter.NONE;
        if (!methodParameters.isEmpty()) {
            parameters = new Parameter[methodParameters.size()];
            BitSet methodParameterUsed = new BitSet(methodParameters.size());
            String[] parameterTypes = method.parameters();
            for (int i = 0; i < methodParameters.size(); ++i) {
                VariableElement methodParameter = methodParameters.get(i);
                TypeMirror methodParameterType = methodParameter.asType();
                if (methodParameterType instanceof TypeVariable) {
                    TypeVariable typeVariable = (TypeVariable)methodParameterType;
                    methodParameterType = typeVariable.getUpperBound();
                }
                for (int j = 0; j < parameterTypes.length; ++j) {
                    if (methodParameterUsed.get(j) || !this.isSubtypeOfType(methodParameterType, parameterTypes[j])) continue;
                    parameters[i] = new Parameter(j, methodParameterType.toString());
                    methodParameterUsed.set(j);
                    break;
                }
                if (parameters[i] != null) continue;
                StringBuilder builder = new StringBuilder();
                builder.append("Unable to match @").append(annotationClass.getSimpleName()).append(" method arguments. (").append(enclosingElement.getQualifiedName()).append('.').append(element.getSimpleName()).append(')');
                for (int j = 0; j < parameters.length; ++j) {
                    Parameter parameter = parameters[j];
                    builder.append("\n\n  Parameter #").append(j + 1).append(": ").append(methodParameters.get(j).asType().toString()).append("\n    ");
                    if (parameter == null) {
                        builder.append("did not match any listener parameters");
                        continue;
                    }
                    builder.append("matched listener parameter #").append(parameter.getListenerPosition() + 1).append(": ").append(parameter.getType());
                }
                builder.append("\n\nMethods may have up to ").append(method.parameters().length).append(" parameter(s):\n");
                for (String parameterType : method.parameters()) {
                    builder.append("\n  ").append(parameterType);
                }
                builder.append("\n\nThese may be listed in any order but will be searched for from top to bottom.");
                this.error(executableElement, builder.toString(), new Object[0]);
                return;
            }
        }
        ListenerBinding binding = new ListenerBinding(name, Arrays.asList(parameters), required);
        ViewInjector viewInjector = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
        for (int id : ids) {
            if (viewInjector.addListener(id, listener, method, binding)) continue;
            this.error(element, "Multiple @%s methods declared for ID %s in %s.", annotationClass.getSimpleName(), id, enclosingElement.getQualifiedName());
            return;
        }
        erasedTargetNames.add(enclosingElement.toString());
    }

    private boolean isSubtypeOfType(TypeMirror typeMirror, String otherType) {
        Element element;
        if (otherType.equals(typeMirror.toString())) {
            return true;
        }
        if (!(typeMirror instanceof DeclaredType)) {
            return false;
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.size() > 0) {
            StringBuilder typeString = new StringBuilder(declaredType.asElement().toString());
            typeString.append('<');
            for (int i = 0; i < typeArguments.size(); ++i) {
                if (i > 0) {
                    typeString.append(',');
                }
                typeString.append('?');
            }
            typeString.append('>');
            if (typeString.toString().equals(otherType)) {
                return true;
            }
        }
        if (!((element = declaredType.asElement()) instanceof TypeElement)) {
            return false;
        }
        TypeElement typeElement = (TypeElement)element;
        TypeMirror superType = typeElement.getSuperclass();
        if (this.isSubtypeOfType(superType, otherType)) {
            return true;
        }
        for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
            if (!this.isSubtypeOfType(typeMirror2, otherType)) continue;
            return true;
        }
        return false;
    }

    private ViewInjector getOrCreateTargetClass(Map<TypeElement, ViewInjector> targetClassMap, TypeElement enclosingElement) {
        ViewInjector viewInjector = targetClassMap.get(enclosingElement);
        if (viewInjector == null) {
            String targetType = enclosingElement.getQualifiedName().toString();
            String classPackage = this.getPackageName(enclosingElement);
            String className = ButterKnifeProcessor.getClassName(enclosingElement, classPackage) + SUFFIX;
            viewInjector = new ViewInjector(classPackage, className, targetType);
            targetClassMap.put(enclosingElement, viewInjector);
        }
        return viewInjector;
    }

    private static String getClassName(TypeElement type, String packageName) {
        int packageLen = packageName.length() + 1;
        return type.getQualifiedName().toString().substring(packageLen).replace('.', '$');
    }

    private String findParentFqcn(TypeElement typeElement, Set<String> parents) {
        TypeMirror type;
        do {
            if ((type = typeElement.getSuperclass()).getKind() != TypeKind.NONE) continue;
            return null;
        } while (!parents.contains((typeElement = (TypeElement)((DeclaredType)type).asElement()).toString()));
        String packageName = this.getPackageName(typeElement);
        return packageName + "." + ButterKnifeProcessor.getClassName(typeElement, packageName);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void error(Element element, String message, Object ... args) {
        if (args.length > 0) {
            message = String.format(message, args);
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    private String getPackageName(TypeElement type) {
        return this.elementUtils.getPackageOf(type).getQualifiedName().toString();
    }
}

