/*
 * Decompiled with CFR 0.152.
 */
package butterknife.internal;

import butterknife.internal.Binding;
import butterknife.internal.CollectionBinding;
import butterknife.internal.ListenerBinding;
import butterknife.internal.ListenerClass;
import butterknife.internal.ListenerMethod;
import butterknife.internal.Parameter;
import butterknife.internal.ViewBinding;
import butterknife.internal.ViewInjection;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class ViewInjector {
    private final Map<Integer, ViewInjection> viewIdMap = new LinkedHashMap<Integer, ViewInjection>();
    private final Map<CollectionBinding, int[]> collectionBindings = new LinkedHashMap<CollectionBinding, int[]>();
    private final String classPackage;
    private final String className;
    private final String targetClass;
    private String parentInjector;

    ViewInjector(String classPackage, String className, String targetClass) {
        this.classPackage = classPackage;
        this.className = className;
        this.targetClass = targetClass;
    }

    void addView(int id, ViewBinding binding) {
        this.getOrCreateViewInjection(id).addViewBinding(binding);
    }

    boolean addListener(int id, ListenerClass listener, ListenerMethod method, ListenerBinding binding) {
        ViewInjection viewInjection = this.getOrCreateViewInjection(id);
        if (viewInjection.hasListenerBinding(listener, method)) {
            return false;
        }
        viewInjection.addListenerBinding(listener, method, binding);
        return true;
    }

    void addCollection(int[] ids, CollectionBinding binding) {
        this.collectionBindings.put(binding, ids);
    }

    void setParentInjector(String parentInjector) {
        this.parentInjector = parentInjector;
    }

    private ViewInjection getOrCreateViewInjection(int id) {
        ViewInjection viewId = this.viewIdMap.get(id);
        if (viewId == null) {
            viewId = new ViewInjection(id);
            this.viewIdMap.put(id, viewId);
        }
        return viewId;
    }

    String getFqcn() {
        return this.classPackage + "." + this.className;
    }

    String brewJava() {
        StringBuilder builder = new StringBuilder();
        builder.append("// Generated code from Butter Knife. Do not modify!\n");
        builder.append("package ").append(this.classPackage).append(";\n\n");
        builder.append("import android.view.View;\n");
        builder.append("import butterknife.ButterKnife.Finder;\n\n");
        builder.append("public class ").append(this.className).append(" {\n");
        this.emitInject(builder);
        builder.append('\n');
        this.emitReset(builder);
        builder.append("}\n");
        return builder.toString();
    }

    private void emitInject(StringBuilder builder) {
        builder.append("  public static void inject(Finder finder, final ").append(this.targetClass).append(" target, Object source) {\n");
        if (this.parentInjector != null) {
            builder.append("    ").append(this.parentInjector).append(".inject(finder, target, source);\n\n");
        }
        builder.append("    View view;\n");
        for (ViewInjection viewInjection : this.viewIdMap.values()) {
            this.emitViewInjection(builder, viewInjection);
        }
        for (Map.Entry entry : this.collectionBindings.entrySet()) {
            this.emitCollectionBinding(builder, (CollectionBinding)entry.getKey(), (int[])entry.getValue());
        }
        builder.append("  }\n");
    }

    private void emitCollectionBinding(StringBuilder builder, CollectionBinding binding, int[] ids) {
        builder.append("    target.").append(binding.getName()).append(" = ");
        switch (binding.getKind()) {
            case ARRAY: {
                builder.append("Finder.arrayOf(");
                break;
            }
            case LIST: {
                builder.append("Finder.listOf(");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown kind: " + (Object)((Object)binding.getKind()));
            }
        }
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append("\n        ");
            ViewInjector.emitCastIfNeeded(builder, binding.getType());
            builder.append("finder.findRequiredView(source, ").append(ids[i]).append(", \"").append(binding.getName()).append("\")");
        }
        builder.append("\n    );");
    }

    private void emitViewInjection(StringBuilder builder, ViewInjection injection) {
        builder.append("    view = ");
        List<Binding> requiredBindings = injection.getRequiredBindings();
        if (requiredBindings.isEmpty()) {
            builder.append("finder.findOptionalView(source, ").append(injection.getId()).append(");\n");
        } else {
            builder.append("finder.findRequiredView(source, ").append(injection.getId()).append(", \"");
            ViewInjector.emitHumanDescription(builder, requiredBindings);
            builder.append("\");\n");
        }
        this.emitViewBindings(builder, injection);
        this.emitListenerBindings(builder, injection);
    }

    private void emitViewBindings(StringBuilder builder, ViewInjection injection) {
        Collection<ViewBinding> viewBindings = injection.getViewBindings();
        if (viewBindings.isEmpty()) {
            return;
        }
        for (ViewBinding viewBinding : viewBindings) {
            builder.append("    target.").append(viewBinding.getName()).append(" = ");
            ViewInjector.emitCastIfNeeded(builder, viewBinding.getType());
            builder.append("view;\n");
        }
    }

    private void emitListenerBindings(StringBuilder builder, ViewInjection injection) {
        Map<ListenerClass, Map<ListenerMethod, ListenerBinding>> bindings = injection.getListenerBindings();
        if (bindings.isEmpty()) {
            return;
        }
        String extraIndent = "";
        boolean needsNullChecked = injection.getRequiredBindings().isEmpty();
        if (needsNullChecked) {
            builder.append("    if (view != null) {\n");
            extraIndent = "  ";
        }
        for (Map.Entry<ListenerClass, Map<ListenerMethod, ListenerBinding>> e : bindings.entrySet()) {
            ListenerClass listener = e.getKey();
            Map<ListenerMethod, ListenerBinding> methodBindings = e.getValue();
            boolean needsCast = !"android.view.View".equals(listener.targetType());
            builder.append(extraIndent).append("    ");
            if (needsCast) {
                builder.append("((").append(listener.targetType());
                if (listener.genericArguments() > 0) {
                    builder.append('<');
                    for (int i = 0; i < listener.genericArguments(); ++i) {
                        if (i > 0) {
                            builder.append(", ");
                        }
                        builder.append('?');
                    }
                    builder.append('>');
                }
                builder.append(") ");
            }
            builder.append("view");
            if (needsCast) {
                builder.append(')');
            }
            builder.append('.').append(listener.setter()).append("(\n");
            builder.append(extraIndent).append("      new ").append(listener.type()).append("() {\n");
            for (ListenerMethod method : ViewInjector.getListenerMethods(listener)) {
                boolean hasReturnType;
                builder.append(extraIndent).append("        @Override public ").append(method.returnType()).append(' ').append(method.name()).append("(\n");
                String[] parameterTypes = method.parameters();
                int count = parameterTypes.length;
                for (int i = 0; i < count; ++i) {
                    builder.append(extraIndent).append("          ").append(parameterTypes[i]).append(" p").append(i);
                    if (i < count - 1) {
                        builder.append(',');
                    }
                    builder.append('\n');
                }
                builder.append(extraIndent).append("        ) {\n");
                builder.append(extraIndent).append("          ");
                boolean bl = hasReturnType = !"void".equals(method.returnType());
                if (hasReturnType) {
                    builder.append("return ");
                }
                if (methodBindings.containsKey(method)) {
                    ListenerBinding binding = methodBindings.get(method);
                    builder.append("target.").append(binding.getName()).append('(');
                    List<Parameter> parameters = binding.getParameters();
                    String[] listenerParameters = method.parameters();
                    int count2 = parameters.size();
                    for (int i = 0; i < count2; ++i) {
                        Parameter parameter = parameters.get(i);
                        int listenerPosition = parameter.getListenerPosition();
                        ViewInjector.emitCastIfNeeded(builder, listenerParameters[listenerPosition], parameter.getType());
                        builder.append('p').append(listenerPosition);
                        if (i >= count2 - 1) continue;
                        builder.append(", ");
                    }
                    builder.append(");");
                } else if (hasReturnType) {
                    builder.append(method.defaultReturn()).append(';');
                }
                builder.append('\n');
                builder.append(extraIndent).append("        }\n");
            }
            builder.append(extraIndent).append("      });\n");
        }
        if (needsNullChecked) {
            builder.append("    }\n");
        }
    }

    static List<ListenerMethod> getListenerMethods(ListenerClass listener) {
        if (listener.method().length == 1) {
            return Arrays.asList(listener.method());
        }
        try {
            ArrayList<ListenerMethod> methods = new ArrayList<ListenerMethod>();
            Class<Enum<?>> callbacks = listener.callbacks();
            for (Enum<?> callbackMethod : callbacks.getEnumConstants()) {
                Field callbackField = callbacks.getField(callbackMethod.name());
                ListenerMethod method = callbackField.getAnnotation(ListenerMethod.class);
                if (method == null) {
                    throw new IllegalStateException(String.format("@%s's %s.%s missing @%s annotation.", callbacks.getEnclosingClass().getSimpleName(), callbacks.getSimpleName(), callbackMethod.name(), ListenerMethod.class.getSimpleName()));
                }
                methods.add(method);
            }
            return methods;
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void emitReset(StringBuilder builder) {
        builder.append("  public static void reset(").append(this.targetClass).append(" target) {\n");
        if (this.parentInjector != null) {
            builder.append("    ").append(this.parentInjector).append(".reset(target);\n\n");
        }
        for (ViewInjection injection : this.viewIdMap.values()) {
            for (ViewBinding viewBinding : injection.getViewBindings()) {
                builder.append("    target.").append(viewBinding.getName()).append(" = null;\n");
            }
        }
        for (CollectionBinding collectionBinding : this.collectionBindings.keySet()) {
            builder.append("    target.").append(collectionBinding.getName()).append(" = null;\n");
        }
        builder.append("  }\n");
    }

    static void emitCastIfNeeded(StringBuilder builder, String viewType) {
        ViewInjector.emitCastIfNeeded(builder, "android.view.View", viewType);
    }

    static void emitCastIfNeeded(StringBuilder builder, String sourceType, String destinationType) {
        if (!sourceType.equals(destinationType)) {
            builder.append('(').append(destinationType).append(") ");
        }
    }

    static void emitHumanDescription(StringBuilder builder, List<Binding> bindings) {
        switch (bindings.size()) {
            case 1: {
                builder.append(bindings.get(0).getDescription());
                break;
            }
            case 2: {
                builder.append(bindings.get(0).getDescription()).append(" and ").append(bindings.get(1).getDescription());
                break;
            }
            default: {
                int count = bindings.size();
                for (int i = 0; i < count; ++i) {
                    Binding requiredField = bindings.get(i);
                    if (i != 0) {
                        builder.append(", ");
                    }
                    if (i == count - 1) {
                        builder.append("and ");
                    }
                    builder.append(requiredField.getDescription());
                }
            }
        }
    }
}

