/*
 * Decompiled with CFR 0.152.
 */
package butterknife.internal;

import butterknife.internal.Binding;
import butterknife.internal.ListenerBinding;
import butterknife.internal.ListenerClass;
import butterknife.internal.ListenerMethod;
import butterknife.internal.ViewBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ViewInjection {
    private final int id;
    private final Set<ViewBinding> viewBindings = new LinkedHashSet<ViewBinding>();
    private final Map<ListenerClass, Map<ListenerMethod, ListenerBinding>> listenerBindings = new LinkedHashMap<ListenerClass, Map<ListenerMethod, ListenerBinding>>();

    ViewInjection(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public Collection<ViewBinding> getViewBindings() {
        return this.viewBindings;
    }

    public Map<ListenerClass, Map<ListenerMethod, ListenerBinding>> getListenerBindings() {
        return this.listenerBindings;
    }

    public boolean hasListenerBinding(ListenerClass listener, ListenerMethod method) {
        Map<ListenerMethod, ListenerBinding> methods = this.listenerBindings.get(listener);
        return methods != null && methods.containsKey(method);
    }

    public void addListenerBinding(ListenerClass listener, ListenerMethod method, ListenerBinding binding) {
        ListenerBinding existing;
        Map<ListenerMethod, ListenerBinding> methods = this.listenerBindings.get(listener);
        if (methods == null) {
            methods = new LinkedHashMap<ListenerMethod, ListenerBinding>();
            this.listenerBindings.put(listener, methods);
        }
        if ((existing = methods.get(method)) != null) {
            throw new IllegalStateException("View " + this.id + " already has listener binding for " + listener.type() + "." + method.name() + " on " + existing.getDescription());
        }
        methods.put(method, binding);
    }

    public void addViewBinding(ViewBinding viewBinding) {
        this.viewBindings.add(viewBinding);
    }

    public List<Binding> getRequiredBindings() {
        ArrayList<Binding> requiredBindings = new ArrayList<Binding>();
        for (ViewBinding viewBinding : this.viewBindings) {
            if (!viewBinding.isRequired()) continue;
            requiredBindings.add(viewBinding);
        }
        for (Map map : this.listenerBindings.values()) {
            for (ListenerBinding binding : map.values()) {
                if (!binding.isRequired()) continue;
                requiredBindings.add(binding);
            }
        }
        return requiredBindings;
    }
}

