/*
 * Decompiled with CFR 0.152.
 */
package butterknife;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.util.Log;
import android.util.Property;
import android.view.View;
import butterknife.ImmutableViewList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ButterKnife {
    private static final String TAG = "ButterKnife";
    private static boolean debug = false;
    static final Map<Class<?>, Method> INJECTORS = new LinkedHashMap();
    static final Map<Class<?>, Method> RESETTERS = new LinkedHashMap();
    static final Method NO_OP = null;

    private ButterKnife() {
        throw new AssertionError((Object)"No instances.");
    }

    public static void setDebug(boolean debug) {
        ButterKnife.debug = debug;
    }

    public static void inject(Activity target) {
        ButterKnife.inject(target, target, Finder.ACTIVITY);
    }

    public static void inject(View target) {
        ButterKnife.inject(target, target, Finder.VIEW);
    }

    public static void inject(Dialog target) {
        ButterKnife.inject(target, target, Finder.DIALOG);
    }

    public static void inject(Object target, Activity source) {
        ButterKnife.inject(target, source, Finder.ACTIVITY);
    }

    public static void inject(Object target, View source) {
        ButterKnife.inject(target, source, Finder.VIEW);
    }

    public static void inject(Object target, Dialog source) {
        ButterKnife.inject(target, source, Finder.DIALOG);
    }

    public static void reset(Object target) {
        Class<?> targetClass = target.getClass();
        try {
            Method reset;
            if (debug) {
                Log.d((String)TAG, (String)("Looking up view injector for " + targetClass.getName()));
            }
            if ((reset = ButterKnife.findResettersForClass(targetClass)) != null) {
                reset.invoke(null, target);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            Throwable t = e;
            if (t instanceof InvocationTargetException) {
                t = t.getCause();
            }
            throw new RuntimeException("Unable to reset views for " + target, t);
        }
    }

    static void inject(Object target, Object source, Finder finder) {
        Class<?> targetClass = target.getClass();
        try {
            Method inject;
            if (debug) {
                Log.d((String)TAG, (String)("Looking up view injector for " + targetClass.getName()));
            }
            if ((inject = ButterKnife.findInjectorForClass(targetClass)) != null) {
                inject.invoke(null, new Object[]{finder, target, source});
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            Throwable t = e;
            if (t instanceof InvocationTargetException) {
                t = t.getCause();
            }
            throw new RuntimeException("Unable to inject views for " + target, t);
        }
    }

    private static Method findInjectorForClass(Class<?> cls) throws NoSuchMethodException {
        Method inject = INJECTORS.get(cls);
        if (inject != null) {
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Cached in injector map.");
            }
            return inject;
        }
        String clsName = cls.getName();
        if (clsName.startsWith("android.") || clsName.startsWith("java.")) {
            if (debug) {
                Log.d((String)TAG, (String)"MISS: Reached framework class. Abandoning search.");
            }
            return NO_OP;
        }
        try {
            Class<?> injector = Class.forName(clsName + "$$ViewInjector");
            inject = injector.getMethod("inject", Finder.class, cls, Object.class);
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Class loaded injection class.");
            }
        }
        catch (ClassNotFoundException e) {
            if (debug) {
                Log.d((String)TAG, (String)("Not found. Trying superclass " + cls.getSuperclass().getName()));
            }
            inject = ButterKnife.findInjectorForClass(cls.getSuperclass());
        }
        INJECTORS.put(cls, inject);
        return inject;
    }

    private static Method findResettersForClass(Class<?> cls) throws NoSuchMethodException {
        Method inject = RESETTERS.get(cls);
        if (inject != null) {
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Cached in injector map.");
            }
            return inject;
        }
        String clsName = cls.getName();
        if (clsName.startsWith("android.") || clsName.startsWith("java.")) {
            if (debug) {
                Log.d((String)TAG, (String)"MISS: Reached framework class. Abandoning search.");
            }
            return NO_OP;
        }
        try {
            Class<?> injector = Class.forName(clsName + "$$ViewInjector");
            inject = injector.getMethod("reset", cls);
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Class loaded injection class.");
            }
        }
        catch (ClassNotFoundException e) {
            if (debug) {
                Log.d((String)TAG, (String)("Not found. Trying superclass " + cls.getSuperclass().getName()));
            }
            inject = ButterKnife.findResettersForClass(cls.getSuperclass());
        }
        RESETTERS.put(cls, inject);
        return inject;
    }

    public static <T extends View> void apply(List<T> list, Action<? super T> action) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            action.apply((View)list.get(i), i);
        }
    }

    public static <T extends View, V> void apply(List<T> list, Setter<? super T, V> setter, V value) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            setter.set((View)list.get(i), value, i);
        }
    }

    @TargetApi(value=14)
    public static <T extends View, V> void apply(List<T> list, Property<? super T, V> setter, V value) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            setter.set(list.get(i), value);
        }
    }

    public static <T extends View> T findById(View view, int id) {
        return (T)view.findViewById(id);
    }

    public static <T extends View> T findById(Activity activity, int id) {
        return (T)activity.findViewById(id);
    }

    public static interface Setter<T extends View, V> {
        public void set(T var1, V var2, int var3);
    }

    public static interface Action<T extends View> {
        public void apply(T var1, int var2);
    }

    public static enum Finder {
        VIEW{

            @Override
            public View findOptionalView(Object source, int id) {
                return ((View)source).findViewById(id);
            }
        }
        ,
        ACTIVITY{

            @Override
            public View findOptionalView(Object source, int id) {
                return ((Activity)source).findViewById(id);
            }
        }
        ,
        DIALOG{

            @Override
            public View findOptionalView(Object source, int id) {
                return ((Dialog)source).findViewById(id);
            }
        };


        public static <T extends View> T[] arrayOf(T ... views) {
            return views;
        }

        public static <T extends View> List<T> listOf(T ... views) {
            return new ImmutableViewList(views);
        }

        public View findRequiredView(Object source, int id, String who) {
            View view = this.findOptionalView(source, id);
            if (view == null) {
                throw new IllegalStateException("Required view with id '" + id + "' for " + who + " was not found. If this view is optional add '@Optional' annotation.");
            }
            return view;
        }

        public abstract View findOptionalView(Object var1, int var2);
    }
}

