/*
 * Decompiled with CFR 0.152.
 */
package butterknife.internal;

import butterknife.internal.Binding;
import butterknife.internal.ListenerBinding;
import butterknife.internal.ListenerClass;
import butterknife.internal.ListenerMethod;
import butterknife.internal.ViewBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ViewInjection {
    private final int id;
    private final Set<ViewBinding> viewBindings = new LinkedHashSet<ViewBinding>();
    private final LinkedHashMap<ListenerClass, Map<ListenerMethod, Set<ListenerBinding>>> listenerBindings = new LinkedHashMap();

    ViewInjection(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public Collection<ViewBinding> getViewBindings() {
        return this.viewBindings;
    }

    public Map<ListenerClass, Map<ListenerMethod, Set<ListenerBinding>>> getListenerBindings() {
        return this.listenerBindings;
    }

    public boolean hasListenerBinding(ListenerClass listener, ListenerMethod method) {
        Map<ListenerMethod, Set<ListenerBinding>> methods = this.listenerBindings.get(listener);
        return methods != null && methods.containsKey(method);
    }

    public void addListenerBinding(ListenerClass listener, ListenerMethod method, ListenerBinding binding) {
        Map<ListenerMethod, Set<ListenerBinding>> methods = this.listenerBindings.get(listener);
        Set<ListenerBinding> set = null;
        if (methods == null) {
            methods = new LinkedHashMap<ListenerMethod, Set<ListenerBinding>>();
            this.listenerBindings.put(listener, methods);
        } else {
            set = methods.get(method);
        }
        if (set == null) {
            set = new LinkedHashSet<ListenerBinding>();
            methods.put(method, set);
        }
        set.add(binding);
    }

    public void addViewBinding(ViewBinding viewBinding) {
        this.viewBindings.add(viewBinding);
    }

    public List<Binding> getRequiredBindings() {
        ArrayList<Binding> requiredBindings = new ArrayList<Binding>();
        for (ViewBinding viewBinding : this.viewBindings) {
            if (!viewBinding.isRequired()) continue;
            requiredBindings.add(viewBinding);
        }
        for (Map map : this.listenerBindings.values()) {
            for (Set set : map.values()) {
                for (ListenerBinding binding : set) {
                    if (!binding.isRequired()) continue;
                    requiredBindings.add(binding);
                }
            }
        }
        return requiredBindings;
    }
}

