/*
 * Decompiled with CFR 0.152.
 */
package butterknife;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.util.Log;
import android.util.Property;
import android.view.View;
import butterknife.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ButterKnife {
    private static final String TAG = "ButterKnife";
    private static boolean debug = false;
    static final Map<Class<?>, ViewBinder<Object>> BINDERS = new LinkedHashMap();
    static final ViewBinder<Object> NOP_VIEW_BINDER = new ViewBinder<Object>(){

        @Override
        public void bind(Finder finder, Object target, Object source) {
        }

        @Override
        public void unbind(Object target) {
        }
    };

    private ButterKnife() {
        throw new AssertionError((Object)"No instances.");
    }

    public static void setDebug(boolean debug) {
        ButterKnife.debug = debug;
    }

    public static void bind(Activity target) {
        ButterKnife.bind(target, target, Finder.ACTIVITY);
    }

    public static void bind(View target) {
        ButterKnife.bind(target, target, Finder.VIEW);
    }

    public static void bind(Dialog target) {
        ButterKnife.bind(target, target, Finder.DIALOG);
    }

    public static void bind(Object target, Activity source) {
        ButterKnife.bind(target, source, Finder.ACTIVITY);
    }

    public static void bind(Object target, View source) {
        ButterKnife.bind(target, source, Finder.VIEW);
    }

    public static void bind(Object target, Dialog source) {
        ButterKnife.bind(target, source, Finder.DIALOG);
    }

    public static void unbind(Object target) {
        Class<?> targetClass = target.getClass();
        try {
            ViewBinder<Object> viewBinder;
            if (debug) {
                Log.d((String)TAG, (String)("Looking up view binder for " + targetClass.getName()));
            }
            if ((viewBinder = ButterKnife.findViewBinderForClass(targetClass)) != null) {
                viewBinder.unbind(target);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to unbind views for " + targetClass.getName(), e);
        }
    }

    static void bind(Object target, Object source, Finder finder) {
        Class<?> targetClass = target.getClass();
        try {
            ViewBinder<Object> viewBinder;
            if (debug) {
                Log.d((String)TAG, (String)("Looking up view binder for " + targetClass.getName()));
            }
            if ((viewBinder = ButterKnife.findViewBinderForClass(targetClass)) != null) {
                viewBinder.bind(finder, target, source);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to bind views for " + targetClass.getName(), e);
        }
    }

    private static ViewBinder<Object> findViewBinderForClass(Class<?> cls) throws IllegalAccessException, InstantiationException {
        ViewBinder viewBinder = BINDERS.get(cls);
        if (viewBinder != null) {
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Cached in view binder map.");
            }
            return viewBinder;
        }
        String clsName = cls.getName();
        if (clsName.startsWith("android.") || clsName.startsWith("java.")) {
            if (debug) {
                Log.d((String)TAG, (String)"MISS: Reached framework class. Abandoning search.");
            }
            return NOP_VIEW_BINDER;
        }
        try {
            Class<?> viewBindingClass = Class.forName(clsName + "$$ViewBinder");
            viewBinder = (ViewBinder)viewBindingClass.newInstance();
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Loaded view binder class.");
            }
        }
        catch (ClassNotFoundException e) {
            if (debug) {
                Log.d((String)TAG, (String)("Not found. Trying superclass " + cls.getSuperclass().getName()));
            }
            viewBinder = ButterKnife.findViewBinderForClass(cls.getSuperclass());
        }
        BINDERS.put(cls, viewBinder);
        return viewBinder;
    }

    public static <T extends View> void apply(List<T> list, Action<? super T> action) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            action.apply((View)list.get(i), i);
        }
    }

    public static <T extends View, V> void apply(List<T> list, Setter<? super T, V> setter, V value) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            setter.set((View)list.get(i), value, i);
        }
    }

    @TargetApi(value=14)
    public static <T extends View, V> void apply(List<T> list, Property<? super T, V> setter, V value) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            setter.set(list.get(i), value);
        }
    }

    public static <T extends View> T findById(View view, int id) {
        return (T)view.findViewById(id);
    }

    public static <T extends View> T findById(Activity activity, int id) {
        return (T)activity.findViewById(id);
    }

    public static <T extends View> T findById(Dialog dialog, int id) {
        return (T)dialog.findViewById(id);
    }

    public static interface Setter<T extends View, V> {
        public void set(T var1, V var2, int var3);
    }

    public static interface Action<T extends View> {
        public void apply(T var1, int var2);
    }

    public static interface ViewBinder<T> {
        public void bind(Finder var1, T var2, Object var3);

        public void unbind(T var1);
    }

    public static enum Finder {
        VIEW{

            @Override
            protected View findView(Object source, int id) {
                return ((View)source).findViewById(id);
            }

            @Override
            public Context getContext(Object source) {
                return ((View)source).getContext();
            }
        }
        ,
        ACTIVITY{

            @Override
            protected View findView(Object source, int id) {
                return ((Activity)source).findViewById(id);
            }

            @Override
            public Context getContext(Object source) {
                return (Activity)source;
            }
        }
        ,
        DIALOG{

            @Override
            protected View findView(Object source, int id) {
                return ((Dialog)source).findViewById(id);
            }

            @Override
            public Context getContext(Object source) {
                return ((Dialog)source).getContext();
            }
        };


        private static <T> T[] filterNull(T[] views) {
            int newSize = views.length;
            for (T view : views) {
                if (view != null) continue;
                --newSize;
            }
            if (newSize == views.length) {
                return views;
            }
            Object[] newViews = new Object[newSize];
            int nextIndex = 0;
            for (T view : views) {
                if (view == null) continue;
                newViews[nextIndex++] = view;
            }
            return newViews;
        }

        public static <T> T[] arrayOf(T ... views) {
            return Finder.filterNull(views);
        }

        public static <T> List<T> listOf(T ... views) {
            return new ImmutableList<T>(Finder.filterNull(views));
        }

        public <T> T findRequiredView(Object source, int id, String who) {
            T view = this.findOptionalView(source, id, who);
            if (view == null) {
                String name = this.getContext(source).getResources().getResourceEntryName(id);
                throw new IllegalStateException("Required view '" + name + "' with ID " + id + " for " + who + " was not found. If this view is optional add '@Nullable' annotation.");
            }
            return view;
        }

        public <T> T findOptionalView(Object source, int id, String who) {
            View view = this.findView(source, id);
            return this.castView(view, id, who);
        }

        public <T> T castView(View view, int id, String who) {
            try {
                return (T)view;
            }
            catch (ClassCastException e) {
                if (who == null) {
                    throw new AssertionError();
                }
                String name = view.getResources().getResourceEntryName(id);
                throw new IllegalStateException("View '" + name + "' with ID " + id + " for " + who + " was of the wrong type. See cause for more info.", e);
            }
        }

        public <T> T castParam(Object value, String from, int fromPosition, String to, int toPosition) {
            try {
                return (T)value;
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Parameter #" + (fromPosition + 1) + " of method '" + from + "' was of the wrong type for parameter #" + (toPosition + 1) + " of method '" + to + "'. See cause for more info.", e);
            }
        }

        protected abstract View findView(Object var1, int var2);

        public abstract Context getContext(Object var1);
    }
}

