/*
 * Decompiled with CFR 0.152.
 */
package butterknife;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.support.annotation.CheckResult;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.Property;
import android.view.View;
import butterknife.Unbinder;
import butterknife.internal.Finder;
import butterknife.internal.ViewBinder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ButterKnife {
    private static final String TAG = "ButterKnife";
    private static boolean debug = false;
    static final Map<Class<?>, ViewBinder<Object>> BINDERS = new LinkedHashMap();
    static final ViewBinder<Object> NOP_VIEW_BINDER = new ViewBinder<Object>(){

        @Override
        public Unbinder bind(Finder finder, Object target, Object source) {
            return Unbinder.EMPTY;
        }
    };

    private ButterKnife() {
        throw new AssertionError((Object)"No instances.");
    }

    public static void setDebug(boolean debug) {
        ButterKnife.debug = debug;
    }

    public static Unbinder bind(@NonNull Activity target) {
        return ButterKnife.bind(target, target, Finder.ACTIVITY);
    }

    @NonNull
    public static Unbinder bind(@NonNull View target) {
        return ButterKnife.bind(target, target, Finder.VIEW);
    }

    public static Unbinder bind(@NonNull Dialog target) {
        return ButterKnife.bind(target, target, Finder.DIALOG);
    }

    public static Unbinder bind(@NonNull Object target, @NonNull Activity source) {
        return ButterKnife.bind(target, source, Finder.ACTIVITY);
    }

    @NonNull
    public static Unbinder bind(@NonNull Object target, @NonNull View source) {
        return ButterKnife.bind(target, source, Finder.VIEW);
    }

    public static Unbinder bind(@NonNull Object target, @NonNull Dialog source) {
        return ButterKnife.bind(target, source, Finder.DIALOG);
    }

    static Unbinder bind(@NonNull Object target, @NonNull Object source, @NonNull Finder finder) {
        Class<?> targetClass = target.getClass();
        try {
            if (debug) {
                Log.d((String)TAG, (String)("Looking up view binder for " + targetClass.getName()));
            }
            ViewBinder<Object> viewBinder = ButterKnife.findViewBinderForClass(targetClass);
            return viewBinder.bind(finder, target, source);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to bind views for " + targetClass.getName(), e);
        }
    }

    @NonNull
    private static ViewBinder<Object> findViewBinderForClass(Class<?> cls) throws IllegalAccessException, InstantiationException {
        ViewBinder viewBinder = BINDERS.get(cls);
        if (viewBinder != null) {
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Cached in view binder map.");
            }
            return viewBinder;
        }
        String clsName = cls.getName();
        if (clsName.startsWith("android.") || clsName.startsWith("java.")) {
            if (debug) {
                Log.d((String)TAG, (String)"MISS: Reached framework class. Abandoning search.");
            }
            return NOP_VIEW_BINDER;
        }
        try {
            Class<?> viewBindingClass = Class.forName(clsName + "$$ViewBinder");
            viewBinder = (ViewBinder)viewBindingClass.newInstance();
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Loaded view binder class.");
            }
        }
        catch (ClassNotFoundException e) {
            if (debug) {
                Log.d((String)TAG, (String)("Not found. Trying superclass " + cls.getSuperclass().getName()));
            }
            viewBinder = ButterKnife.findViewBinderForClass(cls.getSuperclass());
        }
        BINDERS.put(cls, viewBinder);
        return viewBinder;
    }

    @SafeVarargs
    public static <T extends View> void apply(@NonNull List<T> list, Action<? super T> ... actions) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            for (Action<View> action : actions) {
                action.apply((View)list.get(i), i);
            }
        }
    }

    @SafeVarargs
    public static <T extends View> void apply(@NonNull T[] array, Action<? super T> ... actions) {
        int count = array.length;
        for (int i = 0; i < count; ++i) {
            for (Action<T> action : actions) {
                action.apply(array[i], i);
            }
        }
    }

    public static <T extends View> void apply(@NonNull List<T> list, @NonNull Action<? super T> action) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            action.apply((View)list.get(i), i);
        }
    }

    public static <T extends View> void apply(@NonNull T[] array, @NonNull Action<? super T> action) {
        int count = array.length;
        for (int i = 0; i < count; ++i) {
            action.apply(array[i], i);
        }
    }

    @SafeVarargs
    public static <T extends View> void apply(@NonNull T view, Action<? super T> ... actions) {
        for (Action<T> action : actions) {
            action.apply(view, 0);
        }
    }

    public static <T extends View> void apply(@NonNull T view, @NonNull Action<? super T> action) {
        action.apply(view, 0);
    }

    public static <T extends View, V> void apply(@NonNull List<T> list, @NonNull Setter<? super T, V> setter, V value) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            setter.set((View)list.get(i), value, i);
        }
    }

    public static <T extends View, V> void apply(@NonNull T[] array, @NonNull Setter<? super T, V> setter, V value) {
        int count = array.length;
        for (int i = 0; i < count; ++i) {
            setter.set(array[i], value, i);
        }
    }

    public static <T extends View, V> void apply(@NonNull T view, @NonNull Setter<? super T, V> setter, V value) {
        setter.set(view, value, 0);
    }

    @TargetApi(value=14)
    public static <T extends View, V> void apply(@NonNull List<T> list, @NonNull Property<? super T, V> setter, V value) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            setter.set(list.get(i), value);
        }
    }

    @TargetApi(value=14)
    public static <T extends View, V> void apply(@NonNull T[] array, @NonNull Property<? super T, V> setter, V value) {
        int count = array.length;
        for (int i = 0; i < count; ++i) {
            setter.set(array[i], value);
        }
    }

    @TargetApi(value=14)
    public static <T extends View, V> void apply(@NonNull T view, @NonNull Property<? super T, V> setter, V value) {
        setter.set(view, value);
    }

    @CheckResult
    public static <T extends View> T findById(@NonNull View view, @IdRes int id) {
        return (T)view.findViewById(id);
    }

    @CheckResult
    public static <T extends View> T findById(@NonNull Activity activity, @IdRes int id) {
        return (T)activity.findViewById(id);
    }

    @CheckResult
    public static <T extends View> T findById(@NonNull Dialog dialog, @IdRes int id) {
        return (T)dialog.findViewById(id);
    }

    public static interface Setter<T extends View, V> {
        public void set(@NonNull T var1, V var2, int var3);
    }

    public static interface Action<T extends View> {
        public void apply(@NonNull T var1, int var2);
    }
}

