/*
 * Decompiled with CFR 0.152.
 */
package butterknife;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.support.annotation.CheckResult;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.util.Property;
import android.view.View;
import butterknife.Unbinder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ButterKnife {
    private static final String TAG = "ButterKnife";
    private static boolean debug = false;
    @VisibleForTesting
    static final Map<Class<?>, Constructor<? extends Unbinder>> BINDINGS = new LinkedHashMap();

    private ButterKnife() {
        throw new AssertionError((Object)"No instances.");
    }

    public static void setDebug(boolean debug) {
        ButterKnife.debug = debug;
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull Activity target) {
        View sourceView = target.getWindow().getDecorView();
        return ButterKnife.createBinding(target, sourceView);
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull View target) {
        return ButterKnife.createBinding(target, target);
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull Dialog target) {
        View sourceView = target.getWindow().getDecorView();
        return ButterKnife.createBinding(target, sourceView);
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull Object target, @NonNull Activity source) {
        View sourceView = source.getWindow().getDecorView();
        return ButterKnife.createBinding(target, sourceView);
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull Object target, @NonNull View source) {
        return ButterKnife.createBinding(target, source);
    }

    @NonNull
    @UiThread
    public static Unbinder bind(@NonNull Object target, @NonNull Dialog source) {
        View sourceView = source.getWindow().getDecorView();
        return ButterKnife.createBinding(target, sourceView);
    }

    private static Unbinder createBinding(@NonNull Object target, @NonNull View source) {
        Constructor<? extends Unbinder> constructor;
        Class<?> targetClass = target.getClass();
        if (debug) {
            Log.d((String)TAG, (String)("Looking up binding for " + targetClass.getName()));
        }
        if ((constructor = ButterKnife.findBindingConstructorForClass(targetClass)) == null) {
            return Unbinder.EMPTY;
        }
        try {
            return constructor.newInstance(target, source);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to invoke " + constructor, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to invoke " + constructor, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException("Unable to create binding instance.", cause);
        }
    }

    @Nullable
    @CheckResult
    @UiThread
    private static Constructor<? extends Unbinder> findBindingConstructorForClass(Class<?> cls) {
        Constructor<Unbinder> bindingCtor = BINDINGS.get(cls);
        if (bindingCtor != null) {
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Cached in binding map.");
            }
            return bindingCtor;
        }
        String clsName = cls.getName();
        if (clsName.startsWith("android.") || clsName.startsWith("java.")) {
            if (debug) {
                Log.d((String)TAG, (String)"MISS: Reached framework class. Abandoning search.");
            }
            return null;
        }
        try {
            Class<?> bindingClass = cls.getClassLoader().loadClass(clsName + "_ViewBinding");
            bindingCtor = bindingClass.getConstructor(cls, View.class);
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Loaded binding class and constructor.");
            }
        }
        catch (ClassNotFoundException e) {
            if (debug) {
                Log.d((String)TAG, (String)("Not found. Trying superclass " + cls.getSuperclass().getName()));
            }
            bindingCtor = ButterKnife.findBindingConstructorForClass(cls.getSuperclass());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find binding constructor for " + clsName, e);
        }
        BINDINGS.put(cls, bindingCtor);
        return bindingCtor;
    }

    @SafeVarargs
    @UiThread
    public static <T extends View> void apply(@NonNull List<T> list, Action<? super T> ... actions) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            for (Action<View> action : actions) {
                action.apply((View)list.get(i), i);
            }
        }
    }

    @SafeVarargs
    @UiThread
    public static <T extends View> void apply(@NonNull T[] array, Action<? super T> ... actions) {
        int count = array.length;
        for (int i = 0; i < count; ++i) {
            for (Action<T> action : actions) {
                action.apply(array[i], i);
            }
        }
    }

    @UiThread
    public static <T extends View> void apply(@NonNull List<T> list, @NonNull Action<? super T> action) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            action.apply((View)list.get(i), i);
        }
    }

    @UiThread
    public static <T extends View> void apply(@NonNull T[] array, @NonNull Action<? super T> action) {
        int count = array.length;
        for (int i = 0; i < count; ++i) {
            action.apply(array[i], i);
        }
    }

    @SafeVarargs
    @UiThread
    public static <T extends View> void apply(@NonNull T view, Action<? super T> ... actions) {
        for (Action<T> action : actions) {
            action.apply(view, 0);
        }
    }

    @UiThread
    public static <T extends View> void apply(@NonNull T view, @NonNull Action<? super T> action) {
        action.apply(view, 0);
    }

    @UiThread
    public static <T extends View, V> void apply(@NonNull List<T> list, @NonNull Setter<? super T, V> setter, V value) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            setter.set((View)list.get(i), value, i);
        }
    }

    @UiThread
    public static <T extends View, V> void apply(@NonNull T[] array, @NonNull Setter<? super T, V> setter, V value) {
        int count = array.length;
        for (int i = 0; i < count; ++i) {
            setter.set(array[i], value, i);
        }
    }

    @UiThread
    public static <T extends View, V> void apply(@NonNull T view, @NonNull Setter<? super T, V> setter, V value) {
        setter.set(view, value, 0);
    }

    @TargetApi(value=14)
    @RequiresApi(value=14)
    @UiThread
    public static <T extends View, V> void apply(@NonNull List<T> list, @NonNull Property<? super T, V> setter, V value) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            setter.set(list.get(i), value);
        }
    }

    @TargetApi(value=14)
    @RequiresApi(value=14)
    @UiThread
    public static <T extends View, V> void apply(@NonNull T[] array, @NonNull Property<? super T, V> setter, V value) {
        int count = array.length;
        for (int i = 0; i < count; ++i) {
            setter.set(array[i], value);
        }
    }

    @TargetApi(value=14)
    @RequiresApi(value=14)
    @UiThread
    public static <T extends View, V> void apply(@NonNull T view, @NonNull Property<? super T, V> setter, V value) {
        setter.set(view, value);
    }

    @CheckResult
    public static <T extends View> T findById(@NonNull View view, @IdRes int id) {
        return (T)view.findViewById(id);
    }

    @CheckResult
    public static <T extends View> T findById(@NonNull Activity activity, @IdRes int id) {
        return (T)activity.findViewById(id);
    }

    @CheckResult
    public static <T extends View> T findById(@NonNull Dialog dialog, @IdRes int id) {
        return (T)dialog.findViewById(id);
    }

    public static interface Setter<T extends View, V> {
        @UiThread
        public void set(@NonNull T var1, V var2, int var3);
    }

    public static interface Action<T extends View> {
        @UiThread
        public void apply(@NonNull T var1, int var2);
    }
}

