/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.crossword;

import com.jakewharton.crossword.TextCanvas;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/jakewharton/crossword/ClippedTextCanvas;", "Lcom/jakewharton/crossword/TextCanvas;", "canvas", "left", "", "right", "top", "bottom", "(Lcom/jakewharton/crossword/TextCanvas;IIII)V", "height", "getHeight", "()I", "width", "getWidth", "toString", "", "write", "", "row", "column", "char", "", "string", "crossword"})
final class ClippedTextCanvas
implements TextCanvas {
    @NotNull
    private final TextCanvas canvas;
    private final int left;
    private final int top;
    private final int width;
    private final int height;

    public ClippedTextCanvas(@NotNull TextCanvas canvas, int left, int right, int top, int bottom) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.canvas = canvas;
        this.left = left;
        this.top = top;
        this.width = right - this.left;
        this.height = bottom - this.top;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void write(int row, int column, char c) {
        this.canvas.write(this.top + row, this.left + column, c);
    }

    @Override
    public void write(int row, int column, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.canvas.write(this.top + row, this.left + column, string);
    }

    @Override
    @NotNull
    public String toString() {
        throw new UnsupportedOperationException("Rendering a clipped canvas is not supported");
    }
}

