/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;

public final class DaggerCodegen {
    public static <C> C create(Class<C> componentClass) {
        return DaggerCodegen.invokeStatic(DaggerCodegen.findImplementationClass(componentClass), "create", componentClass);
    }

    public static <B> B builder(Class<B> builderClass) {
        Class<?> componentClass = builderClass.getEnclosingClass();
        if (componentClass == null) {
            throw new IllegalArgumentException(builderClass.getCanonicalName() + " is not a nested type inside of a component interface");
        }
        return DaggerCodegen.invokeStatic(DaggerCodegen.findImplementationClass(componentClass), "builder", builderClass);
    }

    public static <F> F factory(Class<F> factoryClass) {
        Class<?> componentClass = factoryClass.getEnclosingClass();
        if (componentClass == null) {
            throw new IllegalArgumentException(factoryClass.getCanonicalName() + " is not a nested type inside of a component interface");
        }
        return DaggerCodegen.invokeStatic(DaggerCodegen.findImplementationClass(componentClass), "factory", factoryClass);
    }

    private static <C> Class<? extends C> findImplementationClass(Class<C> componentClass) {
        String implementationName = DaggerCodegen.deduceImplementationClassName(componentClass);
        try {
            Class<?> implementationClass = componentClass.getClassLoader().loadClass(implementationName);
            return implementationClass;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to find generated component implementation " + implementationName + " for component " + componentClass.getName(), e);
        }
    }

    private static <C> String deduceImplementationClassName(Class<C> componentClass) {
        ArrayDeque classes = new ArrayDeque();
        for (Class<?> nesting = componentClass.getEnclosingClass(); nesting != null; nesting = nesting.getEnclosingClass()) {
            classes.addFirst(nesting);
        }
        StringBuilder daggerName = new StringBuilder();
        daggerName.append(componentClass.getPackage().getName());
        daggerName.append(".Dagger");
        for (Class clazz : classes) {
            daggerName.append(clazz.getSimpleName());
            daggerName.append('_');
        }
        daggerName.append(componentClass.getSimpleName());
        return daggerName.toString();
    }

    private static <T> T invokeStatic(Class<?> target, String name, Class<T> returnType) {
        Object returnValue;
        Method method;
        try {
            method = target.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to find method '" + name + "' on " + target, e);
        }
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            returnValue = method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to invoke method '" + name + "' on " + target, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException("Exception while reflectively invoking method", e);
        }
        return returnType.cast(returnValue);
    }

    private DaggerCodegen() {
        throw new AssertionError();
    }
}

