/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.espresso;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.test.espresso.IdlingResource;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;

public final class OkHttp3IdlingResource
implements IdlingResource {
    private final String name;
    private final Dispatcher dispatcher;
    volatile IdlingResource.ResourceCallback callback;

    @CheckResult
    @NonNull
    public static OkHttp3IdlingResource create(@NonNull String name, @NonNull OkHttpClient client) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (client == null) {
            throw new NullPointerException("client == null");
        }
        return new OkHttp3IdlingResource(name, client.dispatcher());
    }

    private OkHttp3IdlingResource(String name, Dispatcher dispatcher) {
        this.name = name;
        this.dispatcher = dispatcher;
        dispatcher.setIdleCallback(new Runnable(){

            @Override
            public void run() {
                IdlingResource.ResourceCallback callback = OkHttp3IdlingResource.this.callback;
                if (callback != null) {
                    callback.onTransitionToIdle();
                }
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public boolean isIdleNow() {
        return this.dispatcher.runningCallsCount() == 0;
    }

    public void registerIdleTransitionCallback(IdlingResource.ResourceCallback callback) {
        this.callback = callback;
    }
}

