/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.nopen.checker;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.jakewharton.nopen.annotation.Open;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;

@BugPattern(name="Nopen", summary="Classes should be explicitly marked final, abstract, or @Open", explanation="Java creates new types as open by default which can be dangerous. This checker ensures that the intent to leave a class open is explicitly declared. For more information see Item 19 of Effective Java, Third Edition.", linkType=BugPattern.LinkType.CUSTOM, link="https://github.com/JakeWharton/nopen#usage", severity=BugPattern.SeverityLevel.ERROR)
public final class NopenChecker
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String OPEN_FQCN = Open.class.getCanonicalName();

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (tree.getKind() != Tree.Kind.CLASS) {
            return Description.NO_MATCH;
        }
        ModifiersTree modifiers = tree.getModifiers();
        Set<Modifier> modifierFlags = modifiers.getFlags();
        if (modifierFlags.contains((Object)Modifier.FINAL) || modifierFlags.contains((Object)Modifier.ABSTRACT)) {
            return Description.NO_MATCH;
        }
        switch (ASTHelpers.getSymbol((ClassTree)tree).getNestingKind()) {
            case LOCAL: 
            case ANONYMOUS: {
                return Description.NO_MATCH;
            }
            case MEMBER: {
                if (!modifierFlags.contains((Object)Modifier.PRIVATE)) break;
                return Description.NO_MATCH;
            }
        }
        for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
            AnnotationMirror annotationMirror = ASTHelpers.getAnnotationMirror((AnnotationTree)annotationTree);
            if (!annotationMirror.getAnnotationType().toString().equals(OPEN_FQCN)) continue;
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

