/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.picasso;

import android.content.Context;
import android.net.Uri;
import android.os.StatFs;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.NetworkPolicy;
import java.io.File;
import java.io.IOException;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class OkHttp3Downloader
implements Downloader {
    private static final String PICASSO_CACHE = "picasso-cache";
    private static final int MIN_DISK_CACHE_SIZE = 0x500000;
    private static final int MAX_DISK_CACHE_SIZE = 0x3200000;
    private final Call.Factory client;
    private final Cache cache;

    private static File defaultCacheDir(Context context) {
        File cache = new File(context.getApplicationContext().getCacheDir(), PICASSO_CACHE);
        if (!cache.exists()) {
            cache.mkdirs();
        }
        return cache;
    }

    private static long calculateDiskCacheSize(File dir) {
        long size = 0x500000L;
        try {
            StatFs statFs = new StatFs(dir.getAbsolutePath());
            long available = (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
            size = available / 50L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Math.max(Math.min(size, 0x3200000L), 0x500000L);
    }

    public static Cache createDefaultCache(Context context) {
        File dir = OkHttp3Downloader.defaultCacheDir(context);
        return new Cache(dir, OkHttp3Downloader.calculateDiskCacheSize(dir));
    }

    private static OkHttpClient createOkHttpClient(File cacheDir, long maxSize) {
        return new OkHttpClient.Builder().cache(new Cache(cacheDir, maxSize)).build();
    }

    public OkHttp3Downloader(Context context) {
        this(OkHttp3Downloader.defaultCacheDir(context));
    }

    public OkHttp3Downloader(File cacheDir) {
        this(cacheDir, OkHttp3Downloader.calculateDiskCacheSize(cacheDir));
    }

    public OkHttp3Downloader(Context context, long maxSize) {
        this(OkHttp3Downloader.defaultCacheDir(context), maxSize);
    }

    public OkHttp3Downloader(File cacheDir, long maxSize) {
        this(OkHttp3Downloader.createOkHttpClient(cacheDir, maxSize));
    }

    public OkHttp3Downloader(OkHttpClient client) {
        this.client = client;
        this.cache = client.cache();
    }

    public OkHttp3Downloader(Call.Factory client) {
        this.client = client;
        this.cache = null;
    }

    public Downloader.Response load(Uri uri, int networkPolicy) throws IOException {
        Response response;
        int responseCode;
        CacheControl.Builder builder;
        CacheControl cacheControl = null;
        if (networkPolicy != 0) {
            if (NetworkPolicy.isOfflineOnly((int)networkPolicy)) {
                cacheControl = CacheControl.FORCE_CACHE;
            } else {
                builder = new CacheControl.Builder();
                if (!NetworkPolicy.shouldReadFromDiskCache((int)networkPolicy)) {
                    builder.noCache();
                }
                if (!NetworkPolicy.shouldWriteToDiskCache((int)networkPolicy)) {
                    builder.noStore();
                }
                cacheControl = builder.build();
            }
        }
        builder = new Request.Builder().url(uri.toString());
        if (cacheControl != null) {
            builder.cacheControl(cacheControl);
        }
        if ((responseCode = (response = this.client.newCall(builder.build()).execute()).code()) >= 300) {
            response.body().close();
            throw new Downloader.ResponseException(responseCode + " " + response.message(), networkPolicy, responseCode);
        }
        boolean fromCache = response.cacheResponse() != null;
        ResponseBody responseBody = response.body();
        return new Downloader.Response(responseBody.byteStream(), fromCache, responseBody.contentLength());
    }

    public void shutdown() {
        if (this.cache != null) {
            try {
                this.cache.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

